/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.MountPointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MountPoint
implements StructuredPojo,
ToCopyableBuilder<Builder, MountPoint> {
    private final String containerPath;
    private final Boolean readOnly;
    private final String sourceVolume;

    private MountPoint(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
        this.sourceVolume = builder.sourceVolume;
    }

    public String containerPath() {
        return this.containerPath;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public String sourceVolume() {
        return this.sourceVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVolume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint)obj;
        return Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.sourceVolume(), other.sourceVolume());
    }

    public String toString() {
        return ToString.builder((String)"MountPoint").add("ContainerPath", (Object)this.containerPath()).add("ReadOnly", (Object)this.readOnly()).add("SourceVolume", (Object)this.sourceVolume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerPath": {
                return Optional.of(clazz.cast(this.containerPath()));
            }
            case "readOnly": {
                return Optional.of(clazz.cast(this.readOnly()));
            }
            case "sourceVolume": {
                return Optional.of(clazz.cast(this.sourceVolume()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MountPointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private Boolean readOnly;
        private String sourceVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            this.containerPath(model.containerPath);
            this.readOnly(model.readOnly);
            this.sourceVolume(model.sourceVolume);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final String getSourceVolume() {
            return this.sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        public MountPoint build() {
            return new MountPoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MountPoint> {
        public Builder containerPath(String var1);

        public Builder readOnly(Boolean var1);

        public Builder sourceVolume(String var1);
    }
}

