/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComputeEnvironmentsRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeComputeEnvironmentsRequest.Builder, DescribeComputeEnvironmentsRequest> {
    private final List<String> computeEnvironments;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeComputeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
     */
    public List<String> computeEnvironments() {
        return computeEnvironments;
    }

    /**
     * <p>
     * The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated output.
     * When this parameter is used, <code>DescribeComputeEnvironments</code> only returns <code>maxResults</code>
     * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
     * initial request can be seen by sending another <code>DescribeComputeEnvironments</code> request with the returned
     * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
     * <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if
     * applicable.
     * </p>
     * 
     * @return The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated
     *         output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This
     *         value can be between 1 and 100. If this parameter is not used, then
     *         <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code>
     * request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results
     *         to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsRequest)) {
            return false;
        }
        DescribeComputeEnvironmentsRequest other = (DescribeComputeEnvironmentsRequest) obj;
        return Objects.equals(computeEnvironments(), other.computeEnvironments())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeComputeEnvironmentsRequest").add("ComputeEnvironments", computeEnvironments())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironments":
            return Optional.of(clazz.cast(computeEnvironments()));
        case "maxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchRequest.Builder, CopyableBuilder<Builder, DescribeComputeEnvironmentsRequest> {
        /**
         * <p>
         * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param computeEnvironments
         *        A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(Collection<String> computeEnvironments);

        /**
         * <p>
         * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param computeEnvironments
         *        A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(String... computeEnvironments);

        /**
         * <p>
         * The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated
         * output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
         * <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The
         * remaining results of the initial request can be seen by sending another
         * <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This value
         * can be between 1 and 100. If this parameter is not used, then <code>DescribeComputeEnvironments</code>
         * returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in
         *        paginated output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This
         *        value can be between 1 and 100. If this parameter is not used, then
         *        <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value
         *        if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the
         *        results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are
         *        no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<String> computeEnvironments;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsRequest model) {
            computeEnvironments(model.computeEnvironments);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getComputeEnvironments() {
            return computeEnvironments;
        }

        @Override
        public final Builder computeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(String... computeEnvironments) {
            computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputeEnvironmentsRequest build() {
            return new DescribeComputeEnvironmentsRequest(this);
        }
    }
}
