/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeComputeEnvironmentsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeComputeEnvironmentsResponse.Builder, DescribeComputeEnvironmentsResponse> {
    private final List<ComputeEnvironmentDetail> computeEnvironments;

    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of compute environments.
     */
    public List<ComputeEnvironmentDetail> computeEnvironments() {
        return computeEnvironments;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request. When
     * the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
     *         When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse) obj;
        return Objects.equals(computeEnvironments(), other.computeEnvironments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeComputeEnvironmentsResponse").add("ComputeEnvironments", computeEnvironments())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironments":
            return Optional.of(clazz.cast(computeEnvironments()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends BatchResponse.Builder, CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments);

        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
         * When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code>
         *        request. When the results of a <code>DescribeJobDefinitions</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            computeEnvironments(model.computeEnvironments);
            nextToken(model.nextToken);
        }

        public final Collection<ComputeEnvironmentDetail.Builder> getComputeEnvironments() {
            return computeEnvironments != null ? computeEnvironments.stream().map(ComputeEnvironmentDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments) {
            computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail.BuilderImpl> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copyFromBuilder(computeEnvironments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }
    }
}
