/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.HostMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contents of the <code>host</code> parameter determine whether your data volume persists on the host container
 * instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for your
 * data volume, but the data is not guaranteed to persist after the containers associated with it stop running.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Host implements StructuredPojo, ToCopyableBuilder<Host.Builder, Host> {
    private final String sourcePath;

    private Host(BuilderImpl builder) {
        this.sourcePath = builder.sourcePath;
    }

    /**
     * <p>
     * The path on the host container instance that is presented to the container. If this parameter is empty, then the
     * Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a
     * <code>sourcePath</code> file location, then the data volume persists at the specified location on the host
     * container instance until you delete it manually. If the <code>sourcePath</code> value does not exist on the host
     * container instance, the Docker daemon creates it. If the location does exist, the contents of the source path
     * folder are exported.
     * </p>
     * 
     * @return The path on the host container instance that is presented to the container. If this parameter is empty,
     *         then the Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a
     *         <code>sourcePath</code> file location, then the data volume persists at the specified location on the
     *         host container instance until you delete it manually. If the <code>sourcePath</code> value does not exist
     *         on the host container instance, the Docker daemon creates it. If the location does exist, the contents of
     *         the source path folder are exported.
     */
    public String sourcePath() {
        return sourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(sourcePath(), other.sourcePath());
    }

    @Override
    public String toString() {
        return ToString.builder("Host").add("SourcePath", sourcePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourcePath":
            return Optional.of(clazz.cast(sourcePath()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HostMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * The path on the host container instance that is presented to the container. If this parameter is empty, then
         * the Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a
         * <code>sourcePath</code> file location, then the data volume persists at the specified location on the host
         * container instance until you delete it manually. If the <code>sourcePath</code> value does not exist on the
         * host container instance, the Docker daemon creates it. If the location does exist, the contents of the source
         * path folder are exported.
         * </p>
         * 
         * @param sourcePath
         *        The path on the host container instance that is presented to the container. If this parameter is
         *        empty, then the Docker daemon has assigned a host path for you. If the <code>host</code> parameter
         *        contains a <code>sourcePath</code> file location, then the data volume persists at the specified
         *        location on the host container instance until you delete it manually. If the <code>sourcePath</code>
         *        value does not exist on the host container instance, the Docker daemon creates it. If the location
         *        does exist, the contents of the source path folder are exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            sourcePath(model.sourcePath);
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public Host build() {
            return new Host(this);
        }
    }
}
