/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ComputeResource} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ComputeResourceMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<Integer> MINVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minvCpus").isBinary(false).build();

    private static final MarshallingInfo<Integer> MAXVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxvCpus").isBinary(false).build();

    private static final MarshallingInfo<Integer> DESIREDVCPUS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredvCpus").isBinary(false).build();

    private static final MarshallingInfo<List> INSTANCETYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTypes").isBinary(false).build();

    private static final MarshallingInfo<String> IMAGEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").isBinary(false).build();

    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").isBinary(false).build();

    private static final MarshallingInfo<List> SECURITYGROUPIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroupIds").isBinary(false).build();

    private static final MarshallingInfo<String> EC2KEYPAIR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2KeyPair").isBinary(false).build();

    private static final MarshallingInfo<String> INSTANCEROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceRole").isBinary(false).build();

    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();

    private static final MarshallingInfo<Integer> BIDPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bidPercentage").isBinary(false).build();

    private static final MarshallingInfo<String> SPOTIAMFLEETROLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spotIamFleetRole").isBinary(false).build();

    private static final ComputeResourceMarshaller INSTANCE = new ComputeResourceMarshaller();

    private ComputeResourceMarshaller() {
    }

    public static ComputeResourceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ComputeResource computeResource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(computeResource, "computeResource");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(computeResource.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall(computeResource.minvCpus(), MINVCPUS_BINDING);
            protocolMarshaller.marshall(computeResource.maxvCpus(), MAXVCPUS_BINDING);
            protocolMarshaller.marshall(computeResource.desiredvCpus(), DESIREDVCPUS_BINDING);
            protocolMarshaller.marshall(computeResource.instanceTypes(), INSTANCETYPES_BINDING);
            protocolMarshaller.marshall(computeResource.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall(computeResource.subnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(computeResource.securityGroupIds(), SECURITYGROUPIDS_BINDING);
            protocolMarshaller.marshall(computeResource.ec2KeyPair(), EC2KEYPAIR_BINDING);
            protocolMarshaller.marshall(computeResource.instanceRole(), INSTANCEROLE_BINDING);
            protocolMarshaller.marshall(computeResource.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(computeResource.bidPercentage(), BIDPERCENTAGE_BINDING);
            protocolMarshaller.marshall(computeResource.spotIamFleetRole(), SPOTIAMFLEETROLE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
