/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch compute environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeEnvironmentDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeEnvironmentDetail.Builder, ComputeEnvironmentDetail> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::computeEnvironmentName)).setter(setter(Builder::computeEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build())
            .build();

    private static final SdkField<String> COMPUTE_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::computeEnvironmentArn)).setter(setter(Builder::computeEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentArn").build())
            .build();

    private static final SdkField<String> ECS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::ecsClusterArn)).setter(setter(Builder::ecsClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsClusterArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<ComputeResource> COMPUTE_RESOURCES_FIELD = SdkField
            .<ComputeResource> builder(MarshallingType.SDK_POJO).getter(getter(ComputeEnvironmentDetail::computeResources))
            .setter(setter(Builder::computeResources)).constructor(ComputeResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentDetail::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPUTE_ENVIRONMENT_NAME_FIELD, COMPUTE_ENVIRONMENT_ARN_FIELD, ECS_CLUSTER_ARN_FIELD, TYPE_FIELD, STATE_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computeEnvironmentName;

    private final String computeEnvironmentArn;

    private final String ecsClusterArn;

    private final String type;

    private final String state;

    private final String status;

    private final String statusReason;

    private final ComputeResource computeResources;

    private final String serviceRole;

    private ComputeEnvironmentDetail(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    /**
     * <p>
     * The name of the compute environment.
     * </p>
     * 
     * @return The name of the compute environment.
     */
    public String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public String computeEnvironmentArn() {
        return computeEnvironmentArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public CEType type() {
        return CEType.fromValue(type);
    }

    /**
     * <p>
     * The type of the compute environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the compute environment.
     * @see CEType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an associated
     * job queue on the compute resources within the environment. If the compute environment is managed, then it can
     * scale its instances out or in automatically, based on the job queue demand.
     * </p>
     * <p>
     * If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within the
     * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed
     * compute environments in the <code>DISABLED</code> state do not scale out. However, they scale in to
     * <code>minvCpus</code> value after instances become idle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     *         </p>
     *         <p>
     *         If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
     *         associated job queue on the compute resources within the environment. If the compute environment is
     *         managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *         </p>
     *         <p>
     *         If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within
     *         the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress
     *         normally. Managed compute environments in the <code>DISABLED</code> state do not scale out. However, they
     *         scale in to <code>minvCpus</code> value after instances become idle.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an associated
     * job queue on the compute resources within the environment. If the compute environment is managed, then it can
     * scale its instances out or in automatically, based on the job queue demand.
     * </p>
     * <p>
     * If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within the
     * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed
     * compute environments in the <code>DISABLED</code> state do not scale out. However, they scale in to
     * <code>minvCpus</code> value after instances become idle.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
     *         </p>
     *         <p>
     *         If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
     *         associated job queue on the compute resources within the environment. If the compute environment is
     *         managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *         </p>
     *         <p>
     *         If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within
     *         the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress
     *         normally. Managed compute environments in the <code>DISABLED</code> state do not scale out. However, they
     *         scale in to <code>minvCpus</code> value after instances become idle.
     * @see CEState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see CEStatus
     */
    public CEStatus status() {
        return CEStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CEStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
     * @see CEStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the compute environment.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the compute
     *         environment.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The compute resources defined for the compute environment.
     * </p>
     * 
     * @return The compute resources defined for the compute environment.
     */
    public ComputeResource computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
     * operations on your behalf.
     * </p>
     * 
     * @return The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
     *         operations on your behalf.
     */
    public String serviceRole() {
        return serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentDetail)) {
            return false;
        }
        ComputeEnvironmentDetail other = (ComputeEnvironmentDetail) obj;
        return Objects.equals(computeEnvironmentName(), other.computeEnvironmentName())
                && Objects.equals(computeEnvironmentArn(), other.computeEnvironmentArn())
                && Objects.equals(ecsClusterArn(), other.ecsClusterArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(computeResources(), other.computeResources())
                && Objects.equals(serviceRole(), other.serviceRole());
    }

    @Override
    public String toString() {
        return ToString.builder("ComputeEnvironmentDetail").add("ComputeEnvironmentName", computeEnvironmentName())
                .add("ComputeEnvironmentArn", computeEnvironmentArn()).add("EcsClusterArn", ecsClusterArn())
                .add("Type", typeAsString()).add("State", stateAsString()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("ComputeResources", computeResources())
                .add("ServiceRole", serviceRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironmentName":
            return Optional.ofNullable(clazz.cast(computeEnvironmentName()));
        case "computeEnvironmentArn":
            return Optional.ofNullable(clazz.cast(computeEnvironmentArn()));
        case "ecsClusterArn":
            return Optional.ofNullable(clazz.cast(ecsClusterArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "computeResources":
            return Optional.ofNullable(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeEnvironmentDetail, T> g) {
        return obj -> g.apply((ComputeEnvironmentDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeEnvironmentDetail> {
        /**
         * <p>
         * The name of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentArn
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentArn(String computeEnvironmentArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
         * </p>
         * 
         * @param ecsClusterArn
         *        The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the compute environment.
         * </p>
         * 
         * @param type
         *        The type of the compute environment.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(CEType type);

        /**
         * <p>
         * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
         * associated job queue on the compute resources within the environment. If the compute environment is managed,
         * then it can scale its instances out or in automatically, based on the job queue demand.
         * </p>
         * <p>
         * If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within the
         * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
         * Managed compute environments in the <code>DISABLED</code> state do not scale out. However, they scale in to
         * <code>minvCpus</code> value after instances become idle.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. The valid values are <code>ENABLED</code> or
         *        <code>DISABLED</code>. </p>
         *        <p>
         *        If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
         *        associated job queue on the compute resources within the environment. If the compute environment is
         *        managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *        </p>
         *        <p>
         *        If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs
         *        within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to
         *        progress normally. Managed compute environments in the <code>DISABLED</code> state do not scale out.
         *        However, they scale in to <code>minvCpus</code> value after instances become idle.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
         * associated job queue on the compute resources within the environment. If the compute environment is managed,
         * then it can scale its instances out or in automatically, based on the job queue demand.
         * </p>
         * <p>
         * If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs within the
         * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
         * Managed compute environments in the <code>DISABLED</code> state do not scale out. However, they scale in to
         * <code>minvCpus</code> value after instances become idle.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. The valid values are <code>ENABLED</code> or
         *        <code>DISABLED</code>. </p>
         *        <p>
         *        If the state is <code>ENABLED</code>, then the AWS Batch scheduler can attempt to place jobs from an
         *        associated job queue on the compute resources within the environment. If the compute environment is
         *        managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *        </p>
         *        <p>
         *        If the state is <code>DISABLED</code>, then the AWS Batch scheduler does not attempt to place jobs
         *        within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to
         *        progress normally. Managed compute environments in the <code>DISABLED</code> state do not scale out.
         *        However, they scale in to <code>minvCpus</code> value after instances become idle.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The current status of the compute environment (for example, <code>CREATING</code> or
         *        <code>VALID</code>).
         * @see CEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).
         * </p>
         * 
         * @param status
         *        The current status of the compute environment (for example, <code>CREATING</code> or
         *        <code>VALID</code>).
         * @see CEStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEStatus
         */
        Builder status(CEStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the compute
         * environment.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the compute
         *        environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The compute resources defined for the compute environment.
         * </p>
         * 
         * @param computeResources
         *        The compute resources defined for the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResource computeResources);

        /**
         * <p>
         * The compute resources defined for the compute environment.
         * </p>
         * This is a convenience that creates an instance of the {@link ComputeResource.Builder} avoiding the need to
         * create one manually via {@link ComputeResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeResource.Builder#build()} is called immediately and its
         * result is passed to {@link #computeResources(ComputeResource)}.
         * 
         * @param computeResources
         *        a consumer that will call methods on {@link ComputeResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResources(ComputeResource)
         */
        default Builder computeResources(Consumer<ComputeResource.Builder> computeResources) {
            return computeResources(ComputeResource.builder().applyMutation(computeResources).build());
        }

        /**
         * <p>
         * The service role associated with the compute environment that allows AWS Batch to make calls to AWS API
         * operations on your behalf.
         * </p>
         * 
         * @param serviceRole
         *        The service role associated with the compute environment that allows AWS Batch to make calls to AWS
         *        API operations on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);
    }

    static final class BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String computeEnvironmentArn;

        private String ecsClusterArn;

        private String type;

        private String state;

        private String status;

        private String statusReason;

        private ComputeResource computeResources;

        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentDetail model) {
            computeEnvironmentName(model.computeEnvironmentName);
            computeEnvironmentArn(model.computeEnvironmentArn);
            ecsClusterArn(model.ecsClusterArn);
            type(model.type);
            state(model.state);
            status(model.status);
            statusReason(model.statusReason);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final ComputeResource.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public ComputeEnvironmentDetail build() {
            return new ComputeEnvironmentDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
