/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitJobRequest extends BatchRequest implements ToCopyableBuilder<SubmitJobRequest.Builder, SubmitJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubmitJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubmitJobRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<ArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField
            .<ArrayProperties> builder(MarshallingType.SDK_POJO).getter(getter(SubmitJobRequest::arrayProperties))
            .setter(setter(Builder::arrayProperties)).constructor(ArrayProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()).build();

    private static final SdkField<List<JobDependency>> DEPENDS_ON_FIELD = SdkField
            .<List<JobDependency>> builder(MarshallingType.LIST)
            .getter(getter(SubmitJobRequest::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubmitJobRequest::jobDefinition)).setter(setter(Builder::jobDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SubmitJobRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField
            .<ContainerOverrides> builder(MarshallingType.SDK_POJO).getter(getter(SubmitJobRequest::containerOverrides))
            .setter(setter(Builder::containerOverrides)).constructor(ContainerOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build())
            .build();

    private static final SdkField<NodeOverrides> NODE_OVERRIDES_FIELD = SdkField
            .<NodeOverrides> builder(MarshallingType.SDK_POJO).getter(getter(SubmitJobRequest::nodeOverrides))
            .setter(setter(Builder::nodeOverrides)).constructor(NodeOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOverrides").build()).build();

    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<RetryStrategy> builder(MarshallingType.SDK_POJO).getter(getter(SubmitJobRequest::retryStrategy))
            .setter(setter(Builder::retryStrategy)).constructor(RetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.<JobTimeout> builder(MarshallingType.SDK_POJO)
            .getter(getter(SubmitJobRequest::timeout)).setter(setter(Builder::timeout)).constructor(JobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_QUEUE_FIELD, ARRAY_PROPERTIES_FIELD, DEPENDS_ON_FIELD, JOB_DEFINITION_FIELD, PARAMETERS_FIELD,
            CONTAINER_OVERRIDES_FIELD, NODE_OVERRIDES_FIELD, RETRY_STRATEGY_FIELD, TIMEOUT_FIELD));

    private final String jobName;

    private final String jobQueue;

    private final ArrayProperties arrayProperties;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerOverrides containerOverrides;

    private final NodeOverrides nodeOverrides;

    private final RetryStrategy retryStrategy;

    private final JobTimeout timeout;

    private SubmitJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.arrayProperties = builder.arrayProperties;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.nodeOverrides = builder.nodeOverrides;
        this.retryStrategy = builder.retryStrategy;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
     *         lowercase), numbers, hyphens, and underscores are allowed.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job queue into which the job is submitted. You can specify either the name or the Amazon Resource Name (ARN)
     * of the queue.
     * </p>
     * 
     * @return The job queue into which the job is submitted. You can specify either the name or the Amazon Resource
     *         Name (ARN) of the queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and
     * 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>AWS Batch User
     * Guide</i>.
     * </p>
     * 
     * @return The array properties for the submitted job, such as the size of the array. The array size can be between
     *         2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information,
     *         see <a href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the
     *         <i>AWS Batch User Guide</i>.
     */
    public ArrayProperties arrayProperties() {
        return arrayProperties;
    }

    /**
     * Returns true if the DependsOn property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job
     * completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a
     * job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of
     * each dependency to complete before it can begin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDependsOn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     *         <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
     *         array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type
     *         dependency with a job ID for array jobs. In that case, each index child of this job must wait for the
     *         corresponding index child of each dependency to complete before it can begin.
     */
    public List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon Resource
     * Name (ARN) for the job definition.
     * </p>
     * 
     * @return The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
     *         Resource Name (ARN) for the job definition.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job
     * definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code>
     * request override any corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders that are set in
     *         the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
     *         <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of container overrides in JSON format that specify the name of a container in the specified job definition
     * and the overrides it should receive. You can override the default command for a container (that is specified in
     * the job definition or the Docker image) with a <code>command</code> override. You can also override existing
     * environment variables (that are specified in the job definition or Docker image) on a container or add new
     * environment variables to it with an <code>environment</code> override.
     * </p>
     * 
     * @return A list of container overrides in JSON format that specify the name of a container in the specified job
     *         definition and the overrides it should receive. You can override the default command for a container
     *         (that is specified in the job definition or the Docker image) with a <code>command</code> override. You
     *         can also override existing environment variables (that are specified in the job definition or Docker
     *         image) on a container or add new environment variables to it with an <code>environment</code> override.
     */
    public ContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * A list of node overrides in JSON format that specify the node range to target and the container overrides for
     * that node range.
     * </p>
     * 
     * @return A list of node overrides in JSON format that specify the node range to target and the container overrides
     *         for that node range.
     */
    public NodeOverrides nodeOverrides() {
        return nodeOverrides;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     * specified here, it overrides the retry strategy defined in the job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     *         specified here, it overrides the retry strategy defined in the job definition.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which AWS
     * Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not retried.
     * The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified
     * in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job
     * Timeouts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after
     *         which AWS Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout,
     *         it is not retried. The minimum value for the timeout is 60 seconds. This configuration overrides any
     *         timeout configuration specified in the job definition. For array jobs, child jobs have the same timeout
     *         configuration as the parent job. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in
     *         the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public JobTimeout timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobQueue(), other.jobQueue())
                && Objects.equals(arrayProperties(), other.arrayProperties()) && Objects.equals(dependsOn(), other.dependsOn())
                && Objects.equals(jobDefinition(), other.jobDefinition()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(containerOverrides(), other.containerOverrides())
                && Objects.equals(nodeOverrides(), other.nodeOverrides())
                && Objects.equals(retryStrategy(), other.retryStrategy()) && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubmitJobRequest").add("JobName", jobName()).add("JobQueue", jobQueue())
                .add("ArrayProperties", arrayProperties()).add("DependsOn", dependsOn()).add("JobDefinition", jobDefinition())
                .add("Parameters", parameters()).add("ContainerOverrides", containerOverrides())
                .add("NodeOverrides", nodeOverrides()).add("RetryStrategy", retryStrategy()).add("Timeout", timeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "arrayProperties":
            return Optional.ofNullable(clazz.cast(arrayProperties()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "jobDefinition":
            return Optional.ofNullable(clazz.cast(jobDefinition()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "containerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        case "nodeOverrides":
            return Optional.ofNullable(clazz.cast(nodeOverrides()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitJobRequest, T> g) {
        return obj -> g.apply((SubmitJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitJobRequest> {
        /**
         * <p>
         * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         * lowercase), numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param jobName
         *        The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         *        lowercase), numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job queue into which the job is submitted. You can specify either the name or the Amazon Resource Name
         * (ARN) of the queue.
         * </p>
         * 
         * @param jobQueue
         *        The job queue into which the job is submitted. You can specify either the name or the Amazon Resource
         *        Name (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>AWS Batch
         * User Guide</i>.
         * </p>
         * 
         * @param arrayProperties
         *        The array properties for the submitted job, such as the size of the array. The array size can be
         *        between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more
         *        information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array
         *        Jobs</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayProperties(ArrayProperties arrayProperties);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>AWS Batch
         * User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ArrayProperties.Builder} avoiding the need to
         * create one manually via {@link ArrayProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArrayProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #arrayProperties(ArrayProperties)}.
         * 
         * @param arrayProperties
         *        a consumer that will call methods on {@link ArrayProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayProperties(ArrayProperties)
         */
        default Builder arrayProperties(Consumer<ArrayProperties.Builder> arrayProperties) {
            return arrayProperties(ArrayProperties.builder().applyMutation(arrayProperties).build());
        }

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDependency>.Builder} avoiding the need
         * to create one manually via {@link List<JobDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDependency>.Builder#build()} is called immediately and
         * its result is passed to {@link #dependsOn(List<JobDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List<JobDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<JobDependency>)
         */
        Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn);

        /**
         * <p>
         * The job definition used by this job. This value can be either a <code>name:revision</code> or the Amazon
         * Resource Name (ARN) for the job definition.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition used by this job. This value can be either a <code>name:revision</code> or the
         *        Amazon Resource Name (ARN) for the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the
         * job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         * <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders that are set
         *        in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         *        <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A list of container overrides in JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container (that is
         * specified in the job definition or the Docker image) with a <code>command</code> override. You can also
         * override existing environment variables (that are specified in the job definition or Docker image) on a
         * container or add new environment variables to it with an <code>environment</code> override.
         * </p>
         * 
         * @param containerOverrides
         *        A list of container overrides in JSON format that specify the name of a container in the specified job
         *        definition and the overrides it should receive. You can override the default command for a container
         *        (that is specified in the job definition or the Docker image) with a <code>command</code> override.
         *        You can also override existing environment variables (that are specified in the job definition or
         *        Docker image) on a container or add new environment variables to it with an <code>environment</code>
         *        override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverrides containerOverrides);

        /**
         * <p>
         * A list of container overrides in JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container (that is
         * specified in the job definition or the Docker image) with a <code>command</code> override. You can also
         * override existing environment variables (that are specified in the job definition or Docker image) on a
         * container or add new environment variables to it with an <code>environment</code> override.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerOverrides.Builder} avoiding the need to
         * create one manually via {@link ContainerOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #containerOverrides(ContainerOverrides)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link ContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(ContainerOverrides)
         */
        default Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return containerOverrides(ContainerOverrides.builder().applyMutation(containerOverrides).build());
        }

        /**
         * <p>
         * A list of node overrides in JSON format that specify the node range to target and the container overrides for
         * that node range.
         * </p>
         * 
         * @param nodeOverrides
         *        A list of node overrides in JSON format that specify the node range to target and the container
         *        overrides for that node range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOverrides(NodeOverrides nodeOverrides);

        /**
         * <p>
         * A list of node overrides in JSON format that specify the node range to target and the container overrides for
         * that node range.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeOverrides.Builder} avoiding the need to
         * create one manually via {@link NodeOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeOverrides(NodeOverrides)}.
         * 
         * @param nodeOverrides
         *        a consumer that will call methods on {@link NodeOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeOverrides(NodeOverrides)
         */
        default Builder nodeOverrides(Consumer<NodeOverrides.Builder> nodeOverrides) {
            return nodeOverrides(NodeOverrides.builder().applyMutation(nodeOverrides).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy
         *        is specified here, it overrides the retry strategy defined in the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which
         * AWS Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not
         * retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout
         * configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration
         * as the parent job. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param timeout
         *        The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration
         *        after which AWS Batch terminates your jobs if they have not finished. If a job is terminated due to a
         *        timeout, it is not retried. The minimum value for the timeout is 60 seconds. This configuration
         *        overrides any timeout configuration specified in the job definition. For array jobs, child jobs have
         *        the same timeout configuration as the parent job. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a>
         *        in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(JobTimeout timeout);

        /**
         * <p>
         * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which
         * AWS Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it is not
         * retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout
         * configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration
         * as the parent job. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link JobTimeout.Builder} avoiding the need to create
         * one manually via {@link JobTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(JobTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link JobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(JobTimeout)
         */
        default Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return timeout(JobTimeout.builder().applyMutation(timeout).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobQueue;

        private ArrayProperties arrayProperties;

        private List<JobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private String jobDefinition;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private ContainerOverrides containerOverrides;

        private NodeOverrides nodeOverrides;

        private RetryStrategy retryStrategy;

        private JobTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobQueue(model.jobQueue);
            arrayProperties(model.arrayProperties);
            dependsOn(model.dependsOn);
            jobDefinition(model.jobDefinition);
            parameters(model.parameters);
            containerOverrides(model.containerOverrides);
            nodeOverrides(model.nodeOverrides);
            retryStrategy(model.retryStrategy);
            timeout(model.timeout);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final ArrayProperties.Builder getArrayProperties() {
            return arrayProperties != null ? arrayProperties.toBuilder() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final void setArrayProperties(ArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return dependsOn != null ? dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> JobDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.toBuilder() : null;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        public final NodeOverrides.Builder getNodeOverrides() {
            return nodeOverrides != null ? nodeOverrides.toBuilder() : null;
        }

        @Override
        public final Builder nodeOverrides(NodeOverrides nodeOverrides) {
            this.nodeOverrides = nodeOverrides;
            return this;
        }

        public final void setNodeOverrides(NodeOverrides.BuilderImpl nodeOverrides) {
            this.nodeOverrides = nodeOverrides != null ? nodeOverrides.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final JobTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
