/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputeEnvironmentsResponse extends BatchResponse implements
        ToCopyableBuilder<DescribeComputeEnvironmentsResponse.Builder, DescribeComputeEnvironmentsResponse> {
    private static final SdkField<List<ComputeEnvironmentDetail>> COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<ComputeEnvironmentDetail>> builder(MarshallingType.LIST)
            .getter(getter(DescribeComputeEnvironmentsResponse::computeEnvironments))
            .setter(setter(Builder::computeEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeEnvironmentDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeEnvironmentDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeComputeEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComputeEnvironmentDetail> computeEnvironments;

    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ComputeEnvironments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasComputeEnvironments() {
        return computeEnvironments != null && !(computeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of compute environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComputeEnvironments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of compute environments.
     */
    public List<ComputeEnvironmentDetail> computeEnvironments() {
        return computeEnvironments;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request. When
     * the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
     *         When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse) obj;
        return Objects.equals(computeEnvironments(), other.computeEnvironments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComputeEnvironmentsResponse").add("ComputeEnvironments", computeEnvironments())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironments":
            return Optional.ofNullable(clazz.cast(computeEnvironments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeComputeEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments);

        /**
         * <p>
         * The list of compute environments.
         * </p>
         * 
         * @param computeEnvironments
         *        The list of compute environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments);

        /**
         * <p>
         * The list of compute environments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComputeEnvironmentDetail>.Builder} avoiding
         * the need to create one manually via {@link List<ComputeEnvironmentDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComputeEnvironmentDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link #computeEnvironments(List<ComputeEnvironmentDetail>)}.
         * 
         * @param computeEnvironments
         *        a consumer that will call methods on {@link List<ComputeEnvironmentDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeEnvironments(List<ComputeEnvironmentDetail>)
         */
        Builder computeEnvironments(Consumer<ComputeEnvironmentDetail.Builder>... computeEnvironments);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request.
         * When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code>
         *        request. When the results of a <code>DescribeJobDefinitions</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            super(model);
            computeEnvironments(model.computeEnvironments);
            nextToken(model.nextToken);
        }

        public final Collection<ComputeEnvironmentDetail.Builder> getComputeEnvironments() {
            return computeEnvironments != null ? computeEnvironments.stream().map(ComputeEnvironmentDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail... computeEnvironments) {
            computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(Consumer<ComputeEnvironmentDetail.Builder>... computeEnvironments) {
            computeEnvironments(Stream.of(computeEnvironments)
                    .map(c -> ComputeEnvironmentDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail.BuilderImpl> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copyFromBuilder(computeEnvironments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
