/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the properties of a node that is associated with a multi-node parallel job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodePropertiesSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NodePropertiesSummary.Builder, NodePropertiesSummary> {
    private static final SdkField<Boolean> IS_MAIN_NODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(NodePropertiesSummary::isMainNode)).setter(setter(Builder::isMainNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMainNode").build()).build();

    private static final SdkField<Integer> NUM_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NodePropertiesSummary::numNodes)).setter(setter(Builder::numNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numNodes").build()).build();

    private static final SdkField<Integer> NODE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NodePropertiesSummary::nodeIndex)).setter(setter(Builder::nodeIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_MAIN_NODE_FIELD,
            NUM_NODES_FIELD, NODE_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isMainNode;

    private final Integer numNodes;

    private final Integer nodeIndex;

    private NodePropertiesSummary(BuilderImpl builder) {
        this.isMainNode = builder.isMainNode;
        this.numNodes = builder.numNodes;
        this.nodeIndex = builder.nodeIndex;
    }

    /**
     * <p>
     * Specifies whether the current node is the main node for a multi-node parallel job.
     * </p>
     * 
     * @return Specifies whether the current node is the main node for a multi-node parallel job.
     */
    public Boolean isMainNode() {
        return isMainNode;
    }

    /**
     * <p>
     * The number of nodes associated with a multi-node parallel job.
     * </p>
     * 
     * @return The number of nodes associated with a multi-node parallel job.
     */
    public Integer numNodes() {
        return numNodes;
    }

    /**
     * <p>
     * The node index for the node. Node index numbering begins at zero. This index is also available on the node with
     * the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
     * </p>
     * 
     * @return The node index for the node. Node index numbering begins at zero. This index is also available on the
     *         node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
     */
    public Integer nodeIndex() {
        return nodeIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isMainNode());
        hashCode = 31 * hashCode + Objects.hashCode(numNodes());
        hashCode = 31 * hashCode + Objects.hashCode(nodeIndex());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodePropertiesSummary)) {
            return false;
        }
        NodePropertiesSummary other = (NodePropertiesSummary) obj;
        return Objects.equals(isMainNode(), other.isMainNode()) && Objects.equals(numNodes(), other.numNodes())
                && Objects.equals(nodeIndex(), other.nodeIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NodePropertiesSummary").add("IsMainNode", isMainNode()).add("NumNodes", numNodes())
                .add("NodeIndex", nodeIndex()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isMainNode":
            return Optional.ofNullable(clazz.cast(isMainNode()));
        case "numNodes":
            return Optional.ofNullable(clazz.cast(numNodes()));
        case "nodeIndex":
            return Optional.ofNullable(clazz.cast(nodeIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodePropertiesSummary, T> g) {
        return obj -> g.apply((NodePropertiesSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodePropertiesSummary> {
        /**
         * <p>
         * Specifies whether the current node is the main node for a multi-node parallel job.
         * </p>
         * 
         * @param isMainNode
         *        Specifies whether the current node is the main node for a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMainNode(Boolean isMainNode);

        /**
         * <p>
         * The number of nodes associated with a multi-node parallel job.
         * </p>
         * 
         * @param numNodes
         *        The number of nodes associated with a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numNodes(Integer numNodes);

        /**
         * <p>
         * The node index for the node. Node index numbering begins at zero. This index is also available on the node
         * with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
         * </p>
         * 
         * @param nodeIndex
         *        The node index for the node. Node index numbering begins at zero. This index is also available on the
         *        node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIndex(Integer nodeIndex);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isMainNode;

        private Integer numNodes;

        private Integer nodeIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(NodePropertiesSummary model) {
            isMainNode(model.isMainNode);
            numNodes(model.numNodes);
            nodeIndex(model.nodeIndex);
        }

        public final Boolean getIsMainNode() {
            return isMainNode;
        }

        @Override
        public final Builder isMainNode(Boolean isMainNode) {
            this.isMainNode = isMainNode;
            return this;
        }

        public final void setIsMainNode(Boolean isMainNode) {
            this.isMainNode = isMainNode;
        }

        public final Integer getNumNodes() {
            return numNodes;
        }

        @Override
        public final Builder numNodes(Integer numNodes) {
            this.numNodes = numNodes;
            return this;
        }

        public final void setNumNodes(Integer numNodes) {
            this.numNodes = numNodes;
        }

        public final Integer getNodeIndex() {
            return nodeIndex;
        }

        @Override
        public final Builder nodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
            return this;
        }

        public final void setNodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        @Override
        public NodePropertiesSummary build() {
            return new NodePropertiesSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
