/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobQueueRequest extends BatchRequest implements
        ToCopyableBuilder<UpdateJobQueueRequest.Builder, UpdateJobQueueRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobQueueRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateJobQueueRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateJobQueueRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<ComputeEnvironmentOrder>> COMPUTE_ENVIRONMENT_ORDER_FIELD = SdkField
            .<List<ComputeEnvironmentOrder>> builder(MarshallingType.LIST)
            .getter(getter(UpdateJobQueueRequest::computeEnvironmentOrder))
            .setter(setter(Builder::computeEnvironmentOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeEnvironmentOrder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeEnvironmentOrder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD, STATE_FIELD,
            PRIORITY_FIELD, COMPUTE_ENVIRONMENT_ORDER_FIELD));

    private final String jobQueue;

    private final String state;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the job queue.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs.
     * @see JQState
     */
    public JQState state() {
        return JQState.fromValue(state);
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs.
     * @see JQState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     * <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority
     * is determined in descending order, for example, a job queue with a priority value of <code>10</code> is given
     * scheduling preference over a job queue with a priority value of <code>1</code>.
     * </p>
     * 
     * @return The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     *         <code>priority</code> parameter) are evaluated first when associated with the same compute environment.
     *         Priority is determined in descending order, for example, a job queue with a priority value of
     *         <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * Returns true if the ComputeEnvironmentOrder property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasComputeEnvironmentOrder() {
        return computeEnvironmentOrder != null && !(computeEnvironmentOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one
     * of the parameters used by the job scheduler to determine which compute environment should execute a given job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComputeEnvironmentOrder()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details the set of compute environments mapped to a job queue and their order relative to each other.
     *         This is one of the parameters used by the job scheduler to determine which compute environment should
     *         execute a given job.
     */
    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(priority(), other.priority())
                && Objects.equals(computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateJobQueueRequest").add("JobQueue", jobQueue()).add("State", stateAsString())
                .add("Priority", priority()).add("ComputeEnvironmentOrder", computeEnvironmentOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "computeEnvironmentOrder":
            return Optional.ofNullable(clazz.cast(computeEnvironmentOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobQueueRequest, T> g) {
        return obj -> g.apply((UpdateJobQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobQueueRequest> {
        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueue
         *        The name or the Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         * <code>priority</code> parameter) are evaluated first when associated with the same compute environment.
         * Priority is determined in descending order, for example, a job queue with a priority value of <code>10</code>
         * is given scheduling preference over a job queue with a priority value of <code>1</code>.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         *        <code>priority</code> parameter) are evaluated first when associated with the same compute
         *        environment. Priority is determined in descending order, for example, a job queue with a priority
         *        value of <code>10</code> is given scheduling preference over a job queue with a priority value of
         *        <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        execute a given job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should execute a given
         * job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComputeEnvironmentOrder>.Builder} avoiding
         * the need to create one manually via {@link List<ComputeEnvironmentOrder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComputeEnvironmentOrder>.Builder#build()} is called
         * immediately and its result is passed to {@link #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)}.
         * 
         * @param computeEnvironmentOrder
         *        a consumer that will call methods on {@link List<ComputeEnvironmentOrder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)
         */
        Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String state;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            state(model.state);
            priority(model.priority);
            computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return computeEnvironmentOrder != null ? computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder) {
            computeEnvironmentOrder(Stream.of(computeEnvironmentOrder)
                    .map(c -> ComputeEnvironmentOrder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
