/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a job attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttemptDetail implements SdkPojo, Serializable, ToCopyableBuilder<AttemptDetail.Builder, AttemptDetail> {
    private static final SdkField<AttemptContainerDetail> CONTAINER_FIELD = SdkField
            .<AttemptContainerDetail> builder(MarshallingType.SDK_POJO).getter(getter(AttemptDetail::container))
            .setter(setter(Builder::container)).constructor(AttemptContainerDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AttemptDetail::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AttemptDetail::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttemptDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD,
            STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final AttemptContainerDetail container;

    private final Long startedAt;

    private final Long stoppedAt;

    private final String statusReason;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * Details about the container in this job attempt.
     * </p>
     * 
     * @return Details about the container in this job attempt.
     */
    public AttemptContainerDetail container() {
        return container;
    }

    /**
     * <p>
     * The Unix timestamp (in seconds and milliseconds) for when the attempt was started (when the attempt transitioned
     * from the <code>STARTING</code> state to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp (in seconds and milliseconds) for when the attempt was started (when the attempt
     *         transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in seconds and milliseconds) for when the attempt was stopped (when the attempt transitioned
     * from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
     * </p>
     * 
     * @return The Unix timestamp (in seconds and milliseconds) for when the attempt was stopped (when the attempt
     *         transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *         <code>FAILED</code>).
     */
    public Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job attempt.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job attempt.
     */
    public String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail) obj;
        return Objects.equals(container(), other.container()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttemptDetail").add("Container", container()).add("StartedAt", startedAt())
                .add("StoppedAt", stoppedAt()).add("StatusReason", statusReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttemptDetail, T> g) {
        return obj -> g.apply((AttemptDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttemptDetail> {
        /**
         * <p>
         * Details about the container in this job attempt.
         * </p>
         * 
         * @param container
         *        Details about the container in this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(AttemptContainerDetail container);

        /**
         * <p>
         * Details about the container in this job attempt.
         * </p>
         * This is a convenience that creates an instance of the {@link AttemptContainerDetail.Builder} avoiding the
         * need to create one manually via {@link AttemptContainerDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttemptContainerDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #container(AttemptContainerDetail)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link AttemptContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(AttemptContainerDetail)
         */
        default Builder container(Consumer<AttemptContainerDetail.Builder> container) {
            return container(AttemptContainerDetail.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * The Unix timestamp (in seconds and milliseconds) for when the attempt was started (when the attempt
         * transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in seconds and milliseconds) for when the attempt was started (when the attempt
         *        transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in seconds and milliseconds) for when the attempt was stopped (when the attempt
         * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
         * <code>FAILED</code>).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in seconds and milliseconds) for when the attempt was stopped (when the attempt
         *        transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code>
         *        or <code>FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job attempt.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job
         *        attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private AttemptContainerDetail container;

        private Long startedAt;

        private Long stoppedAt;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            container(model.container);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            statusReason(model.statusReason);
        }

        public final AttemptContainerDetail.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(AttemptContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public AttemptDetail build() {
            return new AttemptDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
