/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterJobDefinitionRequest extends BatchRequest implements
        ToCopyableBuilder<DeregisterJobDefinitionRequest.Builder, DeregisterJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeregisterJobDefinitionRequest::jobDefinition)).setter(setter(Builder::jobDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_FIELD));

    private final String jobDefinition;

    private DeregisterJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinition = builder.jobDefinition;
    }

    /**
     * <p>
     * The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition to
     * deregister.
     * </p>
     * 
     * @return The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job
     *         definition to deregister.
     */
    public String jobDefinition() {
        return jobDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterJobDefinitionRequest)) {
            return false;
        }
        DeregisterJobDefinitionRequest other = (DeregisterJobDefinitionRequest) obj;
        return Objects.equals(jobDefinition(), other.jobDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeregisterJobDefinitionRequest").add("JobDefinition", jobDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinition":
            return Optional.ofNullable(clazz.cast(jobDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterJobDefinitionRequest, T> g) {
        return obj -> g.apply((DeregisterJobDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterJobDefinitionRequest> {
        /**
         * <p>
         * The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition
         * to deregister.
         * </p>
         * 
         * @param jobDefinition
         *        The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job
         *        definition to deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterJobDefinitionRequest model) {
            super(model);
            jobDefinition(model.jobDefinition);
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterJobDefinitionRequest build() {
            return new DeregisterJobDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
