/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing summary details of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(JobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(JobSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(JobSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(JobSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(JobSummary::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<ContainerSummary> CONTAINER_FIELD = SdkField
            .<ContainerSummary> builder(MarshallingType.SDK_POJO).memberName("container").getter(getter(JobSummary::container))
            .setter(setter(Builder::container)).constructor(ContainerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<ArrayPropertiesSummary> ARRAY_PROPERTIES_FIELD = SdkField
            .<ArrayPropertiesSummary> builder(MarshallingType.SDK_POJO).memberName("arrayProperties")
            .getter(getter(JobSummary::arrayProperties)).setter(setter(Builder::arrayProperties))
            .constructor(ArrayPropertiesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()).build();

    private static final SdkField<NodePropertiesSummary> NODE_PROPERTIES_FIELD = SdkField
            .<NodePropertiesSummary> builder(MarshallingType.SDK_POJO).memberName("nodeProperties")
            .getter(getter(JobSummary::nodeProperties)).setter(setter(Builder::nodeProperties))
            .constructor(NodePropertiesSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_NAME_FIELD,
            CREATED_AT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, CONTAINER_FIELD,
            ARRAY_PROPERTIES_FIELD, NODE_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String jobName;

    private final Long createdAt;

    private final String status;

    private final String statusReason;

    private final Long startedAt;

    private final Long stoppedAt;

    private final ContainerSummary container;

    private final ArrayPropertiesSummary arrayProperties;

    private final NodePropertiesSummary nodeProperties;

    private JobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.container = builder.container;
        this.arrayProperties = builder.arrayProperties;
        this.nodeProperties = builder.nodeProperties;
    }

    /**
     * <p>
     * The ID of the job.
     * </p>
     * 
     * @return The ID of the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was created. For non-array jobs and parent array jobs, this is when the job
     * entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For array child jobs, this is
     * when the child job was spawned by its parent and entered the <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for when the job was created. For non-array jobs and parent array jobs, this is when
     *         the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For array
     *         child jobs, this is when the child job was spawned by its parent and entered the <code>PENDING</code>
     *         state.
     */
    public Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details about the current status of the job.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details about the current status of the job.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was started (when the job transitioned from the <code>STARTING</code> state
     * to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp for when the job was started (when the job transitioned from the <code>STARTING</code>
     *         state to the <code>RUNNING</code> state).
     */
    public Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was stopped (when the job transitioned from the <code>RUNNING</code> state to
     * a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
     * </p>
     * 
     * @return The Unix timestamp for when the job was stopped (when the job transitioned from the <code>RUNNING</code>
     *         state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
     */
    public Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * An object representing the details of the container that is associated with the job.
     * </p>
     * 
     * @return An object representing the details of the container that is associated with the job.
     */
    public ContainerSummary container() {
        return container;
    }

    /**
     * <p>
     * The array properties of the job, if it is an array job.
     * </p>
     * 
     * @return The array properties of the job, if it is an array job.
     */
    public ArrayPropertiesSummary arrayProperties() {
        return arrayProperties;
    }

    /**
     * <p>
     * The node properties for a single node in a job summary list.
     * </p>
     * 
     * @return The node properties for a single node in a job summary list.
     */
    public NodePropertiesSummary nodeProperties() {
        return nodeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(nodeProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(container(), other.container())
                && Objects.equals(arrayProperties(), other.arrayProperties())
                && Objects.equals(nodeProperties(), other.nodeProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobSummary").add("JobId", jobId()).add("JobName", jobName()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("StartedAt", startedAt())
                .add("StoppedAt", stoppedAt()).add("Container", container()).add("ArrayProperties", arrayProperties())
                .add("NodeProperties", nodeProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "arrayProperties":
            return Optional.ofNullable(clazz.cast(arrayProperties()));
        case "nodeProperties":
            return Optional.ofNullable(clazz.cast(nodeProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The ID of the job.
         * </p>
         * 
         * @param jobId
         *        The ID of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Unix timestamp for when the job was created. For non-array jobs and parent array jobs, this is when the
         * job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For array child jobs,
         * this is when the child job was spawned by its parent and entered the <code>PENDING</code> state.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for when the job was created. For non-array jobs and parent array jobs, this is
         *        when the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For
         *        array child jobs, this is when the child job was spawned by its parent and entered the
         *        <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * A short, human-readable string to provide additional details about the current status of the job.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details about the current status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp for when the job was started (when the job transitioned from the <code>STARTING</code>
         * state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for when the job was started (when the job transitioned from the
         *        <code>STARTING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp for when the job was stopped (when the job transitioned from the <code>RUNNING</code>
         * state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp for when the job was stopped (when the job transitioned from the
         *        <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>
         *        ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * 
         * @param container
         *        An object representing the details of the container that is associated with the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerSummary container);

        /**
         * <p>
         * An object representing the details of the container that is associated with the job.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerSummary.Builder} avoiding the need to
         * create one manually via {@link ContainerSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #container(ContainerSummary)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerSummary)
         */
        default Builder container(Consumer<ContainerSummary.Builder> container) {
            return container(ContainerSummary.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * The array properties of the job, if it is an array job.
         * </p>
         * 
         * @param arrayProperties
         *        The array properties of the job, if it is an array job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayProperties(ArrayPropertiesSummary arrayProperties);

        /**
         * <p>
         * The array properties of the job, if it is an array job.
         * </p>
         * This is a convenience that creates an instance of the {@link ArrayPropertiesSummary.Builder} avoiding the
         * need to create one manually via {@link ArrayPropertiesSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArrayPropertiesSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #arrayProperties(ArrayPropertiesSummary)}.
         * 
         * @param arrayProperties
         *        a consumer that will call methods on {@link ArrayPropertiesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayProperties(ArrayPropertiesSummary)
         */
        default Builder arrayProperties(Consumer<ArrayPropertiesSummary.Builder> arrayProperties) {
            return arrayProperties(ArrayPropertiesSummary.builder().applyMutation(arrayProperties).build());
        }

        /**
         * <p>
         * The node properties for a single node in a job summary list.
         * </p>
         * 
         * @param nodeProperties
         *        The node properties for a single node in a job summary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeProperties(NodePropertiesSummary nodeProperties);

        /**
         * <p>
         * The node properties for a single node in a job summary list.
         * </p>
         * This is a convenience that creates an instance of the {@link NodePropertiesSummary.Builder} avoiding the need
         * to create one manually via {@link NodePropertiesSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodePropertiesSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #nodeProperties(NodePropertiesSummary)}.
         * 
         * @param nodeProperties
         *        a consumer that will call methods on {@link NodePropertiesSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeProperties(NodePropertiesSummary)
         */
        default Builder nodeProperties(Consumer<NodePropertiesSummary.Builder> nodeProperties) {
            return nodeProperties(NodePropertiesSummary.builder().applyMutation(nodeProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String jobName;

        private Long createdAt;

        private String status;

        private String statusReason;

        private Long startedAt;

        private Long stoppedAt;

        private ContainerSummary container;

        private ArrayPropertiesSummary arrayProperties;

        private NodePropertiesSummary nodeProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            jobId(model.jobId);
            jobName(model.jobName);
            createdAt(model.createdAt);
            status(model.status);
            statusReason(model.statusReason);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            container(model.container);
            arrayProperties(model.arrayProperties);
            nodeProperties(model.nodeProperties);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final ContainerSummary.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        @Override
        public final Builder container(ContainerSummary container) {
            this.container = container;
            return this;
        }

        public final void setContainer(ContainerSummary.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final ArrayPropertiesSummary.Builder getArrayProperties() {
            return arrayProperties != null ? arrayProperties.toBuilder() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayPropertiesSummary arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final void setArrayProperties(ArrayPropertiesSummary.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        public final NodePropertiesSummary.Builder getNodeProperties() {
            return nodeProperties != null ? nodeProperties.toBuilder() : null;
        }

        @Override
        public final Builder nodeProperties(NodePropertiesSummary nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final void setNodeProperties(NodePropertiesSummary.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
