/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an AWS Batch job definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDefinition implements SdkPojo, Serializable, ToCopyableBuilder<JobDefinition.Builder, JobDefinition> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionName").getter(getter(JobDefinition::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()).build();

    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionArn").getter(getter(JobDefinition::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionArn").build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("revision").getter(getter(JobDefinition::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobDefinition::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(JobDefinition::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(JobDefinition::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<RetryStrategy> builder(MarshallingType.SDK_POJO).memberName("retryStrategy")
            .getter(getter(JobDefinition::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(RetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<ContainerProperties> CONTAINER_PROPERTIES_FIELD = SdkField
            .<ContainerProperties> builder(MarshallingType.SDK_POJO).memberName("containerProperties")
            .getter(getter(JobDefinition::containerProperties)).setter(setter(Builder::containerProperties))
            .constructor(ContainerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerProperties").build())
            .build();

    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.<JobTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("timeout").getter(getter(JobDefinition::timeout)).setter(setter(Builder::timeout))
            .constructor(JobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final SdkField<NodeProperties> NODE_PROPERTIES_FIELD = SdkField
            .<NodeProperties> builder(MarshallingType.SDK_POJO).memberName("nodeProperties")
            .getter(getter(JobDefinition::nodeProperties)).setter(setter(Builder::nodeProperties))
            .constructor(NodeProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(JobDefinition::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            JOB_DEFINITION_ARN_FIELD, REVISION_FIELD, STATUS_FIELD, TYPE_FIELD, PARAMETERS_FIELD, RETRY_STRATEGY_FIELD,
            CONTAINER_PROPERTIES_FIELD, TIMEOUT_FIELD, NODE_PROPERTIES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobDefinitionName;

    private final String jobDefinitionArn;

    private final Integer revision;

    private final String status;

    private final String type;

    private final Map<String, String> parameters;

    private final RetryStrategy retryStrategy;

    private final ContainerProperties containerProperties;

    private final JobTimeout timeout;

    private final NodeProperties nodeProperties;

    private final Map<String, String> tags;

    private JobDefinition(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
        this.status = builder.status;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.retryStrategy = builder.retryStrategy;
        this.containerProperties = builder.containerProperties;
        this.timeout = builder.timeout;
        this.nodeProperties = builder.nodeProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the job definition.
     * </p>
     * 
     * @return The name of the job definition.
     */
    public String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the job definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the job definition.
     */
    public String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The revision of the job definition.
     * </p>
     * 
     * @return The revision of the job definition.
     */
    public Integer revision() {
        return revision;
    }

    /**
     * <p>
     * The status of the job definition.
     * </p>
     * 
     * @return The status of the job definition.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The type of job definition.
     * </p>
     * 
     * @return The type of job definition.
     */
    public String type() {
        return type;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are
     * specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding
     * parameter defaults from the job definition. For more information about specifying parameters, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job Definition
     * Parameters</a> in the <i>AWS Batch User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Default parameters or parameter substitution placeholders that are set in the job definition. Parameters
     *         are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any
     *         corresponding parameter defaults from the job definition. For more information about specifying
     *         parameters, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job Definition
     *         Parameters</a> in the <i>AWS Batch User Guide</i>.
     */
    public Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    public RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * An object with various properties specific to container-based jobs.
     * </p>
     * 
     * @return An object with various properties specific to container-based jobs.
     */
    public ContainerProperties containerProperties() {
        return containerProperties;
    }

    /**
     * <p>
     * The timeout configuration for jobs that are submitted with this job definition. You can specify a timeout
     * duration after which AWS Batch terminates your jobs if they have not finished.
     * </p>
     * 
     * @return The timeout configuration for jobs that are submitted with this job definition. You can specify a timeout
     *         duration after which AWS Batch terminates your jobs if they have not finished.
     */
    public JobTimeout timeout() {
        return timeout;
    }

    /**
     * <p>
     * An object with various properties specific to multi-node parallel jobs.
     * </p>
     * 
     * @return An object with various properties specific to multi-node parallel jobs.
     */
    public NodeProperties nodeProperties() {
        return nodeProperties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags applied to the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags applied to the job definition.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDefinition)) {
            return false;
        }
        JobDefinition other = (JobDefinition) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(jobDefinitionArn(), other.jobDefinitionArn()) && Objects.equals(revision(), other.revision())
                && Objects.equals(status(), other.status()) && Objects.equals(type(), other.type())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(containerProperties(), other.containerProperties())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(nodeProperties(), other.nodeProperties())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobDefinition").add("JobDefinitionName", jobDefinitionName())
                .add("JobDefinitionArn", jobDefinitionArn()).add("Revision", revision()).add("Status", status())
                .add("Type", type()).add("Parameters", parameters()).add("RetryStrategy", retryStrategy())
                .add("ContainerProperties", containerProperties()).add("Timeout", timeout())
                .add("NodeProperties", nodeProperties()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "jobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "containerProperties":
            return Optional.ofNullable(clazz.cast(containerProperties()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "nodeProperties":
            return Optional.ofNullable(clazz.cast(nodeProperties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDefinition, T> g) {
        return obj -> g.apply((JobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDefinition> {
        /**
         * <p>
         * The name of the job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the job definition.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) for the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The revision of the job definition.
         * </p>
         * 
         * @param revision
         *        The revision of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        /**
         * <p>
         * The status of the job definition.
         * </p>
         * 
         * @param status
         *        The status of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of job definition.
         * </p>
         * 
         * @param type
         *        The type of job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are
         * specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any
         * corresponding parameter defaults from the job definition. For more information about specifying parameters,
         * see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job
         * Definition Parameters</a> in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param parameters
         *        Default parameters or parameter substitution placeholders that are set in the job definition.
         *        Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request
         *        override any corresponding parameter defaults from the job definition. For more information about
         *        specifying parameters, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job
         *        Definition Parameters</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs that are submitted with this job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * An object with various properties specific to container-based jobs.
         * </p>
         * 
         * @param containerProperties
         *        An object with various properties specific to container-based jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerProperties(ContainerProperties containerProperties);

        /**
         * <p>
         * An object with various properties specific to container-based jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerProperties.Builder} avoiding the need
         * to create one manually via {@link ContainerProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #containerProperties(ContainerProperties)}.
         * 
         * @param containerProperties
         *        a consumer that will call methods on {@link ContainerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerProperties(ContainerProperties)
         */
        default Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return containerProperties(ContainerProperties.builder().applyMutation(containerProperties).build());
        }

        /**
         * <p>
         * The timeout configuration for jobs that are submitted with this job definition. You can specify a timeout
         * duration after which AWS Batch terminates your jobs if they have not finished.
         * </p>
         * 
         * @param timeout
         *        The timeout configuration for jobs that are submitted with this job definition. You can specify a
         *        timeout duration after which AWS Batch terminates your jobs if they have not finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(JobTimeout timeout);

        /**
         * <p>
         * The timeout configuration for jobs that are submitted with this job definition. You can specify a timeout
         * duration after which AWS Batch terminates your jobs if they have not finished.
         * </p>
         * This is a convenience that creates an instance of the {@link JobTimeout.Builder} avoiding the need to create
         * one manually via {@link JobTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(JobTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link JobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(JobTimeout)
         */
        default Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return timeout(JobTimeout.builder().applyMutation(timeout).build());
        }

        /**
         * <p>
         * An object with various properties specific to multi-node parallel jobs.
         * </p>
         * 
         * @param nodeProperties
         *        An object with various properties specific to multi-node parallel jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeProperties(NodeProperties nodeProperties);

        /**
         * <p>
         * An object with various properties specific to multi-node parallel jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeProperties.Builder} avoiding the need to
         * create one manually via {@link NodeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeProperties(NodeProperties)}.
         * 
         * @param nodeProperties
         *        a consumer that will call methods on {@link NodeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeProperties(NodeProperties)
         */
        default Builder nodeProperties(Consumer<NodeProperties.Builder> nodeProperties) {
            return nodeProperties(NodeProperties.builder().applyMutation(nodeProperties).build());
        }

        /**
         * <p>
         * The tags applied to the job definition.
         * </p>
         * 
         * @param tags
         *        The tags applied to the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String jobDefinitionName;

        private String jobDefinitionArn;

        private Integer revision;

        private String status;

        private String type;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private RetryStrategy retryStrategy;

        private ContainerProperties containerProperties;

        private JobTimeout timeout;

        private NodeProperties nodeProperties;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobDefinition model) {
            jobDefinitionName(model.jobDefinitionName);
            jobDefinitionArn(model.jobDefinitionArn);
            revision(model.revision);
            status(model.status);
            type(model.type);
            parameters(model.parameters);
            retryStrategy(model.retryStrategy);
            containerProperties(model.containerProperties);
            timeout(model.timeout);
            nodeProperties(model.nodeProperties);
            tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return containerProperties != null ? containerProperties.toBuilder() : null;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        public final JobTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        @Override
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        public final NodeProperties.Builder getNodeProperties() {
            return nodeProperties != null ? nodeProperties.toBuilder() : null;
        }

        @Override
        public final Builder nodeProperties(NodeProperties nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final void setNodeProperties(NodeProperties.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public JobDefinition build() {
            return new JobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
