/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputeEnvironmentsRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeComputeEnvironmentsRequest.Builder, DescribeComputeEnvironmentsRequest> {
    private static final SdkField<List<String>> COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("computeEnvironments")
            .getter(getter(DescribeComputeEnvironmentsRequest::computeEnvironments))
            .setter(setter(Builder::computeEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeComputeEnvironmentsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeComputeEnvironmentsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENTS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> computeEnvironments;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeComputeEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ComputeEnvironments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasComputeEnvironments() {
        return computeEnvironments != null && !(computeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComputeEnvironments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
     */
    public List<String> computeEnvironments() {
        return computeEnvironments;
    }

    /**
     * <p>
     * The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated output.
     * When this parameter is used, <code>DescribeComputeEnvironments</code> only returns <code>maxResults</code>
     * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
     * initial request can be seen by sending another <code>DescribeComputeEnvironments</code> request with the returned
     * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter is not used, then
     * <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if
     * applicable.
     * </p>
     * 
     * @return The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated
     *         output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This
     *         value can be between 1 and 100. If this parameter is not used, then
     *         <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code>
     * request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results
     *         to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeEnvironments() ? computeEnvironments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsRequest)) {
            return false;
        }
        DescribeComputeEnvironmentsRequest other = (DescribeComputeEnvironmentsRequest) obj;
        return hasComputeEnvironments() == other.hasComputeEnvironments()
                && Objects.equals(computeEnvironments(), other.computeEnvironments())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeComputeEnvironmentsRequest")
                .add("ComputeEnvironments", hasComputeEnvironments() ? computeEnvironments() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironments":
            return Optional.ofNullable(clazz.cast(computeEnvironments()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeEnvironmentsRequest, T> g) {
        return obj -> g.apply((DescribeComputeEnvironmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeComputeEnvironmentsRequest> {
        /**
         * <p>
         * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param computeEnvironments
         *        A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(Collection<String> computeEnvironments);

        /**
         * <p>
         * A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param computeEnvironments
         *        A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironments(String... computeEnvironments);

        /**
         * <p>
         * The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated
         * output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
         * <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The
         * remaining results of the initial request can be seen by sending another
         * <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This value
         * can be between 1 and 100. If this parameter is not used, then <code>DescribeComputeEnvironments</code>
         * returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in
         *        paginated output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This
         *        value can be between 1 and 100. If this parameter is not used, then
         *        <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value
         *        if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the
         *        results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are
         *        no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<String> computeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsRequest model) {
            super(model);
            computeEnvironments(model.computeEnvironments);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getComputeEnvironments() {
            if (computeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return computeEnvironments;
        }

        @Override
        public final Builder computeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(String... computeEnvironments) {
            computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        public final void setComputeEnvironments(Collection<String> computeEnvironments) {
            this.computeEnvironments = StringListCopier.copy(computeEnvironments);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputeEnvironmentsRequest build() {
            return new DescribeComputeEnvironmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
