/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputeEnvironmentRequest extends BatchRequest implements
        ToCopyableBuilder<CreateComputeEnvironmentRequest.Builder, CreateComputeEnvironmentRequest> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeEnvironmentName").getter(getter(CreateComputeEnvironmentRequest::computeEnvironmentName))
            .setter(setter(Builder::computeEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateComputeEnvironmentRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CreateComputeEnvironmentRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<ComputeResource> COMPUTE_RESOURCES_FIELD = SdkField
            .<ComputeResource> builder(MarshallingType.SDK_POJO).memberName("computeResources")
            .getter(getter(CreateComputeEnvironmentRequest::computeResources)).setter(setter(Builder::computeResources))
            .constructor(ComputeResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(CreateComputeEnvironmentRequest::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateComputeEnvironmentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPUTE_ENVIRONMENT_NAME_FIELD, TYPE_FIELD, STATE_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD, TAGS_FIELD));

    private final String computeEnvironmentName;

    private final String type;

    private final String state;

    private final ComputeResource computeResources;

    private final String serviceRole;

    private final Map<String, String> tags;

    private CreateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.type = builder.type;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, hyphens, and
     * underscores are allowed.
     * </p>
     * 
     * @return The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, hyphens, and
     *         underscores are allowed.
     */
    public String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The type of the compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in
     * the <i>AWS Batch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         Environments</a> in the <i>AWS Batch User Guide</i>.
     * @see CEType
     */
    public CEType type() {
        return CEType.fromValue(type);
    }

    /**
     * <p>
     * The type of the compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in
     * the <i>AWS Batch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CEType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         Environments</a> in the <i>AWS Batch User Guide</i>.
     * @see CEType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts
     * jobs from a queue and can scale out automatically based on queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
     *         accepts jobs from a queue and can scale out automatically based on queues.
     * @see CEState
     */
    public CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts
     * jobs from a queue and can scale out automatically based on queues.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
     *         accepts jobs from a queue and can scale out automatically based on queues.
     * @see CEState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Details of the compute resources managed by the compute environment. This parameter is required for managed
     * compute environments. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in
     * the <i>AWS Batch User Guide</i>.
     * </p>
     * 
     * @return Details of the compute resources managed by the compute environment. This parameter is required for
     *         managed compute environments. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         Environments</a> in the <i>AWS Batch User Guide</i>.
     */
    public ComputeResource computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on
     * your behalf.
     * </p>
     * <p>
     * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (this
     * is recommended) or prefix the role name with the path.
     * </p>
     * <note>
     * <p>
     * Depending on how you created your AWS Batch service role, its ARN may contain the <code>service-role</code> path
     * prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN does not use the
     * <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your
     * service role when you create compute environments.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
     *         services on your behalf.</p>
     *         <p>
     *         If your specified role has a path other than <code>/</code>, then you must either specify the full role
     *         ARN (this is recommended) or prefix the role name with the path.
     *         </p>
     *         <note>
     *         <p>
     *         Depending on how you created your AWS Batch service role, its ARN may contain the
     *         <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch
     *         assumes that your ARN does not use the <code>service-role</code> path prefix. Because of this, we
     *         recommend that you specify the full ARN of your service role when you create compute environments.
     *         </p>
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the compute environment to help you categorize and organize your resources. Each tag
     * consists of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in <i>AWS General
     * Reference</i>.
     * </p>
     * <p>
     * These tags can be updated or removed using the <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
     * operations. These tags do not propagate to the underlying compute resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags that you apply to the compute environment to help you categorize and organize your resources.
     *         Each tag consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in <i>AWS
     *         General Reference</i>.</p>
     *         <p>
     *         These tags can be updated or removed using the <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
     *         operations. These tags do not propagate to the underlying compute resources.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentRequest)) {
            return false;
        }
        CreateComputeEnvironmentRequest other = (CreateComputeEnvironmentRequest) obj;
        return Objects.equals(computeEnvironmentName(), other.computeEnvironmentName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(computeResources(), other.computeResources())
                && Objects.equals(serviceRole(), other.serviceRole()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateComputeEnvironmentRequest").add("ComputeEnvironmentName", computeEnvironmentName())
                .add("Type", typeAsString()).add("State", stateAsString()).add("ComputeResources", computeResources())
                .add("ServiceRole", serviceRole()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironmentName":
            return Optional.ofNullable(clazz.cast(computeEnvironmentName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "computeResources":
            return Optional.ofNullable(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateComputeEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
        /**
         * <p>
         * The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, hyphens, and
         * underscores are allowed.
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name for your compute environment. Up to 128 letters (uppercase and lowercase), numbers, hyphens,
         *        and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The type of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        Environments</a> in the <i>AWS Batch User Guide</i>.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        Environments</a> in the <i>AWS Batch User Guide</i>.
         * @see CEType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEType
         */
        Builder type(CEType type);

        /**
         * <p>
         * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
         * accepts jobs from a queue and can scale out automatically based on queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. If the state is <code>ENABLED</code>, then the compute
         *        environment accepts jobs from a queue and can scale out automatically based on queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment
         * accepts jobs from a queue and can scale out automatically based on queues.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. If the state is <code>ENABLED</code>, then the compute
         *        environment accepts jobs from a queue and can scale out automatically based on queues.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. This parameter is required for managed
         * compute environments. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param computeResources
         *        Details of the compute resources managed by the compute environment. This parameter is required for
         *        managed compute environments. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        Environments</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResource computeResources);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. This parameter is required for managed
         * compute environments. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>AWS Batch User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ComputeResource.Builder} avoiding the need to
         * create one manually via {@link ComputeResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeResource.Builder#build()} is called immediately and its
         * result is passed to {@link #computeResources(ComputeResource)}.
         * 
         * @param computeResources
         *        a consumer that will call methods on {@link ComputeResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResources(ComputeResource)
         */
        default Builder computeResources(Consumer<ComputeResource.Builder> computeResources) {
            return computeResources(ComputeResource.builder().applyMutation(computeResources).build());
        }

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services
         * on your behalf.
         * </p>
         * <p>
         * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
         * (this is recommended) or prefix the role name with the path.
         * </p>
         * <note>
         * <p>
         * Depending on how you created your AWS Batch service role, its ARN may contain the <code>service-role</code>
         * path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN does not use
         * the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of
         * your service role when you create compute environments.
         * </p>
         * </note>
         * 
         * @param serviceRole
         *        The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS
         *        services on your behalf.</p>
         *        <p>
         *        If your specified role has a path other than <code>/</code>, then you must either specify the full
         *        role ARN (this is recommended) or prefix the role name with the path.
         *        </p>
         *        <note>
         *        <p>
         *        Depending on how you created your AWS Batch service role, its ARN may contain the
         *        <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch
         *        assumes that your ARN does not use the <code>service-role</code> path prefix. Because of this, we
         *        recommend that you specify the full ARN of your service role when you create compute environments.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The tags that you apply to the compute environment to help you categorize and organize your resources. Each
         * tag consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in <i>AWS
         * General Reference</i>.
         * </p>
         * <p>
         * These tags can be updated or removed using the <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
         * operations. These tags do not propagate to the underlying compute resources.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the compute environment to help you categorize and organize your resources.
         *        Each tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in
         *        <i>AWS General Reference</i>.</p>
         *        <p>
         *        These tags can be updated or removed using the <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and
         *        <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a>
         *        API operations. These tags do not propagate to the underlying compute resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String type;

        private String state;

        private ComputeResource computeResources;

        private String serviceRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentRequest model) {
            super(model);
            computeEnvironmentName(model.computeEnvironmentName);
            type(model.type);
            state(model.state);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
            tags(model.tags);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResource.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeEnvironmentRequest build() {
            return new CreateComputeEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
