/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy associated with a job. For more information, see <a
 * href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <i>AWS
 * Batch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryStrategy implements SdkPojo, Serializable, ToCopyableBuilder<RetryStrategy.Builder, RetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attempts").getter(getter(RetryStrategy::attempts)).setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build()).build();

    private static final SdkField<List<EvaluateOnExit>> EVALUATE_ON_EXIT_FIELD = SdkField
            .<List<EvaluateOnExit>> builder(MarshallingType.LIST)
            .memberName("evaluateOnExit")
            .getter(getter(RetryStrategy::evaluateOnExit))
            .setter(setter(Builder::evaluateOnExit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateOnExit").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluateOnExit> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluateOnExit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD,
            EVALUATE_ON_EXIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer attempts;

    private final List<EvaluateOnExit> evaluateOnExit;

    private RetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
        this.evaluateOnExit = builder.evaluateOnExit;
    }

    /**
     * <p>
     * The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10 attempts.
     * If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of
     * attempts as the value.
     * </p>
     * 
     * @return The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10
     *         attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the
     *         same number of attempts as the value.
     */
    public Integer attempts() {
        return attempts;
    }

    /**
     * Returns true if the EvaluateOnExit property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEvaluateOnExit() {
        return evaluateOnExit != null && !(evaluateOnExit instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
     * parameter is specified, then the <code>attempts</code> parameter must also be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvaluateOnExit()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
     *         parameter is specified, then the <code>attempts</code> parameter must also be specified.
     */
    public List<EvaluateOnExit> evaluateOnExit() {
        return evaluateOnExit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluateOnExit() ? evaluateOnExit() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy) obj;
        return Objects.equals(attempts(), other.attempts()) && hasEvaluateOnExit() == other.hasEvaluateOnExit()
                && Objects.equals(evaluateOnExit(), other.evaluateOnExit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RetryStrategy").add("Attempts", attempts())
                .add("EvaluateOnExit", hasEvaluateOnExit() ? evaluateOnExit() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        case "evaluateOnExit":
            return Optional.ofNullable(clazz.cast(evaluateOnExit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryStrategy, T> g) {
        return obj -> g.apply((RetryStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryStrategy> {
        /**
         * <p>
         * The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and 10
         * attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same
         * number of attempts as the value.
         * </p>
         * 
         * @param attempts
         *        The number of times to move a job to the <code>RUNNABLE</code> status. You may specify between 1 and
         *        10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure
         *        the same number of attempts as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of up to 5 objects that specify conditions under which the job should be retried or failed. If
         *        this parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of up to 5 objects that specify conditions under which the job should be retried or failed. If
         *        this parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(EvaluateOnExit... evaluateOnExit);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EvaluateOnExit>.Builder} avoiding the need
         * to create one manually via {@link List<EvaluateOnExit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluateOnExit>.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluateOnExit(List<EvaluateOnExit>)}.
         * 
         * @param evaluateOnExit
         *        a consumer that will call methods on {@link List<EvaluateOnExit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluateOnExit(List<EvaluateOnExit>)
         */
        Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder>... evaluateOnExit);
    }

    static final class BuilderImpl implements Builder {
        private Integer attempts;

        private List<EvaluateOnExit> evaluateOnExit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStrategy model) {
            attempts(model.attempts);
            evaluateOnExit(model.evaluateOnExit);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        @Override
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        public final Collection<EvaluateOnExit.Builder> getEvaluateOnExit() {
            if (evaluateOnExit instanceof SdkAutoConstructList) {
                return null;
            }
            return evaluateOnExit != null ? evaluateOnExit.stream().map(EvaluateOnExit::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder evaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copy(evaluateOnExit);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(EvaluateOnExit... evaluateOnExit) {
            evaluateOnExit(Arrays.asList(evaluateOnExit));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder>... evaluateOnExit) {
            evaluateOnExit(Stream.of(evaluateOnExit).map(c -> EvaluateOnExit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluateOnExit(Collection<EvaluateOnExit.BuilderImpl> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copyFromBuilder(evaluateOnExit);
        }

        @Override
        public RetryStrategy build() {
            return new RetryStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
