/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Using AWS Batch, you can run batch computing workloads on the AWS Cloud. Batch computing is a common means for
 * developers, scientists, and engineers to access large amounts of compute resources. AWS Batch utilizes the advantages
 * of this computing workload to remove the undifferentiated heavy lifting of configuring and managing required
 * infrastructure, while also adopting a familiar batch computing software approach. Given these advantages, AWS Batch
 * can help you to efficiently provision resources in response to jobs submitted, thus effectively helping to eliminate
 * capacity constraints, reduce compute costs, and deliver your results more quickly.
 * </p>
 * <p>
 * As a fully managed service, AWS Batch can run batch computing workloads of any scale. AWS Batch automatically
 * provisions compute resources and optimizes workload distribution based on the quantity and scale of your specific
 * workloads. With AWS Batch, there's no need to install or manage batch computing software. This means that you can
 * focus your time and energy on analyzing results and solving your specific problems.
 * </p>
 */
package software.amazon.awssdk.services.batch;