/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information used to select Amazon Machine Images (AMIs) for instances in the compute environment. If the
 * <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL1</code>.
 * </p>
 * <note>
 * <p>
 * This object isn't applicable to jobs running on Fargate resources.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2Configuration implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2Configuration.Builder, Ec2Configuration> {
    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageType").getter(getter(Ec2Configuration::imageType)).setter(setter(Builder::imageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageType").build()).build();

    private static final SdkField<String> IMAGE_ID_OVERRIDE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageIdOverride").getter(getter(Ec2Configuration::imageIdOverride))
            .setter(setter(Builder::imageIdOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIdOverride").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TYPE_FIELD,
            IMAGE_ID_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageType;

    private final String imageIdOverride;

    private Ec2Configuration(BuilderImpl builder) {
        this.imageType = builder.imageType;
        this.imageIdOverride = builder.imageIdOverride;
    }

    /**
     * <p>
     * The image type to match with the instance type to select an AMI. If the <code>imageIdOverride</code> parameter
     * isn't specified, then a recent <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized
     * AMI</a> is used.
     * </p>
     * <dl>
     * <dt>ECS_AL2</dt>
     * <dd>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux
     * 2</a>− Default for all AWS Graviton-based instance families (for example, <code>C6g</code>, <code>M6g</code>,
     * <code>R6g</code>, and <code>T4g</code>) and can be used for all non-GPU instance types.
     * </p>
     * </dd>
     * <dt>ECS_AL2_NVIDIA</dt>
     * <dd>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon Linux
     * 2 (GPU)</a>−Default for all GPU instance families (for example <code>P4</code> and <code>G4</code>) and can be
     * used for all non-AWS Graviton-based instance types.
     * </p>
     * </dd>
     * <dt>ECS_AL1</dt>
     * <dd>
     * <p>
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon
     * Linux</a>−Default for all non-GPU, non-AWS-Graviton instance families. Amazon Linux is reaching the end-of-life
     * of standard support. For more information, see <a href="http://aws.amazon.com/amazon-linux-ami/">Amazon Linux
     * AMI</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The image type to match with the instance type to select an AMI. If the <code>imageIdOverride</code>
     *         parameter isn't specified, then a recent <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
     *         ECS-optimized AMI</a> is used.</p>
     *         <dl>
     *         <dt>ECS_AL2</dt>
     *         <dd>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon
     *         Linux 2</a>− Default for all AWS Graviton-based instance families (for example, <code>C6g</code>,
     *         <code>M6g</code>, <code>R6g</code>, and <code>T4g</code>) and can be used for all non-GPU instance types.
     *         </p>
     *         </dd>
     *         <dt>ECS_AL2_NVIDIA</dt>
     *         <dd>
     *         <p>
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon
     *         Linux 2 (GPU)</a>−Default for all GPU instance families (for example <code>P4</code> and <code>G4</code>)
     *         and can be used for all non-AWS Graviton-based instance types.
     *         </p>
     *         </dd>
     *         <dt>ECS_AL1</dt>
     *         <dd>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon
     *         Linux</a>−Default for all non-GPU, non-AWS-Graviton instance families. Amazon Linux is reaching the
     *         end-of-life of standard support. For more information, see <a
     *         href="http://aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a>.
     *         </p>
     *         </dd>
     */
    public String imageType() {
        return imageType;
    }

    /**
     * <p>
     * The AMI ID used for instances launched in the compute environment that match the image type. This setting
     * overrides the <code>imageId</code> set in the <code>computeResource</code> object.
     * </p>
     * 
     * @return The AMI ID used for instances launched in the compute environment that match the image type. This setting
     *         overrides the <code>imageId</code> set in the <code>computeResource</code> object.
     */
    public String imageIdOverride() {
        return imageIdOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageType());
        hashCode = 31 * hashCode + Objects.hashCode(imageIdOverride());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Configuration)) {
            return false;
        }
        Ec2Configuration other = (Ec2Configuration) obj;
        return Objects.equals(imageType(), other.imageType()) && Objects.equals(imageIdOverride(), other.imageIdOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Ec2Configuration").add("ImageType", imageType()).add("ImageIdOverride", imageIdOverride())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageType":
            return Optional.ofNullable(clazz.cast(imageType()));
        case "imageIdOverride":
            return Optional.ofNullable(clazz.cast(imageIdOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2Configuration, T> g) {
        return obj -> g.apply((Ec2Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2Configuration> {
        /**
         * <p>
         * The image type to match with the instance type to select an AMI. If the <code>imageIdOverride</code>
         * parameter isn't specified, then a recent <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         * ECS-optimized AMI</a> is used.
         * </p>
         * <dl>
         * <dt>ECS_AL2</dt>
         * <dd>
         * <p>
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon
         * Linux 2</a>− Default for all AWS Graviton-based instance families (for example, <code>C6g</code>,
         * <code>M6g</code>, <code>R6g</code>, and <code>T4g</code>) and can be used for all non-GPU instance types.
         * </p>
         * </dd>
         * <dt>ECS_AL2_NVIDIA</dt>
         * <dd>
         * <p>
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon
         * Linux 2 (GPU)</a>−Default for all GPU instance families (for example <code>P4</code> and <code>G4</code>) and
         * can be used for all non-AWS Graviton-based instance types.
         * </p>
         * </dd>
         * <dt>ECS_AL1</dt>
         * <dd>
         * <p>
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon
         * Linux</a>−Default for all non-GPU, non-AWS-Graviton instance families. Amazon Linux is reaching the
         * end-of-life of standard support. For more information, see <a
         * href="http://aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a>.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param imageType
         *        The image type to match with the instance type to select an AMI. If the <code>imageIdOverride</code>
         *        parameter isn't specified, then a recent <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon
         *        ECS-optimized AMI</a> is used.</p>
         *        <dl>
         *        <dt>ECS_AL2</dt>
         *        <dd>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">
         *        Amazon Linux 2</a>− Default for all AWS Graviton-based instance families (for example,
         *        <code>C6g</code>, <code>M6g</code>, <code>R6g</code>, and <code>T4g</code>) and can be used for all
         *        non-GPU instance types.
         *        </p>
         *        </dd>
         *        <dt>ECS_AL2_NVIDIA</dt>
         *        <dd>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">
         *        Amazon Linux 2 (GPU)</a>−Default for all GPU instance families (for example <code>P4</code> and
         *        <code>G4</code>) and can be used for all non-AWS Graviton-based instance types.
         *        </p>
         *        </dd>
         *        <dt>ECS_AL1</dt>
         *        <dd>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">
         *        Amazon Linux</a>−Default for all non-GPU, non-AWS-Graviton instance families. Amazon Linux is reaching
         *        the end-of-life of standard support. For more information, see <a
         *        href="http://aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a>.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageType(String imageType);

        /**
         * <p>
         * The AMI ID used for instances launched in the compute environment that match the image type. This setting
         * overrides the <code>imageId</code> set in the <code>computeResource</code> object.
         * </p>
         * 
         * @param imageIdOverride
         *        The AMI ID used for instances launched in the compute environment that match the image type. This
         *        setting overrides the <code>imageId</code> set in the <code>computeResource</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIdOverride(String imageIdOverride);
    }

    static final class BuilderImpl implements Builder {
        private String imageType;

        private String imageIdOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2Configuration model) {
            imageType(model.imageType);
            imageIdOverride(model.imageIdOverride);
        }

        public final String getImageType() {
            return imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final String getImageIdOverride() {
            return imageIdOverride;
        }

        @Override
        public final Builder imageIdOverride(String imageIdOverride) {
            this.imageIdOverride = imageIdOverride;
            return this;
        }

        public final void setImageIdOverride(String imageIdOverride) {
            this.imageIdOverride = imageIdOverride;
        }

        @Override
        public Ec2Configuration build() {
            return new Ec2Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
