/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container properties are used in job definitions to describe the container that is launched as part of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerProperties.Builder, ContainerProperties> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("image")
            .getter(getter(ContainerProperties::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<Integer> VCPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("vcpus")
            .getter(getter(ContainerProperties::vcpus)).setter(setter(Builder::vcpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vcpus").build()).build();

    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(ContainerProperties::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("command")
            .getter(getter(ContainerProperties::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobRoleArn").getter(getter(ContainerProperties::jobRoleArn)).setter(setter(Builder::jobRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRoleArn").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(ContainerProperties::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(ContainerProperties::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .memberName("environment")
            .getter(getter(ContainerProperties::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MountPoint>> MOUNT_POINTS_FIELD = SdkField
            .<List<MountPoint>> builder(MarshallingType.LIST)
            .memberName("mountPoints")
            .getter(getter(ContainerProperties::mountPoints))
            .setter(setter(Builder::mountPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MountPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MountPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("readonlyRootFilesystem").getter(getter(ContainerProperties::readonlyRootFilesystem))
            .setter(setter(Builder::readonlyRootFilesystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyRootFilesystem").build())
            .build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("privileged").getter(getter(ContainerProperties::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()).build();

    private static final SdkField<List<Ulimit>> ULIMITS_FIELD = SdkField
            .<List<Ulimit>> builder(MarshallingType.LIST)
            .memberName("ulimits")
            .getter(getter(ContainerProperties::ulimits))
            .setter(setter(Builder::ulimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ulimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ulimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ulimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("user")
            .getter(getter(ContainerProperties::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(ContainerProperties::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<List<ResourceRequirement>> builder(MarshallingType.LIST)
            .memberName("resourceRequirements")
            .getter(getter(ContainerProperties::resourceRequirements))
            .setter(setter(Builder::resourceRequirements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceRequirement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceRequirement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LinuxParameters> LINUX_PARAMETERS_FIELD = SdkField
            .<LinuxParameters> builder(MarshallingType.SDK_POJO).memberName("linuxParameters")
            .getter(getter(ContainerProperties::linuxParameters)).setter(setter(Builder::linuxParameters))
            .constructor(LinuxParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxParameters").build()).build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(ContainerProperties::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField
            .<List<Secret>> builder(MarshallingType.LIST)
            .memberName("secrets")
            .getter(getter(ContainerProperties::secrets))
            .setter(setter(Builder::secrets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Secret> builder(MarshallingType.SDK_POJO)
                                            .constructor(Secret::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(ContainerProperties::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<FargatePlatformConfiguration> FARGATE_PLATFORM_CONFIGURATION_FIELD = SdkField
            .<FargatePlatformConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("fargatePlatformConfiguration")
            .getter(getter(ContainerProperties::fargatePlatformConfiguration))
            .setter(setter(Builder::fargatePlatformConfiguration))
            .constructor(FargatePlatformConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargatePlatformConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, VCPUS_FIELD,
            MEMORY_FIELD, COMMAND_FIELD, JOB_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD, VOLUMES_FIELD, ENVIRONMENT_FIELD,
            MOUNT_POINTS_FIELD, READONLY_ROOT_FILESYSTEM_FIELD, PRIVILEGED_FIELD, ULIMITS_FIELD, USER_FIELD, INSTANCE_TYPE_FIELD,
            RESOURCE_REQUIREMENTS_FIELD, LINUX_PARAMETERS_FIELD, LOG_CONFIGURATION_FIELD, SECRETS_FIELD,
            NETWORK_CONFIGURATION_FIELD, FARGATE_PLATFORM_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String image;

    private final Integer vcpus;

    private final Integer memory;

    private final List<String> command;

    private final String jobRoleArn;

    private final String executionRoleArn;

    private final List<Volume> volumes;

    private final List<KeyValuePair> environment;

    private final List<MountPoint> mountPoints;

    private final Boolean readonlyRootFilesystem;

    private final Boolean privileged;

    private final List<Ulimit> ulimits;

    private final String user;

    private final String instanceType;

    private final List<ResourceRequirement> resourceRequirements;

    private final LinuxParameters linuxParameters;

    private final LogConfiguration logConfiguration;

    private final List<Secret> secrets;

    private final NetworkConfiguration networkConfiguration;

    private final FargatePlatformConfiguration fargatePlatformConfiguration;

    private ContainerProperties(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.privileged = builder.privileged;
        this.ulimits = builder.ulimits;
        this.user = builder.user;
        this.instanceType = builder.instanceType;
        this.resourceRequirements = builder.resourceRequirements;
        this.linuxParameters = builder.linuxParameters;
        this.logConfiguration = builder.logConfiguration;
        this.secrets = builder.secrets;
        this.networkConfiguration = builder.networkConfiguration;
        this.fargatePlatformConfiguration = builder.fargatePlatformConfiguration;
    }

    /**
     * <p>
     * The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker
     * Hub registry are available by default. Other repositories are specified with
     * <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and lowercase),
     * numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter
     * maps to <code>Image</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a
     * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     * <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * Docker image architecture must match the processor architecture of the compute resources that they're scheduled
     * on. For example, ARM-based Docker images can only run on ARM-based compute resources.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * Images in Amazon ECR repositories use the full registry and repository URI (for example,
     * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
     * <code>mongo</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in other repositories on Docker Hub are qualified with an organization name (for example,
     * <code>amazon/amazon-ecs-agent</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Images in other online repositories are qualified further by a domain name (for example,
     * <code>quay.io/assemblyline/ubuntu</code>).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The image used to start a container. This string is passed directly to the Docker daemon. Images in the
     *         Docker Hub registry are available by default. Other repositories are specified with
     *         <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and
     *         lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are
     *         allowed. This parameter maps to <code>Image</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code>
     *         parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note>
     *         <p>
     *         Docker image architecture must match the processor architecture of the compute resources that they're
     *         scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Images in Amazon ECR repositories use the full registry and repository URI (for example,
     *         <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
     *         <code>mongo</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in other repositories on Docker Hub are qualified with an organization name (for example,
     *         <code>amazon/amazon-ecs-agent</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Images in other online repositories are qualified further by a domain name (for example,
     *         <code>quay.io/assemblyline/ubuntu</code>).
     *         </p>
     *         </li>
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * This parameter is deprecated and not supported for jobs run on Fargate resources, see
     * <code>resourceRequirement</code>. The number of vCPUs reserved for the container. Jobs running on EC2 resources
     * can specify the vCPU requirement for the job using <code>resourceRequirements</code> but the vCPU requirements
     * can't be specified both here and in the <code>resourceRequirement</code> structure. This parameter maps to
     * <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a
     * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     * <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each
     * vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is required but can be specified
     * in several places. It must be specified for each node at least once.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided. Jobs running on
     * Fargate resources must specify the vCPU requirement for the job using <code>resourceRequirements</code>.
     * </p>
     * </note>
     * 
     * @return This parameter is deprecated and not supported for jobs run on Fargate resources, see
     *         <code>resourceRequirement</code>. The number of vCPUs reserved for the container. Jobs running on EC2
     *         resources can specify the vCPU requirement for the job using <code>resourceRequirements</code> but the
     *         vCPU requirements can't be specified both here and in the <code>resourceRequirement</code> structure.
     *         This parameter maps to <code>CpuShares</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>. Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is
     *         required but can be specified in several places. It must be specified for each node at least once.</p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided. Jobs
     *         running on Fargate resources must specify the vCPU requirement for the job using
     *         <code>resourceRequirements</code>.
     *         </p>
     */
    public Integer vcpus() {
        return vcpus;
    }

    /**
     * <p>
     * This parameter is deprecated and not supported for jobs run on Fargate resources, use
     * <code>ResourceRequirement</code>. For jobs run on EC2 resources can specify the memory requirement using the
     * <code>ResourceRequirement</code> structure. The hard limit (in MiB) of memory to present to the container. If
     * your container attempts to exceed the memory specified here, the container is killed. This parameter maps to
     * <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a
     * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     * <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. You must
     * specify at least 4 MiB of memory for a job. This is required but can be specified in several places; it must be
     * specified for each node at least once.
     * </p>
     * <note>
     * <p>
     * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a
     * particular instance type, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory Management</a> in the
     * <i>AWS Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @return This parameter is deprecated and not supported for jobs run on Fargate resources, use
     *         <code>ResourceRequirement</code>. For jobs run on EC2 resources can specify the memory requirement using
     *         the <code>ResourceRequirement</code> structure. The hard limit (in MiB) of memory to present to the
     *         container. If your container attempts to exceed the memory specified here, the container is killed. This
     *         parameter maps to <code>Memory</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code>
     *         option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. You must specify at
     *         least 4 MiB of memory for a job. This is required but can be specified in several places; it must be
     *         specified for each node at least once.</p> <note>
     *         <p>
     *         If you're trying to maximize your resource utilization by providing your jobs as much memory as possible
     *         for a particular instance type, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory Management</a> in
     *         the <i>AWS Batch User Guide</i>.
     *         </p>
     */
    public Integer memory() {
        return memory;
    }

    /**
     * Returns true if the Command property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to
     * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a
     * href="https://docs.docker.com/engine/reference/builder/#cmd"
     * >https://docs.docker.com/engine/reference/builder/#cmd</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCommand()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code>
     *         parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more
     *         information, see <a
     *         href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine
     *         /reference/builder/#cmd</a>.
     */
    public List<String> command() {
        return command;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM
     * Roles for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
     *         Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public String jobRoleArn() {
        return jobRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. Jobs running on Fargate resources
     * must provide an execution role. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM
     * role</a> in the <i>AWS Batch User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. Jobs running on Fargate
     *         resources must provide an execution role. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM
     *         role</a> in the <i>AWS Batch User Guide</i>.
     */
    public String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * Returns true if the Volumes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of data volumes used in a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVolumes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of data volumes used in a job.
     */
    public List<Volume> volumes() {
        return volumes;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <important>
     * <p>
     * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
     * </p>
     * </important> <note>
     * <p>
     * Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for
     * variables that are set by the AWS Batch service.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code>
     *         option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <important>
     *         <p>
     *         We don't recommend using plaintext environment variables for sensitive information, such as credential
     *         data.
     *         </p>
     *         </important> <note>
     *         <p>
     *         Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for
     *         variables that are set by the AWS Batch service.
     *         </p>
     */
    public List<KeyValuePair> environment() {
        return environment;
    }

    /**
     * Returns true if the MountPoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMountPoints() {
        return mountPoints != null && !(mountPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMountPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the
     *         <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
     *         the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     */
    public List<MountPoint> mountPoints() {
        return mountPoints;
    }

    /**
     * <p>
     * When this parameter is true, the container is given read-only access to its root file system. This parameter maps
     * to <code>ReadonlyRootfs</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to
     * <code>docker run</code>.
     * </p>
     * 
     * @return When this parameter is true, the container is given read-only access to its root file system. This
     *         parameter maps to <code>ReadonlyRootfs</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--read-only</code> option to <code>docker run</code>.
     */
    public Boolean readonlyRootFilesystem() {
        return readonlyRootFilesystem;
    }

    /**
     * <p>
     * When this parameter is true, the container is given elevated permissions on the host container instance (similar
     * to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. The default value is false.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided, or specified as
     * false.
     * </p>
     * </note>
     * 
     * @return When this parameter is true, the container is given elevated permissions on the host container instance
     *         (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>. The default value is false.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided, or
     *         specified as false.
     *         </p>
     */
    public Boolean privileged() {
        return privileged;
    }

    /**
     * Returns true if the Ulimits property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUlimits() {
        return ulimits != null && !(ulimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUlimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in
     *         the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section
     *         of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
     *         </p>
     */
    public List<Ulimit> ulimits() {
        return ulimits;
    }

    /**
     * <p>
     * The user name to use inside the container. This parameter maps to <code>User</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a
     * href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     * </p>
     * 
     * @return The user name to use inside the container. This parameter maps to <code>User</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code>
     *         option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
     */
    public String user() {
        return user;
    }

    /**
     * <p>
     * The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the
     * same instance type.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to single-node container jobs or for jobs running on Fargate resources and
     * shouldn't be provided.
     * </p>
     * </note>
     * 
     * @return The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must
     *         use the same instance type.</p> <note>
     *         <p>
     *         This parameter isn't applicable to single-node container jobs or for jobs running on Fargate resources
     *         and shouldn't be provided.
     *         </p>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * Returns true if the ResourceRequirements property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResourceRequirements() {
        return resourceRequirements != null && !(resourceRequirements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>,
     * <code>MEMORY</code>, and <code>VCPU</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceRequirements()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The type and amount of resources to assign to a container. The supported resources include
     *         <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
     */
    public List<ResourceRequirement> resourceRequirements() {
        return resourceRequirements;
    }

    /**
     * <p>
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     * </p>
     * 
     * @return Linux-specific modifications that are applied to the container, such as details for device mappings.
     */
    public LinuxParameters linuxParameters() {
        return linuxParameters;
    }

    /**
     * <p>
     * The log configuration specification for the container.
     * </p>
     * <p>
     * This parameter maps to <code>LogConfig</code> in the <a
     * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
     * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option
     * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use the same
     * logging driver that the Docker daemon uses. However the container might use a different logging driver than the
     * Docker daemon by specifying a log driver with this parameter in the container definition. To use a different
     * logging driver for a container, the log system must be configured properly on the container instance (or on a
     * different log server for remote logging options). For more information on the options for different supported log
     * drivers, see <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in
     * the Docker documentation.
     * </p>
     * <note>
     * <p>
     * AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the
     * <a>LogConfiguration</a> data type).
     * </p>
     * </note>
     * <p>
     * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the
     * Docker Remote API version on your container instance, log into your container instance and run the following
     * command: <code>sudo docker version | grep "Server API version"</code>
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent running on a container instance must register the logging drivers available on
     * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed
     * on that instance can use these log configuration options. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
     * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The log configuration specification for the container.</p>
     *         <p>
     *         This parameter maps to <code>LogConfig</code> in the <a
     *         href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the
     *         <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
     *         <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
     *         run</a>. By default, containers use the same logging driver that the Docker daemon uses. However the
     *         container might use a different logging driver than the Docker daemon by specifying a log driver with
     *         this parameter in the container definition. To use a different logging driver for a container, the log
     *         system must be configured properly on the container instance (or on a different log server for remote
     *         logging options). For more information on the options for different supported log drivers, see <a
     *         href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
     *         documentation.
     *         </p>
     *         <note>
     *         <p>
     *         AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the
     *         <a>LogConfiguration</a> data type).
     *         </p>
     *         </note>
     *         <p>
     *         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To
     *         check the Docker Remote API version on your container instance, log into your container instance and run
     *         the following command: <code>sudo docker version | grep "Server API version"</code>
     *         </p>
     *         <note>
     *         <p>
     *         The Amazon ECS container agent running on a container instance must register the logging drivers
     *         available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable
     *         before containers placed on that instance can use these log configuration options. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon
     *         ECS Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     */
    public LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * Returns true if the Secrets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecrets() {
        return secrets != null && !(secrets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secrets for the container. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive
     * data</a> in the <i>AWS Batch User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecrets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The secrets for the container. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying
     *         sensitive data</a> in the <i>AWS Batch User Guide</i>.
     */
    public List<Secret> secrets() {
        return secrets;
    }

    /**
     * <p>
     * The network configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not specify
     * this parameter.
     * </p>
     * 
     * @return The network configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
     *         specify this parameter.
     */
    public NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not specify
     * this parameter.
     * </p>
     * 
     * @return The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
     *         specify this parameter.
     */
    public FargatePlatformConfiguration fargatePlatformConfiguration() {
        return fargatePlatformConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(vcpus());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMountPoints() ? mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        hashCode = 31 * hashCode + Objects.hashCode(hasUlimits() ? ulimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceRequirements() ? resourceRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecrets() ? secrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(fargatePlatformConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProperties)) {
            return false;
        }
        ContainerProperties other = (ContainerProperties) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(vcpus(), other.vcpus())
                && Objects.equals(memory(), other.memory()) && hasCommand() == other.hasCommand()
                && Objects.equals(command(), other.command()) && Objects.equals(jobRoleArn(), other.jobRoleArn())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && hasMountPoints() == other.hasMountPoints()
                && Objects.equals(mountPoints(), other.mountPoints())
                && Objects.equals(readonlyRootFilesystem(), other.readonlyRootFilesystem())
                && Objects.equals(privileged(), other.privileged()) && hasUlimits() == other.hasUlimits()
                && Objects.equals(ulimits(), other.ulimits()) && Objects.equals(user(), other.user())
                && Objects.equals(instanceType(), other.instanceType())
                && hasResourceRequirements() == other.hasResourceRequirements()
                && Objects.equals(resourceRequirements(), other.resourceRequirements())
                && Objects.equals(linuxParameters(), other.linuxParameters())
                && Objects.equals(logConfiguration(), other.logConfiguration()) && hasSecrets() == other.hasSecrets()
                && Objects.equals(secrets(), other.secrets())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(fargatePlatformConfiguration(), other.fargatePlatformConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ContainerProperties").add("Image", image()).add("Vcpus", vcpus()).add("Memory", memory())
                .add("Command", hasCommand() ? command() : null).add("JobRoleArn", jobRoleArn())
                .add("ExecutionRoleArn", executionRoleArn()).add("Volumes", hasVolumes() ? volumes() : null)
                .add("Environment", hasEnvironment() ? environment() : null)
                .add("MountPoints", hasMountPoints() ? mountPoints() : null)
                .add("ReadonlyRootFilesystem", readonlyRootFilesystem()).add("Privileged", privileged())
                .add("Ulimits", hasUlimits() ? ulimits() : null).add("User", user()).add("InstanceType", instanceType())
                .add("ResourceRequirements", hasResourceRequirements() ? resourceRequirements() : null)
                .add("LinuxParameters", linuxParameters()).add("LogConfiguration", logConfiguration())
                .add("Secrets", hasSecrets() ? secrets() : null).add("NetworkConfiguration", networkConfiguration())
                .add("FargatePlatformConfiguration", fargatePlatformConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "vcpus":
            return Optional.ofNullable(clazz.cast(vcpus()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "jobRoleArn":
            return Optional.ofNullable(clazz.cast(jobRoleArn()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "mountPoints":
            return Optional.ofNullable(clazz.cast(mountPoints()));
        case "readonlyRootFilesystem":
            return Optional.ofNullable(clazz.cast(readonlyRootFilesystem()));
        case "privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        case "ulimits":
            return Optional.ofNullable(clazz.cast(ulimits()));
        case "user":
            return Optional.ofNullable(clazz.cast(user()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "resourceRequirements":
            return Optional.ofNullable(clazz.cast(resourceRequirements()));
        case "linuxParameters":
            return Optional.ofNullable(clazz.cast(linuxParameters()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "secrets":
            return Optional.ofNullable(clazz.cast(secrets()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "fargatePlatformConfiguration":
            return Optional.ofNullable(clazz.cast(fargatePlatformConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerProperties, T> g) {
        return obj -> g.apply((ContainerProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerProperties> {
        /**
         * <p>
         * The image used to start a container. This string is passed directly to the Docker daemon. Images in the
         * Docker Hub registry are available by default. Other repositories are specified with
         * <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and lowercase),
         * numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter
         * maps to <code>Image</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter
         * of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * Docker image architecture must match the processor architecture of the compute resources that they're
         * scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
         * </p>
         * </note>
         * <ul>
         * <li>
         * <p>
         * Images in Amazon ECR repositories use the full registry and repository URI (for example,
         * <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
         * <code>mongo</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in other repositories on Docker Hub are qualified with an organization name (for example,
         * <code>amazon/amazon-ecs-agent</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * Images in other online repositories are qualified further by a domain name (for example,
         * <code>quay.io/assemblyline/ubuntu</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param image
         *        The image used to start a container. This string is passed directly to the Docker daemon. Images in
         *        the Docker Hub registry are available by default. Other repositories are specified with
         *        <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and
         *        lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are
         *        allowed. This parameter maps to <code>Image</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        Docker image architecture must match the processor architecture of the compute resources that they're
         *        scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
         *        </p>
         *        </note>
         *        <ul>
         *        <li>
         *        <p>
         *        Images in Amazon ECR repositories use the full registry and repository URI (for example,
         *        <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or
         *        <code>mongo</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in other repositories on Docker Hub are qualified with an organization name (for example,
         *        <code>amazon/amazon-ecs-agent</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Images in other online repositories are qualified further by a domain name (for example,
         *        <code>quay.io/assemblyline/ubuntu</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * This parameter is deprecated and not supported for jobs run on Fargate resources, see
         * <code>resourceRequirement</code>. The number of vCPUs reserved for the container. Jobs running on EC2
         * resources can specify the vCPU requirement for the job using <code>resourceRequirements</code> but the vCPU
         * requirements can't be specified both here and in the <code>resourceRequirement</code> structure. This
         * parameter maps to <code>CpuShares</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each vCPU is equivalent to
         * 1,024 CPU shares. You must specify at least one vCPU. This is required but can be specified in several
         * places. It must be specified for each node at least once.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided. Jobs running
         * on Fargate resources must specify the vCPU requirement for the job using <code>resourceRequirements</code>.
         * </p>
         * </note>
         * 
         * @param vcpus
         *        This parameter is deprecated and not supported for jobs run on Fargate resources, see
         *        <code>resourceRequirement</code>. The number of vCPUs reserved for the container. Jobs running on EC2
         *        resources can specify the vCPU requirement for the job using <code>resourceRequirements</code> but the
         *        vCPU requirements can't be specified both here and in the <code>resourceRequirement</code> structure.
         *        This parameter maps to <code>CpuShares</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is
         *        required but can be specified in several places. It must be specified for each node at least once.</p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided. Jobs
         *        running on Fargate resources must specify the vCPU requirement for the job using
         *        <code>resourceRequirements</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcpus(Integer vcpus);

        /**
         * <p>
         * This parameter is deprecated and not supported for jobs run on Fargate resources, use
         * <code>ResourceRequirement</code>. For jobs run on EC2 resources can specify the memory requirement using the
         * <code>ResourceRequirement</code> structure. The hard limit (in MiB) of memory to present to the container. If
         * your container attempts to exceed the memory specified here, the container is killed. This parameter maps to
         * <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a
         * container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and
         * the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places;
         * it must be specified for each node at least once.
         * </p>
         * <note>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for
         * a particular instance type, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory Management</a> in the
         * <i>AWS Batch User Guide</i>.
         * </p>
         * </note>
         * 
         * @param memory
         *        This parameter is deprecated and not supported for jobs run on Fargate resources, use
         *        <code>ResourceRequirement</code>. For jobs run on EC2 resources can specify the memory requirement
         *        using the <code>ResourceRequirement</code> structure. The hard limit (in MiB) of memory to present to
         *        the container. If your container attempts to exceed the memory specified here, the container is
         *        killed. This parameter maps to <code>Memory</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. You must specify at least 4 MiB of memory for a job. This is required but can be specified in
         *        several places; it must be specified for each node at least once.</p> <note>
         *        <p>
         *        If you're trying to maximize your resource utilization by providing your jobs as much memory as
         *        possible for a particular instance type, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory Management</a>
         *        in the <i>AWS Batch User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a
         * href="https://docs.docker.com/engine/reference/builder/#cmd"
         * >https://docs.docker.com/engine/reference/builder/#cmd</a>.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#cmd">https
         *        ://docs.docker.com/engine/reference/builder/#cmd</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a
         * href="https://docs.docker.com/engine/reference/builder/#cmd"
         * >https://docs.docker.com/engine/reference/builder/#cmd</a>.
         * </p>
         * 
         * @param command
         *        The command that is passed to the container. This parameter maps to <code>Cmd</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. For more information, see <a
         *        href="https://docs.docker.com/engine/reference/builder/#cmd">https
         *        ://docs.docker.com/engine/reference/builder/#cmd</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
         * Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param jobRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Roles for
         *        Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRoleArn(String jobRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. Jobs running on Fargate
         * resources must provide an execution role. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM
         * role</a> in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. Jobs running on
         *        Fargate resources must provide an execution role. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution
         *        IAM role</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * 
         * @param volumes
         *        A list of data volumes used in a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * 
         * @param volumes
         *        A list of data volumes used in a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Volume>.Builder} avoiding the need to
         * create one manually via {@link List<Volume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Volume>.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<Volume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to
         * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important> <note>
         * <p>
         * Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for
         * variables that are set by the AWS Batch service.
         * </p>
         * </note>
         * 
         * @param environment
         *        The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <important>
         *        <p>
         *        We don't recommend using plaintext environment variables for sensitive information, such as credential
         *        data.
         *        </p>
         *        </important> <note>
         *        <p>
         *        Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved
         *        for variables that are set by the AWS Batch service.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<KeyValuePair> environment);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to
         * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important> <note>
         * <p>
         * Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for
         * variables that are set by the AWS Batch service.
         * </p>
         * </note>
         * 
         * @param environment
         *        The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <important>
         *        <p>
         *        We don't recommend using plaintext environment variables for sensitive information, such as credential
         *        data.
         *        </p>
         *        </important> <note>
         *        <p>
         *        Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved
         *        for variables that are set by the AWS Batch service.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(KeyValuePair... environment);

        /**
         * <p>
         * The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to
         * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <important>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data.
         * </p>
         * </important> <note>
         * <p>
         * Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for
         * variables that are set by the AWS Batch service.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<KeyValuePair>.Builder} avoiding the
         * need to create one manually via {@link List<KeyValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyValuePair>.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(List<KeyValuePair>)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link List<KeyValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(List<KeyValuePair>)
         */
        Builder environment(Consumer<KeyValuePair.Builder>... environment);

        /**
         * <p>
         * The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(Collection<MountPoint> mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(MountPoint... mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MountPoint>.Builder} avoiding the need to
         * create one manually via {@link List<MountPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MountPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #mountPoints(List<MountPoint>)}.
         * 
         * @param mountPoints
         *        a consumer that will call methods on {@link List<MountPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountPoints(List<MountPoint>)
         */
        Builder mountPoints(Consumer<MountPoint.Builder>... mountPoints);

        /**
         * <p>
         * When this parameter is true, the container is given read-only access to its root file system. This parameter
         * maps to <code>ReadonlyRootfs</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code>
         * option to <code>docker run</code>.
         * </p>
         * 
         * @param readonlyRootFilesystem
         *        When this parameter is true, the container is given read-only access to its root file system. This
         *        parameter maps to <code>ReadonlyRootfs</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--read-only</code> option to <code>docker run</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem);

        /**
         * <p>
         * When this parameter is true, the container is given elevated permissions on the host container instance
         * (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. The default value is false.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided, or specified
         * as false.
         * </p>
         * </note>
         * 
         * @param privileged
         *        When this parameter is true, the container is given elevated permissions on the host container
         *        instance (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. The default value is false.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided, or
         *        specified as false.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param ulimits
         *        A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Collection<Ulimit> ulimits);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param ulimits
         *        A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in
         *        the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a>
         *        section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulimits(Ulimit... ulimits);

        /**
         * <p>
         * A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option
         * to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Ulimit>.Builder} avoiding the need
         * to create one manually via {@link List<Ulimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Ulimit>.Builder#build()} is called immediately and its
         * result is passed to {@link #ulimits(List<Ulimit>)}.
         * 
         * @param ulimits
         *        a consumer that will call methods on {@link List<Ulimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ulimits(List<Ulimit>)
         */
        Builder ulimits(Consumer<Ulimit.Builder>... ulimits);

        /**
         * <p>
         * The user name to use inside the container. This parameter maps to <code>User</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to
         * <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * </p>
         * 
         * @param user
         *        The user name to use inside the container. This parameter maps to <code>User</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use
         * the same instance type.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to single-node container jobs or for jobs running on Fargate resources and
         * shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param instanceType
         *        The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job
         *        must use the same instance type.</p> <note>
         *        <p>
         *        This parameter isn't applicable to single-node container jobs or for jobs running on Fargate resources
         *        and shouldn't be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>,
         * <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of resources to assign to a container. The supported resources include
         *        <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements);

        /**
         * <p>
         * The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>,
         * <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * 
         * @param resourceRequirements
         *        The type and amount of resources to assign to a container. The supported resources include
         *        <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRequirements(ResourceRequirement... resourceRequirements);

        /**
         * <p>
         * The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>,
         * <code>MEMORY</code>, and <code>VCPU</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceRequirement>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceRequirement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceRequirement>.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceRequirements(List<ResourceRequirement>)}.
         * 
         * @param resourceRequirements
         *        a consumer that will call methods on {@link List<ResourceRequirement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceRequirements(List<ResourceRequirement>)
         */
        Builder resourceRequirements(Consumer<ResourceRequirement.Builder>... resourceRequirements);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * </p>
         * 
         * @param linuxParameters
         *        Linux-specific modifications that are applied to the container, such as details for device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linuxParameters(LinuxParameters linuxParameters);

        /**
         * <p>
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         * </p>
         * This is a convenience that creates an instance of the {@link LinuxParameters.Builder} avoiding the need to
         * create one manually via {@link LinuxParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link LinuxParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #linuxParameters(LinuxParameters)}.
         * 
         * @param linuxParameters
         *        a consumer that will call methods on {@link LinuxParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linuxParameters(LinuxParameters)
         */
        default Builder linuxParameters(Consumer<LinuxParameters.Builder> linuxParameters) {
            return linuxParameters(LinuxParameters.builder().applyMutation(linuxParameters).build());
        }

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use
         * the same logging driver that the Docker daemon uses. However the container might use a different logging
         * driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To
         * use a different logging driver for a container, the log system must be configured properly on the container
         * instance (or on a different log server for remote logging options). For more information on the options for
         * different supported log drivers, see <a
         * href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
         * documentation.
         * </p>
         * <note>
         * <p>
         * AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the
         * <a>LogConfiguration</a> data type).
         * </p>
         * </note>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check
         * the Docker Remote API version on your container instance, log into your container instance and run the
         * following command: <code>sudo docker version | grep "Server API version"</code>
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on
         * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers
         * placed on that instance can use these log configuration options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param logConfiguration
         *        The log configuration specification for the container.</p>
         *        <p>
         *        This parameter maps to <code>LogConfig</code> in the <a
         *        href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of
         *        the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the
         *        <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker
         *        run</a>. By default, containers use the same logging driver that the Docker daemon uses. However the
         *        container might use a different logging driver than the Docker daemon by specifying a log driver with
         *        this parameter in the container definition. To use a different logging driver for a container, the log
         *        system must be configured properly on the container instance (or on a different log server for remote
         *        logging options). For more information on the options for different supported log drivers, see <a
         *        href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the
         *        Docker documentation.
         *        </p>
         *        <note>
         *        <p>
         *        AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in
         *        the <a>LogConfiguration</a> data type).
         *        </p>
         *        </note>
         *        <p>
         *        This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
         *        To check the Docker Remote API version on your container instance, log into your container instance
         *        and run the following command: <code>sudo docker version | grep "Server API version"</code>
         *        </p>
         *        <note>
         *        <p>
         *        The Amazon ECS container agent running on a container instance must register the logging drivers
         *        available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable
         *        before containers placed on that instance can use these log configuration options. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS
         *        Container Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The log configuration specification for the container.
         * </p>
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a
         * href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a
         * href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code>
         * option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use
         * the same logging driver that the Docker daemon uses. However the container might use a different logging
         * driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To
         * use a different logging driver for a container, the log system must be configured properly on the container
         * instance (or on a different log server for remote logging options). For more information on the options for
         * different supported log drivers, see <a
         * href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker
         * documentation.
         * </p>
         * <note>
         * <p>
         * AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the
         * <a>LogConfiguration</a> data type).
         * </p>
         * </note>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check
         * the Docker Remote API version on your container instance, log into your container instance and run the
         * following command: <code>sudo docker version | grep "Server API version"</code>
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on
         * that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers
         * placed on that instance can use these log configuration options. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS Container
         * Agent Configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The secrets for the container. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive
         * data</a> in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param secrets
         *        The secrets for the container. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying
         *        sensitive data</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Collection<Secret> secrets);

        /**
         * <p>
         * The secrets for the container. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive
         * data</a> in the <i>AWS Batch User Guide</i>.
         * </p>
         * 
         * @param secrets
         *        The secrets for the container. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying
         *        sensitive data</a> in the <i>AWS Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secrets(Secret... secrets);

        /**
         * <p>
         * The secrets for the container. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive
         * data</a> in the <i>AWS Batch User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Secret>.Builder} avoiding the need to
         * create one manually via {@link List<Secret>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Secret>.Builder#build()} is called immediately and its
         * result is passed to {@link #secrets(List<Secret>)}.
         * 
         * @param secrets
         *        a consumer that will call methods on {@link List<Secret>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secrets(List<Secret>)
         */
        Builder secrets(Consumer<Secret.Builder>... secrets);

        /**
         * <p>
         * The network configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
         * specify this parameter.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for jobs running on Fargate resources. Jobs running on EC2 resources must
         *        not specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
         * specify this parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfiguration.Builder} avoiding the need
         * to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
         * specify this parameter.
         * </p>
         * 
         * @param fargatePlatformConfiguration
         *        The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must
         *        not specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargatePlatformConfiguration(FargatePlatformConfiguration fargatePlatformConfiguration);

        /**
         * <p>
         * The platform configuration for jobs running on Fargate resources. Jobs running on EC2 resources must not
         * specify this parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link FargatePlatformConfiguration.Builder} avoiding
         * the need to create one manually via {@link FargatePlatformConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FargatePlatformConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #fargatePlatformConfiguration(FargatePlatformConfiguration)}.
         * 
         * @param fargatePlatformConfiguration
         *        a consumer that will call methods on {@link FargatePlatformConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fargatePlatformConfiguration(FargatePlatformConfiguration)
         */
        default Builder fargatePlatformConfiguration(Consumer<FargatePlatformConfiguration.Builder> fargatePlatformConfiguration) {
            return fargatePlatformConfiguration(FargatePlatformConfiguration.builder()
                    .applyMutation(fargatePlatformConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String image;

        private Integer vcpus;

        private Integer memory;

        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private String jobRoleArn;

        private String executionRoleArn;

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();

        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();

        private Boolean readonlyRootFilesystem;

        private Boolean privileged;

        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();

        private String user;

        private String instanceType;

        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();

        private LinuxParameters linuxParameters;

        private LogConfiguration logConfiguration;

        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();

        private NetworkConfiguration networkConfiguration;

        private FargatePlatformConfiguration fargatePlatformConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProperties model) {
            image(model.image);
            vcpus(model.vcpus);
            memory(model.memory);
            command(model.command);
            jobRoleArn(model.jobRoleArn);
            executionRoleArn(model.executionRoleArn);
            volumes(model.volumes);
            environment(model.environment);
            mountPoints(model.mountPoints);
            readonlyRootFilesystem(model.readonlyRootFilesystem);
            privileged(model.privileged);
            ulimits(model.ulimits);
            user(model.user);
            instanceType(model.instanceType);
            resourceRequirements(model.resourceRequirements);
            linuxParameters(model.linuxParameters);
            logConfiguration(model.logConfiguration);
            secrets(model.secrets);
            networkConfiguration(model.networkConfiguration);
            fargatePlatformConfiguration(model.fargatePlatformConfiguration);
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getVcpus() {
            return vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        public final String getJobRoleArn() {
            return jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final Collection<Volume.Builder> getVolumes() {
            if (volumes instanceof SdkAutoConstructList) {
                return null;
            }
            return volumes != null ? volumes.stream().map(Volume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        public final Collection<KeyValuePair.Builder> getEnvironment() {
            if (environment instanceof SdkAutoConstructList) {
                return null;
            }
            return environment != null ? environment.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder>... environment) {
            environment(Stream.of(environment).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        public final Collection<MountPoint.Builder> getMountPoints() {
            if (mountPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return mountPoints != null ? mountPoints.stream().map(MountPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder>... mountPoints) {
            mountPoints(Stream.of(mountPoints).map(c -> MountPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointsCopier.copyFromBuilder(mountPoints);
        }

        public final Boolean getReadonlyRootFilesystem() {
            return readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final Collection<Ulimit.Builder> getUlimits() {
            if (ulimits instanceof SdkAutoConstructList) {
                return null;
            }
            return ulimits != null ? ulimits.stream().map(Ulimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit... ulimits) {
            ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder>... ulimits) {
            ulimits(Stream.of(ulimits).map(c -> Ulimit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitsCopier.copyFromBuilder(ulimits);
        }

        public final String getUser() {
            return user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Collection<ResourceRequirement.Builder> getResourceRequirements() {
            if (resourceRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceRequirements != null ? resourceRequirements.stream().map(ResourceRequirement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement... resourceRequirements) {
            resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder>... resourceRequirements) {
            resourceRequirements(Stream.of(resourceRequirements).map(c -> ResourceRequirement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        public final LinuxParameters.Builder getLinuxParameters() {
            return linuxParameters != null ? linuxParameters.toBuilder() : null;
        }

        @Override
        public final Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final void setLinuxParameters(LinuxParameters.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        public final Collection<Secret.Builder> getSecrets() {
            if (secrets instanceof SdkAutoConstructList) {
                return null;
            }
            return secrets != null ? secrets.stream().map(Secret::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret... secrets) {
            secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder>... secrets) {
            secrets(Stream.of(secrets).map(c -> Secret.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final FargatePlatformConfiguration.Builder getFargatePlatformConfiguration() {
            return fargatePlatformConfiguration != null ? fargatePlatformConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder fargatePlatformConfiguration(FargatePlatformConfiguration fargatePlatformConfiguration) {
            this.fargatePlatformConfiguration = fargatePlatformConfiguration;
            return this;
        }

        public final void setFargatePlatformConfiguration(FargatePlatformConfiguration.BuilderImpl fargatePlatformConfiguration) {
            this.fargatePlatformConfiguration = fargatePlatformConfiguration != null ? fargatePlatformConfiguration.build()
                    : null;
        }

        @Override
        public ContainerProperties build() {
            return new ContainerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
