/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Determine whether your data volume persists on the host container instance and where it is stored. If this parameter
 * is empty, then the Docker daemon assigns a host path for your data volume, but the data isn't guaranteed to persist
 * after the containers associated with it stop running.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Host implements SdkPojo, Serializable, ToCopyableBuilder<Host.Builder, Host> {
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourcePath").getter(getter(Host::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourcePath;

    private Host(BuilderImpl builder) {
        this.sourcePath = builder.sourcePath;
    }

    /**
     * <p>
     * The path on the host container instance that's presented to the container. If this parameter is empty, then the
     * Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume
     * persists at the specified location on the host container instance until you delete it manually. If the source
     * path location does not exist on the host container instance, the Docker daemon creates it. If the location does
     * exist, the contents of the source path folder are exported.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
     * </p>
     * </note>
     * 
     * @return The path on the host container instance that's presented to the container. If this parameter is empty,
     *         then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then
     *         the data volume persists at the specified location on the host container instance until you delete it
     *         manually. If the source path location does not exist on the host container instance, the Docker daemon
     *         creates it. If the location does exist, the contents of the source path folder are exported.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
     *         </p>
     */
    public final String sourcePath() {
        return sourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(sourcePath(), other.sourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Host").add("SourcePath", sourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * The path on the host container instance that's presented to the container. If this parameter is empty, then
         * the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data
         * volume persists at the specified location on the host container instance until you delete it manually. If the
         * source path location does not exist on the host container instance, the Docker daemon creates it. If the
         * location does exist, the contents of the source path folder are exported.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param sourcePath
         *        The path on the host container instance that's presented to the container. If this parameter is empty,
         *        then the Docker daemon has assigned a host path for you. If this parameter contains a file location,
         *        then the data volume persists at the specified location on the host container instance until you
         *        delete it manually. If the source path location does not exist on the host container instance, the
         *        Docker daemon creates it. If the location does exist, the contents of the source path folder are
         *        exported.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources and shouldn't be provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            sourcePath(model.sourcePath);
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public Host build() {
            return new Host(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
