/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.Host;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Volume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Volume> {
    private static final SdkField<Host> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("host").getter(Volume.getter(Volume::host)).setter(Volume.setter(Builder::host)).constructor(Host::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Volume.getter(Volume::name)).setter(Volume.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Host host;
    private final String name;

    private Volume(BuilderImpl builder) {
        this.host = builder.host;
        this.name = builder.name;
    }

    public final Host host() {
        return this.host;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"Volume").add("Host", (Object)this.host()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Host host;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.host(model.host);
            this.name(model.name);
        }

        public final Host.Builder getHost() {
            return this.host != null ? this.host.toBuilder() : null;
        }

        @Override
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public Volume build() {
            return new Volume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Volume> {
        public Builder host(Host var1);

        default public Builder host(Consumer<Host.Builder> host) {
            return this.host((Host)((Host.Builder)Host.builder().applyMutation(host)).build());
        }

        public Builder name(String var1);
    }
}

