/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetail;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputeEnvironmentsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
    private static final SdkField<List<ComputeEnvironmentDetail>> COMPUTE_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computeEnvironments").getter(DescribeComputeEnvironmentsResponse.getter(DescribeComputeEnvironmentsResponse::computeEnvironments)).setter(DescribeComputeEnvironmentsResponse.setter(Builder::computeEnvironments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputeEnvironmentDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeComputeEnvironmentsResponse.getter(DescribeComputeEnvironmentsResponse::nextToken)).setter(DescribeComputeEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ComputeEnvironmentDetail> computeEnvironments;
    private final String nextToken;

    private DescribeComputeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironments = builder.computeEnvironments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComputeEnvironments() {
        return this.computeEnvironments != null && !(this.computeEnvironments instanceof SdkAutoConstructList);
    }

    public final List<ComputeEnvironmentDetail> computeEnvironments() {
        return this.computeEnvironments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputeEnvironments() ? this.computeEnvironments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeEnvironmentsResponse)) {
            return false;
        }
        DescribeComputeEnvironmentsResponse other = (DescribeComputeEnvironmentsResponse)((Object)obj);
        return this.hasComputeEnvironments() == other.hasComputeEnvironments() && Objects.equals(this.computeEnvironments(), other.computeEnvironments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputeEnvironmentsResponse").add("ComputeEnvironments", this.hasComputeEnvironments() ? this.computeEnvironments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironments": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeComputeEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<ComputeEnvironmentDetail> computeEnvironments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeEnvironmentsResponse model) {
            super(model);
            this.computeEnvironments(model.computeEnvironments);
            this.nextToken(model.nextToken);
        }

        public final List<ComputeEnvironmentDetail.Builder> getComputeEnvironments() {
            List<ComputeEnvironmentDetail.Builder> result = ComputeEnvironmentDetailListCopier.copyToBuilder(this.computeEnvironments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder computeEnvironments(Collection<ComputeEnvironmentDetail> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copy(computeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(ComputeEnvironmentDetail ... computeEnvironments) {
            this.computeEnvironments(Arrays.asList(computeEnvironments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironments(Consumer<ComputeEnvironmentDetail.Builder> ... computeEnvironments) {
            this.computeEnvironments(Stream.of(computeEnvironments).map(c -> (ComputeEnvironmentDetail)((ComputeEnvironmentDetail.Builder)ComputeEnvironmentDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputeEnvironments(Collection<ComputeEnvironmentDetail.BuilderImpl> computeEnvironments) {
            this.computeEnvironments = ComputeEnvironmentDetailListCopier.copyFromBuilder(computeEnvironments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeComputeEnvironmentsResponse build() {
            return new DescribeComputeEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputeEnvironmentsResponse> {
        public Builder computeEnvironments(Collection<ComputeEnvironmentDetail> var1);

        public Builder computeEnvironments(ComputeEnvironmentDetail ... var1);

        public Builder computeEnvironments(Consumer<ComputeEnvironmentDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

