/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the attributes of a compute environment that can be updated. For more information, see <a
 * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the
 * <i>AWS Batch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeResourceUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeResourceUpdate.Builder, ComputeResourceUpdate> {
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minvCpus").getter(getter(ComputeResourceUpdate::minvCpus)).setter(setter(Builder::minvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()).build();

    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxvCpus").getter(getter(ComputeResourceUpdate::maxvCpus)).setter(setter(Builder::maxvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()).build();

    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredvCpus").getter(getter(ComputeResourceUpdate::desiredvCpus)).setter(setter(Builder::desiredvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(ComputeResourceUpdate::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(ComputeResourceUpdate::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINV_CPUS_FIELD,
            MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minvCpus;

    private final Integer maxvCpus;

    private final Integer desiredvCpus;

    private final List<String> subnets;

    private final List<String> securityGroupIds;

    private ComputeResourceUpdate(BuilderImpl builder) {
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
    }

    /**
     * <p>
     * The minimum number of Amazon EC2 vCPUs that an environment should maintain.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     * </p>
     * </note>
     * 
     * @return The minimum number of Amazon EC2 vCPUs that an environment should maintain.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     *         </p>
     */
    public final Integer minvCpus() {
        return minvCpus;
    }

    /**
     * <p>
     * The maximum number of Amazon EC2 vCPUs that an environment can reach.
     * </p>
     * <note>
     * <p>
     * With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies, AWS
     * Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS Batch
     * never exceeds <code>maxvCpus</code> by more than a single instance. That is, no more than a single instance from
     * among those specified in your compute environment.
     * </p>
     * </note>
     * 
     * @return The maximum number of Amazon EC2 vCPUs that an environment can reach.</p> <note>
     *         <p>
     *         With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation
     *         strategies, AWS Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In
     *         this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is, no
     *         more than a single instance from among those specified in your compute environment.
     *         </p>
     */
    public final Integer maxvCpus() {
        return maxvCpus;
    }

    /**
     * <p>
     * The desired number of Amazon EC2 vCPUS in the compute environment.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     * </p>
     * </note>
     * 
     * @return The desired number of Amazon EC2 vCPUS in the compute environment.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
     *         </p>
     */
    public final Integer desiredvCpus() {
        return desiredvCpus;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up to 16
     * subnets. Providing an empty list will be handled as if this parameter wasn't specified and no change is made.
     * This can't be specified for EC2 compute resources. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up to
     *         16 subnets. Providing an empty list will be handled as if this parameter wasn't specified and no change
     *         is made. This can't be specified for EC2 compute resources. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the
     *         <i>Amazon VPC User Guide</i>.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter is
     * required for Fargate compute resources, where it can contain up to 5 security groups. This can't be specified for
     * EC2 compute resources. Providing an empty list is handled as if this parameter wasn't specified and no change is
     * made.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon EC2 security groups associated with instances launched in the compute environment. This
     *         parameter is required for Fargate compute resources, where it can contain up to 5 security groups. This
     *         can't be specified for EC2 compute resources. Providing an empty list is handled as if this parameter
     *         wasn't specified and no change is made.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResourceUpdate)) {
            return false;
        }
        ComputeResourceUpdate other = (ComputeResourceUpdate) obj;
        return Objects.equals(minvCpus(), other.minvCpus()) && Objects.equals(maxvCpus(), other.maxvCpus())
                && Objects.equals(desiredvCpus(), other.desiredvCpus()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeResourceUpdate").add("MinvCpus", minvCpus()).add("MaxvCpus", maxvCpus())
                .add("DesiredvCpus", desiredvCpus()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minvCpus":
            return Optional.ofNullable(clazz.cast(minvCpus()));
        case "maxvCpus":
            return Optional.ofNullable(clazz.cast(maxvCpus()));
        case "desiredvCpus":
            return Optional.ofNullable(clazz.cast(desiredvCpus()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeResourceUpdate, T> g) {
        return obj -> g.apply((ComputeResourceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeResourceUpdate> {
        /**
         * <p>
         * The minimum number of Amazon EC2 vCPUs that an environment should maintain.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
         * </p>
         * </note>
         * 
         * @param minvCpus
         *        The minimum number of Amazon EC2 vCPUs that an environment should maintain.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minvCpus(Integer minvCpus);

        /**
         * <p>
         * The maximum number of Amazon EC2 vCPUs that an environment can reach.
         * </p>
         * <note>
         * <p>
         * With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies,
         * AWS Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, AWS
         * Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is, no more than a single
         * instance from among those specified in your compute environment.
         * </p>
         * </note>
         * 
         * @param maxvCpus
         *        The maximum number of Amazon EC2 vCPUs that an environment can reach.</p> <note>
         *        <p>
         *        With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation
         *        strategies, AWS Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements.
         *        In this event, AWS Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is,
         *        no more than a single instance from among those specified in your compute environment.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxvCpus(Integer maxvCpus);

        /**
         * <p>
         * The desired number of Amazon EC2 vCPUS in the compute environment.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
         * </p>
         * </note>
         * 
         * @param desiredvCpus
         *        The desired number of Amazon EC2 vCPUS in the compute environment.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredvCpus(Integer desiredvCpus);

        /**
         * <p>
         * The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up to 16
         * subnets. Providing an empty list will be handled as if this parameter wasn't specified and no change is made.
         * This can't be specified for EC2 compute resources. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the
         * <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param subnets
         *        The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up
         *        to 16 subnets. Providing an empty list will be handled as if this parameter wasn't specified and no
         *        change is made. This can't be specified for EC2 compute resources. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the
         *        <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up to 16
         * subnets. Providing an empty list will be handled as if this parameter wasn't specified and no change is made.
         * This can't be specified for EC2 compute resources. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the
         * <i>Amazon VPC User Guide</i>.
         * </p>
         * 
         * @param subnets
         *        The VPC subnets that the compute resources are launched into. Fargate compute resources can contain up
         *        to 16 subnets. Providing an empty list will be handled as if this parameter wasn't specified and no
         *        change is made. This can't be specified for EC2 compute resources. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and Subnets</a> in the
         *        <i>Amazon VPC User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter
         * is required for Fargate compute resources, where it can contain up to 5 security groups. This can't be
         * specified for EC2 compute resources. Providing an empty list is handled as if this parameter wasn't specified
         * and no change is made.
         * </p>
         * 
         * @param securityGroupIds
         *        The Amazon EC2 security groups associated with instances launched in the compute environment. This
         *        parameter is required for Fargate compute resources, where it can contain up to 5 security groups.
         *        This can't be specified for EC2 compute resources. Providing an empty list is handled as if this
         *        parameter wasn't specified and no change is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter
         * is required for Fargate compute resources, where it can contain up to 5 security groups. This can't be
         * specified for EC2 compute resources. Providing an empty list is handled as if this parameter wasn't specified
         * and no change is made.
         * </p>
         * 
         * @param securityGroupIds
         *        The Amazon EC2 security groups associated with instances launched in the compute environment. This
         *        parameter is required for Fargate compute resources, where it can contain up to 5 security groups.
         *        This can't be specified for EC2 compute resources. Providing an empty list is handled as if this
         *        parameter wasn't specified and no change is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private Integer minvCpus;

        private Integer maxvCpus;

        private Integer desiredvCpus;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResourceUpdate model) {
            minvCpus(model.minvCpus);
            maxvCpus(model.maxvCpus);
            desiredvCpus(model.desiredvCpus);
            subnets(model.subnets);
            securityGroupIds(model.securityGroupIds);
        }

        public final Integer getMinvCpus() {
            return minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        public final Integer getMaxvCpus() {
            return maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        public final Integer getDesiredvCpus() {
            return desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public ComputeResourceUpdate build() {
            return new ComputeResourceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
