/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a set of conditions to be met, and an action to take (<code>RETRY</code> or <code>EXIT</code>) if all
 * conditions are met.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateOnExit implements SdkPojo, Serializable, ToCopyableBuilder<EvaluateOnExit.Builder, EvaluateOnExit> {
    private static final SdkField<String> ON_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onStatusReason").getter(getter(EvaluateOnExit::onStatusReason)).setter(setter(Builder::onStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onStatusReason").build()).build();

    private static final SdkField<String> ON_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onReason").getter(getter(EvaluateOnExit::onReason)).setter(setter(Builder::onReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onReason").build()).build();

    private static final SdkField<String> ON_EXIT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("onExitCode").getter(getter(EvaluateOnExit::onExitCode)).setter(setter(Builder::onExitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onExitCode").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(EvaluateOnExit::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_STATUS_REASON_FIELD,
            ON_REASON_FIELD, ON_EXIT_CODE_FIELD, ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onStatusReason;

    private final String onReason;

    private final String onExitCode;

    private final String action;

    private EvaluateOnExit(BuilderImpl builder) {
        this.onStatusReason = builder.onStatusReason;
        this.onReason = builder.onReason;
        this.onExitCode = builder.onExitCode;
        this.action = builder.action;
    }

    /**
     * <p>
     * Contains a glob pattern to match against the <code>StatusReason</code> returned for a job. The pattern can be up
     * to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white space (including
     * spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an
     * exact match.
     * </p>
     * 
     * @return Contains a glob pattern to match against the <code>StatusReason</code> returned for a job. The pattern
     *         can be up to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white
     *         space (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of
     *         the string needs to be an exact match.
     */
    public final String onStatusReason() {
        return onStatusReason;
    }

    /**
     * <p>
     * Contains a glob pattern to match against the <code>Reason</code> returned for a job. The pattern can be up to 512
     * characters long, and can contain letters, numbers, periods (.), colons (:), and white space (including spaces and
     * tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact
     * match.
     * </p>
     * 
     * @return Contains a glob pattern to match against the <code>Reason</code> returned for a job. The pattern can be
     *         up to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white space
     *         (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the
     *         string needs to be an exact match.
     */
    public final String onReason() {
        return onReason;
    }

    /**
     * <p>
     * Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned for a
     * job. The pattern can be up to 512 characters long, can contain only numbers, and can optionally end with an
     * asterisk (*) so that only the start of the string needs to be an exact match.
     * </p>
     * 
     * @return Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned
     *         for a job. The pattern can be up to 512 characters long, can contain only numbers, and can optionally end
     *         with an asterisk (*) so that only the start of the string needs to be an exact match.
     */
    public final String onExitCode() {
        return onExitCode;
    }

    /**
     * <p>
     * Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
     * <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RetryAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
     *         <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
     * @see RetryAction
     */
    public final RetryAction action() {
        return RetryAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
     * <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RetryAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
     *         <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
     * @see RetryAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(onReason());
        hashCode = 31 * hashCode + Objects.hashCode(onExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateOnExit)) {
            return false;
        }
        EvaluateOnExit other = (EvaluateOnExit) obj;
        return Objects.equals(onStatusReason(), other.onStatusReason()) && Objects.equals(onReason(), other.onReason())
                && Objects.equals(onExitCode(), other.onExitCode()) && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateOnExit").add("OnStatusReason", onStatusReason()).add("OnReason", onReason())
                .add("OnExitCode", onExitCode()).add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "onStatusReason":
            return Optional.ofNullable(clazz.cast(onStatusReason()));
        case "onReason":
            return Optional.ofNullable(clazz.cast(onReason()));
        case "onExitCode":
            return Optional.ofNullable(clazz.cast(onExitCode()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateOnExit, T> g) {
        return obj -> g.apply((EvaluateOnExit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluateOnExit> {
        /**
         * <p>
         * Contains a glob pattern to match against the <code>StatusReason</code> returned for a job. The pattern can be
         * up to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white space
         * (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string
         * needs to be an exact match.
         * </p>
         * 
         * @param onStatusReason
         *        Contains a glob pattern to match against the <code>StatusReason</code> returned for a job. The pattern
         *        can be up to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white
         *        space (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of
         *        the string needs to be an exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onStatusReason(String onStatusReason);

        /**
         * <p>
         * Contains a glob pattern to match against the <code>Reason</code> returned for a job. The pattern can be up to
         * 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white space (including
         * spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be
         * an exact match.
         * </p>
         * 
         * @param onReason
         *        Contains a glob pattern to match against the <code>Reason</code> returned for a job. The pattern can
         *        be up to 512 characters long, and can contain letters, numbers, periods (.), colons (:), and white
         *        space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start
         *        of the string needs to be an exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onReason(String onReason);

        /**
         * <p>
         * Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned for
         * a job. The pattern can be up to 512 characters long, can contain only numbers, and can optionally end with an
         * asterisk (*) so that only the start of the string needs to be an exact match.
         * </p>
         * 
         * @param onExitCode
         *        Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code>
         *        returned for a job. The pattern can be up to 512 characters long, can contain only numbers, and can
         *        optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExitCode(String onExitCode);

        /**
         * <p>
         * Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
         * <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
         * </p>
         * 
         * @param action
         *        Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
         *        <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
         * @see RetryAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
         * <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
         * </p>
         * 
         * @param action
         *        Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>,
         *        <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren't case sensitive.
         * @see RetryAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetryAction
         */
        Builder action(RetryAction action);
    }

    static final class BuilderImpl implements Builder {
        private String onStatusReason;

        private String onReason;

        private String onExitCode;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateOnExit model) {
            onStatusReason(model.onStatusReason);
            onReason(model.onReason);
            onExitCode(model.onExitCode);
            action(model.action);
        }

        public final String getOnStatusReason() {
            return onStatusReason;
        }

        @Override
        public final Builder onStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
            return this;
        }

        public final void setOnStatusReason(String onStatusReason) {
            this.onStatusReason = onStatusReason;
        }

        public final String getOnReason() {
            return onReason;
        }

        @Override
        public final Builder onReason(String onReason) {
            this.onReason = onReason;
            return this;
        }

        public final void setOnReason(String onReason) {
            this.onReason = onReason;
        }

        public final String getOnExitCode() {
            return onExitCode;
        }

        @Override
        public final Builder onExitCode(String onExitCode) {
            this.onExitCode = onExitCode;
            return this;
        }

        public final void setOnExitCode(String onExitCode) {
            this.onExitCode = onExitCode;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RetryAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public EvaluateOnExit build() {
            return new EvaluateOnExit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
