/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the details of a multi-node parallel job node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeDetails implements SdkPojo, Serializable, ToCopyableBuilder<NodeDetails.Builder, NodeDetails> {
    private static final SdkField<Integer> NODE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nodeIndex").getter(getter(NodeDetails::nodeIndex)).setter(setter(Builder::nodeIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeIndex").build()).build();

    private static final SdkField<Boolean> IS_MAIN_NODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isMainNode").getter(getter(NodeDetails::isMainNode)).setter(setter(Builder::isMainNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMainNode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INDEX_FIELD,
            IS_MAIN_NODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer nodeIndex;

    private final Boolean isMainNode;

    private NodeDetails(BuilderImpl builder) {
        this.nodeIndex = builder.nodeIndex;
        this.isMainNode = builder.isMainNode;
    }

    /**
     * <p>
     * The node index for the node. Node index numbering begins at zero. This index is also available on the node with
     * the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
     * </p>
     * 
     * @return The node index for the node. Node index numbering begins at zero. This index is also available on the
     *         node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
     */
    public final Integer nodeIndex() {
        return nodeIndex;
    }

    /**
     * <p>
     * Specifies whether the current node is the main node for a multi-node parallel job.
     * </p>
     * 
     * @return Specifies whether the current node is the main node for a multi-node parallel job.
     */
    public final Boolean isMainNode() {
        return isMainNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeIndex());
        hashCode = 31 * hashCode + Objects.hashCode(isMainNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeDetails)) {
            return false;
        }
        NodeDetails other = (NodeDetails) obj;
        return Objects.equals(nodeIndex(), other.nodeIndex()) && Objects.equals(isMainNode(), other.isMainNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeDetails").add("NodeIndex", nodeIndex()).add("IsMainNode", isMainNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeIndex":
            return Optional.ofNullable(clazz.cast(nodeIndex()));
        case "isMainNode":
            return Optional.ofNullable(clazz.cast(isMainNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeDetails, T> g) {
        return obj -> g.apply((NodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeDetails> {
        /**
         * <p>
         * The node index for the node. Node index numbering begins at zero. This index is also available on the node
         * with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
         * </p>
         * 
         * @param nodeIndex
         *        The node index for the node. Node index numbering begins at zero. This index is also available on the
         *        node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIndex(Integer nodeIndex);

        /**
         * <p>
         * Specifies whether the current node is the main node for a multi-node parallel job.
         * </p>
         * 
         * @param isMainNode
         *        Specifies whether the current node is the main node for a multi-node parallel job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMainNode(Boolean isMainNode);
    }

    static final class BuilderImpl implements Builder {
        private Integer nodeIndex;

        private Boolean isMainNode;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeDetails model) {
            nodeIndex(model.nodeIndex);
            isMainNode(model.isMainNode);
        }

        public final Integer getNodeIndex() {
            return nodeIndex;
        }

        public final void setNodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        @Override
        @Transient
        public final Builder nodeIndex(Integer nodeIndex) {
            this.nodeIndex = nodeIndex;
            return this;
        }

        public final Boolean getIsMainNode() {
            return isMainNode;
        }

        public final void setIsMainNode(Boolean isMainNode) {
            this.isMainNode = isMainNode;
        }

        @Override
        @Transient
        public final Builder isMainNode(Boolean isMainNode) {
            this.isMainNode = isMainNode;
            return this;
        }

        @Override
        public NodeDetails build() {
            return new NodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
