/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>UpdateJobQueue</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateJobQueueRequest extends BatchRequest implements
        ToCopyableBuilder<UpdateJobQueueRequest.Builder, UpdateJobQueueRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(UpdateJobQueueRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdateJobQueueRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> SCHEDULING_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedulingPolicyArn").getter(getter(UpdateJobQueueRequest::schedulingPolicyArn))
            .setter(setter(Builder::schedulingPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingPolicyArn").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(UpdateJobQueueRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<List<ComputeEnvironmentOrder>> COMPUTE_ENVIRONMENT_ORDER_FIELD = SdkField
            .<List<ComputeEnvironmentOrder>> builder(MarshallingType.LIST)
            .memberName("computeEnvironmentOrder")
            .getter(getter(UpdateJobQueueRequest::computeEnvironmentOrder))
            .setter(setter(Builder::computeEnvironmentOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeEnvironmentOrder> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeEnvironmentOrder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD, STATE_FIELD,
            SCHEDULING_POLICY_ARN_FIELD, PRIORITY_FIELD, COMPUTE_ENVIRONMENT_ORDER_FIELD));

    private final String jobQueue;

    private final String state;

    private final String schedulingPolicyArn;

    private final Integer priority;

    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.schedulingPolicyArn = builder.schedulingPolicyArn;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    /**
     * <p>
     * The name or the Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The name or the Amazon Resource Name (ARN) of the job queue.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can accept
     * jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but jobs already in
     * the queue can finish.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can
     *         accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but
     *         jobs already in the queue can finish.
     * @see JQState
     */
    public final JQState state() {
        return JQState.fromValue(state);
    }

    /**
     * <p>
     * Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can accept
     * jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but jobs already in
     * the queue can finish.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JQState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can
     *         accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but
     *         jobs already in the queue can finish.
     * @see JQState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair share
     * scheduling policy can be replaced but not removed. The format is
     * <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For example,
     * <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair
     *         share scheduling policy can be replaced but not removed. The format is
     *         <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For
     *         example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.
     */
    public final String schedulingPolicyArn() {
        return schedulingPolicyArn;
    }

    /**
     * <p>
     * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     * <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority
     * is determined in descending order, for example, a job queue with a priority value of <code>10</code> is given
     * scheduling preference over a job queue with a priority value of <code>1</code>. All of the compute environments
     * must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or
     * <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
     * </p>
     * 
     * @return The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
     *         <code>priority</code> parameter) are evaluated first when associated with the same compute environment.
     *         Priority is determined in descending order, for example, a job queue with a priority value of
     *         <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>.
     *         All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (
     *         <code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeEnvironmentOrder property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputeEnvironmentOrder() {
        return computeEnvironmentOrder != null && !(computeEnvironmentOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details the set of compute environments mapped to a job queue and their order relative to each other. This is one
     * of the parameters used by the job scheduler to determine which compute environment should run a given job.
     * Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. All
     * of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (
     * <code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
     * </p>
     * <note>
     * <p>
     * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't
     * support mixing compute environment architecture types in a single job queue.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeEnvironmentOrder} method.
     * </p>
     * 
     * @return Details the set of compute environments mapped to a job queue and their order relative to each other.
     *         This is one of the parameters used by the job scheduler to determine which compute environment should run
     *         a given job. Compute environments must be in the <code>VALID</code> state before you can associate them
     *         with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or
     *         <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate
     *         compute environments can't be mixed.</p> <note>
     *         <p>
     *         All compute environments that are associated with a job queue must share the same architecture. Batch
     *         doesn't support mixing compute environment architecture types in a single job queue.
     *         </p>
     */
    public final List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return computeEnvironmentOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeEnvironmentOrder() ? computeEnvironmentOrder() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(schedulingPolicyArn(), other.schedulingPolicyArn())
                && Objects.equals(priority(), other.priority())
                && hasComputeEnvironmentOrder() == other.hasComputeEnvironmentOrder()
                && Objects.equals(computeEnvironmentOrder(), other.computeEnvironmentOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateJobQueueRequest").add("JobQueue", jobQueue()).add("State", stateAsString())
                .add("SchedulingPolicyArn", schedulingPolicyArn()).add("Priority", priority())
                .add("ComputeEnvironmentOrder", hasComputeEnvironmentOrder() ? computeEnvironmentOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "schedulingPolicyArn":
            return Optional.ofNullable(clazz.cast(schedulingPolicyArn()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "computeEnvironmentOrder":
            return Optional.ofNullable(clazz.cast(computeEnvironmentOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobQueueRequest, T> g) {
        return obj -> g.apply((UpdateJobQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateJobQueueRequest> {
        /**
         * <p>
         * The name or the Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueue
         *        The name or the Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can
         * accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but jobs
         * already in the queue can finish.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it
         *        can accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the
         *        queue, but jobs already in the queue can finish.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(String state);

        /**
         * <p>
         * Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can
         * accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the queue, but jobs
         * already in the queue can finish.
         * </p>
         * 
         * @param state
         *        Describes the queue's ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it
         *        can accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can't be added to the
         *        queue, but jobs already in the queue can finish.
         * @see JQState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JQState
         */
        Builder state(JQState state);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair share
         * scheduling policy can be replaced but not removed. The format is
         * <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For
         * example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.
         * </p>
         * 
         * @param schedulingPolicyArn
         *        Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair
         *        share scheduling policy can be replaced but not removed. The format is
         *        <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>.
         *        For example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulingPolicyArn(String schedulingPolicyArn);

        /**
         * <p>
         * The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         * <code>priority</code> parameter) are evaluated first when associated with the same compute environment.
         * Priority is determined in descending order, for example, a job queue with a priority value of <code>10</code>
         * is given scheduling preference over a job queue with a priority value of <code>1</code>. All of the compute
         * environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or
         * <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
         * </p>
         * 
         * @param priority
         *        The priority of the job queue. Job queues with a higher priority (or a higher integer value for the
         *        <code>priority</code> parameter) are evaluated first when associated with the same compute
         *        environment. Priority is determined in descending order, for example, a job queue with a priority
         *        value of <code>10</code> is given scheduling preference over a job queue with a priority value of
         *        <code>1</code>. All of the compute environments must be either EC2 (<code>EC2</code> or
         *        <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate
         *        compute environments can't be mixed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should run a given
         * job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job
         * queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate
         * (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
         * </p>
         * <note>
         * <p>
         * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't
         * support mixing compute environment architecture types in a single job queue.
         * </p>
         * </note>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        run a given job. Compute environments must be in the <code>VALID</code> state before you can associate
         *        them with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or
         *        <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate
         *        compute environments can't be mixed.</p> <note>
         *        <p>
         *        All compute environments that are associated with a job queue must share the same architecture. Batch
         *        doesn't support mixing compute environment architecture types in a single job queue.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should run a given
         * job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job
         * queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate
         * (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
         * </p>
         * <note>
         * <p>
         * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't
         * support mixing compute environment architecture types in a single job queue.
         * </p>
         * </note>
         * 
         * @param computeEnvironmentOrder
         *        Details the set of compute environments mapped to a job queue and their order relative to each other.
         *        This is one of the parameters used by the job scheduler to determine which compute environment should
         *        run a given job. Compute environments must be in the <code>VALID</code> state before you can associate
         *        them with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or
         *        <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate
         *        compute environments can't be mixed.</p> <note>
         *        <p>
         *        All compute environments that are associated with a job queue must share the same architecture. Batch
         *        doesn't support mixing compute environment architecture types in a single job queue.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder);

        /**
         * <p>
         * Details the set of compute environments mapped to a job queue and their order relative to each other. This is
         * one of the parameters used by the job scheduler to determine which compute environment should run a given
         * job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job
         * queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate
         * (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can't be mixed.
         * </p>
         * <note>
         * <p>
         * All compute environments that are associated with a job queue must share the same architecture. Batch doesn't
         * support mixing compute environment architecture types in a single job queue.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<ComputeEnvironmentOrder>.Builder}
         * avoiding the need to create one manually via {@link List<ComputeEnvironmentOrder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComputeEnvironmentOrder>.Builder#build()} is called
         * immediately and its result is passed to {@link #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)}.
         * 
         * @param computeEnvironmentOrder
         *        a consumer that will call methods on {@link List<ComputeEnvironmentOrder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeEnvironmentOrder(List<ComputeEnvironmentOrder>)
         */
        Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String state;

        private String schedulingPolicyArn;

        private Integer priority;

        private List<ComputeEnvironmentOrder> computeEnvironmentOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            state(model.state);
            schedulingPolicyArn(model.schedulingPolicyArn);
            priority(model.priority);
            computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        @Transient
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(JQState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getSchedulingPolicyArn() {
            return schedulingPolicyArn;
        }

        public final void setSchedulingPolicyArn(String schedulingPolicyArn) {
            this.schedulingPolicyArn = schedulingPolicyArn;
        }

        @Override
        @Transient
        public final Builder schedulingPolicyArn(String schedulingPolicyArn) {
            this.schedulingPolicyArn = schedulingPolicyArn;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        @Transient
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final List<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            List<ComputeEnvironmentOrder.Builder> result = ComputeEnvironmentOrdersCopier
                    .copyToBuilder(this.computeEnvironmentOrder);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        @Override
        @Transient
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder... computeEnvironmentOrder) {
            computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder computeEnvironmentOrder(Consumer<ComputeEnvironmentOrder.Builder>... computeEnvironmentOrder) {
            computeEnvironmentOrder(Stream.of(computeEnvironmentOrder)
                    .map(c -> ComputeEnvironmentOrder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
