/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.services.batch.model.JobDetail;
import software.amazon.awssdk.services.batch.model.JobDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobsResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, DescribeJobsResponse> {
    private static final SdkField<List<JobDetail>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobs").getter(DescribeJobsResponse.getter(DescribeJobsResponse::jobs)).setter(DescribeJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));
    private final List<JobDetail> jobs;

    private DescribeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<JobDetail> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsResponse)) {
            return false;
        }
        DescribeJobsResponse other = (DescribeJobsResponse)((Object)obj);
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobsResponse").add("Jobs", this.hasJobs() ? this.jobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobsResponse, T> g) {
        return obj -> g.apply((DescribeJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private List<JobDetail> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsResponse model) {
            super(model);
            this.jobs(model.jobs);
        }

        public final List<JobDetail.Builder> getJobs() {
            List<JobDetail.Builder> result = JobDetailListCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<JobDetail.BuilderImpl> jobs) {
            this.jobs = JobDetailListCopier.copyFromBuilder(jobs);
        }

        @Override
        @Transient
        public final Builder jobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobs(JobDetail ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobs(Consumer<JobDetail.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (JobDetail)((JobDetail.Builder)JobDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeJobsResponse build() {
            return new DescribeJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeJobsResponse> {
        public Builder jobs(Collection<JobDetail> var1);

        public Builder jobs(JobDetail ... var1);

        public Builder jobs(Consumer<JobDetail.Builder> ... var1);
    }
}

