/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>SubmitJob</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitJobRequest extends BatchRequest implements ToCopyableBuilder<SubmitJobRequest.Builder, SubmitJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(SubmitJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(SubmitJobRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<ArrayProperties> ARRAY_PROPERTIES_FIELD = SdkField
            .<ArrayProperties> builder(MarshallingType.SDK_POJO).memberName("arrayProperties")
            .getter(getter(SubmitJobRequest::arrayProperties)).setter(setter(Builder::arrayProperties))
            .constructor(ArrayProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()).build();

    private static final SdkField<List<JobDependency>> DEPENDS_ON_FIELD = SdkField
            .<List<JobDependency>> builder(MarshallingType.LIST)
            .memberName("dependsOn")
            .getter(getter(SubmitJobRequest::dependsOn))
            .setter(setter(Builder::dependsOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobDependency> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobDependency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinition").getter(getter(SubmitJobRequest::jobDefinition)).setter(setter(Builder::jobDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(SubmitJobRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField
            .<ContainerOverrides> builder(MarshallingType.SDK_POJO).memberName("containerOverrides")
            .getter(getter(SubmitJobRequest::containerOverrides)).setter(setter(Builder::containerOverrides))
            .constructor(ContainerOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build())
            .build();

    private static final SdkField<NodeOverrides> NODE_OVERRIDES_FIELD = SdkField
            .<NodeOverrides> builder(MarshallingType.SDK_POJO).memberName("nodeOverrides")
            .getter(getter(SubmitJobRequest::nodeOverrides)).setter(setter(Builder::nodeOverrides))
            .constructor(NodeOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOverrides").build()).build();

    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField
            .<RetryStrategy> builder(MarshallingType.SDK_POJO).memberName("retryStrategy")
            .getter(getter(SubmitJobRequest::retryStrategy)).setter(setter(Builder::retryStrategy))
            .constructor(RetryStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()).build();

    private static final SdkField<Boolean> PROPAGATE_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("propagateTags").getter(getter(SubmitJobRequest::propagateTags)).setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.<JobTimeout> builder(MarshallingType.SDK_POJO)
            .memberName("timeout").getter(getter(SubmitJobRequest::timeout)).setter(setter(Builder::timeout))
            .constructor(JobTimeout::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SubmitJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_QUEUE_FIELD, ARRAY_PROPERTIES_FIELD, DEPENDS_ON_FIELD, JOB_DEFINITION_FIELD, PARAMETERS_FIELD,
            CONTAINER_OVERRIDES_FIELD, NODE_OVERRIDES_FIELD, RETRY_STRATEGY_FIELD, PROPAGATE_TAGS_FIELD, TIMEOUT_FIELD,
            TAGS_FIELD));

    private final String jobName;

    private final String jobQueue;

    private final ArrayProperties arrayProperties;

    private final List<JobDependency> dependsOn;

    private final String jobDefinition;

    private final Map<String, String> parameters;

    private final ContainerOverrides containerOverrides;

    private final NodeOverrides nodeOverrides;

    private final RetryStrategy retryStrategy;

    private final Boolean propagateTags;

    private final JobTimeout timeout;

    private final Map<String, String> tags;

    private SubmitJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.arrayProperties = builder.arrayProperties;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.nodeOverrides = builder.nodeOverrides;
        this.retryStrategy = builder.retryStrategy;
        this.propagateTags = builder.propagateTags;
        this.timeout = builder.timeout;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
     *         lowercase), numbers, hyphens, and underscores are allowed.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN) of
     * the queue.
     * </p>
     * 
     * @return The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name
     *         (ARN) of the queue.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The array properties for the submitted job, such as the size of the array. The array size can be between 2 and
     * 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>Batch User
     * Guide</i>.
     * </p>
     * 
     * @return The array properties for the submitted job, such as the size of the array. The array size can be between
     *         2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information,
     *         see <a href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the
     *         <i>Batch User Guide</i>.
     */
    public final ArrayProperties arrayProperties() {
        return arrayProperties;
    }

    /**
     * Returns true if the DependsOn property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDependsOn() {
        return dependsOn != null && !(dependsOn instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job
     * completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a
     * job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of
     * each dependency to complete before it can begin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDependsOn()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
     *         <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
     *         array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type
     *         dependency with a job ID for array jobs. In that case, each index child of this job must wait for the
     *         corresponding index child of each dependency to complete before it can begin.
     */
    public final List<JobDependency> dependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>, or
     * the Amazon Resource Name (ARN) for the job definition. If <code>name</code> is specified without a revision then
     * the latest active revision is used.
     * </p>
     * 
     * @return The job definition used by this job. This value can be one of <code>name</code>,
     *         <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If
     *         <code>name</code> is specified without a revision then the latest active revision is used.
     */
    public final String jobDefinition() {
        return jobDefinition;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job
     * definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code>
     * request override any corresponding parameter defaults from the job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional parameters passed to the job that replace parameter substitution placeholders that are set in
     *         the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
     *         <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * <p>
     * A list of container overrides in the JSON format that specify the name of a container in the specified job
     * definition and the overrides it should receive. You can override the default command for a container, which is
     * specified in the job definition or the Docker image, with a <code>command</code> override. You can also override
     * existing environment variables on a container or add new environment variables to it with an
     * <code>environment</code> override.
     * </p>
     * 
     * @return A list of container overrides in the JSON format that specify the name of a container in the specified
     *         job definition and the overrides it should receive. You can override the default command for a container,
     *         which is specified in the job definition or the Docker image, with a <code>command</code> override. You
     *         can also override existing environment variables on a container or add new environment variables to it
     *         with an <code>environment</code> override.
     */
    public final ContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * A list of node overrides in JSON format that specify the node range to target and the container overrides for
     * that node range.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources; use
     * <code>containerOverrides</code> instead.
     * </p>
     * </note>
     * 
     * @return A list of node overrides in JSON format that specify the node range to target and the container overrides
     *         for that node range.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources; use
     *         <code>containerOverrides</code> instead.
     *         </p>
     */
    public final NodeOverrides nodeOverrides() {
        return nodeOverrides;
    }

    /**
     * <p>
     * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     * specified here, it overrides the retry strategy defined in the job definition.
     * </p>
     * 
     * @return The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
     *         specified here, it overrides the retry strategy defined in the job definition.
     */
    public final RetryStrategy retryStrategy() {
        return retryStrategy;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks during task creation.
     * For tags with the same name, job tags are given priority over job definitions tags. If the total number of
     * combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state. When
     * specified, this overrides the tag propagation setting in the job definition.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
     *         task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks
     *         during task creation. For tags with the same name, job tags are given priority over job definitions tags.
     *         If the total number of combined tags from the job and job definition is over 50, the job is moved to the
     *         <code>FAILED</code> state. When specified, this overrides the tag propagation setting in the job
     *         definition.
     */
    public final Boolean propagateTags() {
        return propagateTags;
    }

    /**
     * <p>
     * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which
     * Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't retried.
     * The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified
     * in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job
     * Timeouts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after
     *         which Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it
     *         isn't retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout
     *         configuration specified in the job definition. For array jobs, child jobs have the same timeout
     *         configuration as the parent job. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in
     *         the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final JobTimeout timeout() {
        return timeout;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the job request to help you categorize and organize your resources. Each tag consists
     * of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>
     * in <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags that you apply to the job request to help you categorize and organize your resources. Each tag
     *         consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> in <i>Amazon Web Services General Reference</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependsOn() ? dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobQueue(), other.jobQueue())
                && Objects.equals(arrayProperties(), other.arrayProperties()) && hasDependsOn() == other.hasDependsOn()
                && Objects.equals(dependsOn(), other.dependsOn()) && Objects.equals(jobDefinition(), other.jobDefinition())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(containerOverrides(), other.containerOverrides())
                && Objects.equals(nodeOverrides(), other.nodeOverrides())
                && Objects.equals(retryStrategy(), other.retryStrategy())
                && Objects.equals(propagateTags(), other.propagateTags()) && Objects.equals(timeout(), other.timeout())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitJobRequest").add("JobName", jobName()).add("JobQueue", jobQueue())
                .add("ArrayProperties", arrayProperties()).add("DependsOn", hasDependsOn() ? dependsOn() : null)
                .add("JobDefinition", jobDefinition()).add("Parameters", hasParameters() ? parameters() : null)
                .add("ContainerOverrides", containerOverrides()).add("NodeOverrides", nodeOverrides())
                .add("RetryStrategy", retryStrategy()).add("PropagateTags", propagateTags()).add("Timeout", timeout())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "arrayProperties":
            return Optional.ofNullable(clazz.cast(arrayProperties()));
        case "dependsOn":
            return Optional.ofNullable(clazz.cast(dependsOn()));
        case "jobDefinition":
            return Optional.ofNullable(clazz.cast(jobDefinition()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "containerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        case "nodeOverrides":
            return Optional.ofNullable(clazz.cast(nodeOverrides()));
        case "retryStrategy":
            return Optional.ofNullable(clazz.cast(retryStrategy()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTags()));
        case "timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitJobRequest, T> g) {
        return obj -> g.apply((SubmitJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitJobRequest> {
        /**
         * <p>
         * The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         * lowercase), numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param jobName
         *        The name of the job. The first character must be alphanumeric, and up to 128 letters (uppercase and
         *        lowercase), numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN)
         * of the queue.
         * </p>
         * 
         * @param jobQueue
         *        The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name
         *        (ARN) of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>Batch User
         * Guide</i>.
         * </p>
         * 
         * @param arrayProperties
         *        The array properties for the submitted job, such as the size of the array. The array size can be
         *        between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more
         *        information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array
         *        Jobs</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayProperties(ArrayProperties arrayProperties);

        /**
         * <p>
         * The array properties for the submitted job, such as the size of the array. The array size can be between 2
         * and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>Batch User
         * Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ArrayProperties.Builder} avoiding the need to
         * create one manually via {@link ArrayProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArrayProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #arrayProperties(ArrayProperties)}.
         * 
         * @param arrayProperties
         *        a consumer that will call methods on {@link ArrayProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayProperties(ArrayProperties)
         */
        default Builder arrayProperties(Consumer<ArrayProperties.Builder> arrayProperties) {
            return arrayProperties(ArrayProperties.builder().applyMutation(arrayProperties).build());
        }

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(Collection<JobDependency> dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * 
         * @param dependsOn
         *        A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         *        <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child
         *        array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code>
         *        type dependency with a job ID for array jobs. In that case, each index child of this job must wait for
         *        the corresponding index child of each dependency to complete before it can begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependsOn(JobDependency... dependsOn);

        /**
         * <p>
         * A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a
         * <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array
         * job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency
         * with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding
         * index child of each dependency to complete before it can begin.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobDependency>.Builder} avoiding the need
         * to create one manually via {@link List<JobDependency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobDependency>.Builder#build()} is called immediately and
         * its result is passed to {@link #dependsOn(List<JobDependency>)}.
         * 
         * @param dependsOn
         *        a consumer that will call methods on {@link List<JobDependency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dependsOn(List<JobDependency>)
         */
        Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn);

        /**
         * <p>
         * The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>,
         * or the Amazon Resource Name (ARN) for the job definition. If <code>name</code> is specified without a
         * revision then the latest active revision is used.
         * </p>
         * 
         * @param jobDefinition
         *        The job definition used by this job. This value can be one of <code>name</code>,
         *        <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If
         *        <code>name</code> is specified without a revision then the latest active revision is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinition(String jobDefinition);

        /**
         * <p>
         * Additional parameters passed to the job that replace parameter substitution placeholders that are set in the
         * job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         * <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * </p>
         * 
         * @param parameters
         *        Additional parameters passed to the job that replace parameter substitution placeholders that are set
         *        in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a
         *        <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * A list of container overrides in the JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container, which
         * is specified in the job definition or the Docker image, with a <code>command</code> override. You can also
         * override existing environment variables on a container or add new environment variables to it with an
         * <code>environment</code> override.
         * </p>
         * 
         * @param containerOverrides
         *        A list of container overrides in the JSON format that specify the name of a container in the specified
         *        job definition and the overrides it should receive. You can override the default command for a
         *        container, which is specified in the job definition or the Docker image, with a <code>command</code>
         *        override. You can also override existing environment variables on a container or add new environment
         *        variables to it with an <code>environment</code> override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverrides containerOverrides);

        /**
         * <p>
         * A list of container overrides in the JSON format that specify the name of a container in the specified job
         * definition and the overrides it should receive. You can override the default command for a container, which
         * is specified in the job definition or the Docker image, with a <code>command</code> override. You can also
         * override existing environment variables on a container or add new environment variables to it with an
         * <code>environment</code> override.
         * </p>
         * This is a convenience that creates an instance of the {@link ContainerOverrides.Builder} avoiding the need to
         * create one manually via {@link ContainerOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #containerOverrides(ContainerOverrides)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link ContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(ContainerOverrides)
         */
        default Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return containerOverrides(ContainerOverrides.builder().applyMutation(containerOverrides).build());
        }

        /**
         * <p>
         * A list of node overrides in JSON format that specify the node range to target and the container overrides for
         * that node range.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources; use
         * <code>containerOverrides</code> instead.
         * </p>
         * </note>
         * 
         * @param nodeOverrides
         *        A list of node overrides in JSON format that specify the node range to target and the container
         *        overrides for that node range.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources; use
         *        <code>containerOverrides</code> instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOverrides(NodeOverrides nodeOverrides);

        /**
         * <p>
         * A list of node overrides in JSON format that specify the node range to target and the container overrides for
         * that node range.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources; use
         * <code>containerOverrides</code> instead.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link NodeOverrides.Builder} avoiding the need
         * to create one manually via {@link NodeOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeOverrides(NodeOverrides)}.
         * 
         * @param nodeOverrides
         *        a consumer that will call methods on {@link NodeOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeOverrides(NodeOverrides)
         */
        default Builder nodeOverrides(Consumer<NodeOverrides.Builder> nodeOverrides) {
            return nodeOverrides(NodeOverrides.builder().applyMutation(nodeOverrides).build());
        }

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * 
         * @param retryStrategy
         *        The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy
         *        is specified here, it overrides the retry strategy defined in the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStrategy(RetryStrategy retryStrategy);

        /**
         * <p>
         * The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is
         * specified here, it overrides the retry strategy defined in the job definition.
         * </p>
         * This is a convenience that creates an instance of the {@link RetryStrategy.Builder} avoiding the need to
         * create one manually via {@link RetryStrategy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetryStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStrategy(RetryStrategy)}.
         * 
         * @param retryStrategy
         *        a consumer that will call methods on {@link RetryStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStrategy(RetryStrategy)
         */
        default Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return retryStrategy(RetryStrategy.builder().applyMutation(retryStrategy).build());
        }

        /**
         * <p>
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks during task
         * creation. For tags with the same name, job tags are given priority over job definitions tags. If the total
         * number of combined tags from the job and job definition is over 50, the job is moved to the
         * <code>FAILED</code> state. When specified, this overrides the tag propagation setting in the job definition.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
         *        task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks
         *        during task creation. For tags with the same name, job tags are given priority over job definitions
         *        tags. If the total number of combined tags from the job and job definition is over 50, the job is
         *        moved to the <code>FAILED</code> state. When specified, this overrides the tag propagation setting in
         *        the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagateTags(Boolean propagateTags);

        /**
         * <p>
         * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which
         * Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't
         * retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout
         * configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration
         * as the parent job. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param timeout
         *        The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration
         *        after which Batch terminates your jobs if they haven't finished. If a job is terminated due to a
         *        timeout, it isn't retried. The minimum value for the timeout is 60 seconds. This configuration
         *        overrides any timeout configuration specified in the job definition. For array jobs, child jobs have
         *        the same timeout configuration as the parent job. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a>
         *        in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(JobTimeout timeout);

        /**
         * <p>
         * The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which
         * Batch terminates your jobs if they haven't finished. If a job is terminated due to a timeout, it isn't
         * retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout
         * configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration
         * as the parent job. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the
         * <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link JobTimeout.Builder} avoiding the need to create
         * one manually via {@link JobTimeout#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimeout.Builder#build()} is called immediately and its result
         * is passed to {@link #timeout(JobTimeout)}.
         * 
         * @param timeout
         *        a consumer that will call methods on {@link JobTimeout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeout(JobTimeout)
         */
        default Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return timeout(JobTimeout.builder().applyMutation(timeout).build());
        }

        /**
         * <p>
         * The tags that you apply to the job request to help you categorize and organize your resources. Each tag
         * consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> in <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the job request to help you categorize and organize your resources. Each
         *        tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> in <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobQueue;

        private ArrayProperties arrayProperties;

        private List<JobDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();

        private String jobDefinition;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private ContainerOverrides containerOverrides;

        private NodeOverrides nodeOverrides;

        private RetryStrategy retryStrategy;

        private Boolean propagateTags;

        private JobTimeout timeout;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobQueue(model.jobQueue);
            arrayProperties(model.arrayProperties);
            dependsOn(model.dependsOn);
            jobDefinition(model.jobDefinition);
            parameters(model.parameters);
            containerOverrides(model.containerOverrides);
            nodeOverrides(model.nodeOverrides);
            retryStrategy(model.retryStrategy);
            propagateTags(model.propagateTags);
            timeout(model.timeout);
            tags(model.tags);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        @Transient
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final ArrayProperties.Builder getArrayProperties() {
            return arrayProperties != null ? arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(ArrayProperties.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder arrayProperties(ArrayProperties arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final List<JobDependency.Builder> getDependsOn() {
            List<JobDependency.Builder> result = JobDependencyListCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        @Override
        @Transient
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dependsOn(JobDependency... dependsOn) {
            dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder>... dependsOn) {
            dependsOn(Stream.of(dependsOn).map(c -> JobDependency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getJobDefinition() {
            return jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        @Transient
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        @Transient
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final NodeOverrides.Builder getNodeOverrides() {
            return nodeOverrides != null ? nodeOverrides.toBuilder() : null;
        }

        public final void setNodeOverrides(NodeOverrides.BuilderImpl nodeOverrides) {
            this.nodeOverrides = nodeOverrides != null ? nodeOverrides.build() : null;
        }

        @Override
        @Transient
        public final Builder nodeOverrides(NodeOverrides nodeOverrides) {
            this.nodeOverrides = nodeOverrides;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return retryStrategy != null ? retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        @Transient
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Boolean getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        @Transient
        public final Builder propagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final JobTimeout.Builder getTimeout() {
            return timeout != null ? timeout.toBuilder() : null;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        @Transient
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
