/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.ComputeResourceUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateComputeEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeEnvironment").getter(UpdateComputeEnvironmentRequest.getter(UpdateComputeEnvironmentRequest::computeEnvironment)).setter(UpdateComputeEnvironmentRequest.setter(Builder::computeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironment").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(UpdateComputeEnvironmentRequest.getter(UpdateComputeEnvironmentRequest::stateAsString)).setter(UpdateComputeEnvironmentRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Integer> UNMANAGEDV_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("unmanagedvCpus").getter(UpdateComputeEnvironmentRequest.getter(UpdateComputeEnvironmentRequest::unmanagedvCpus)).setter(UpdateComputeEnvironmentRequest.setter(Builder::unmanagedvCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmanagedvCpus").build()}).build();
    private static final SdkField<ComputeResourceUpdate> COMPUTE_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeResources").getter(UpdateComputeEnvironmentRequest.getter(UpdateComputeEnvironmentRequest::computeResources)).setter(UpdateComputeEnvironmentRequest.setter(Builder::computeResources)).constructor(ComputeResourceUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(UpdateComputeEnvironmentRequest.getter(UpdateComputeEnvironmentRequest::serviceRole)).setter(UpdateComputeEnvironmentRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENT_FIELD, STATE_FIELD, UNMANAGEDV_CPUS_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD));
    private final String computeEnvironment;
    private final String state;
    private final Integer unmanagedvCpus;
    private final ComputeResourceUpdate computeResources;
    private final String serviceRole;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.unmanagedvCpus = builder.unmanagedvCpus;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public final String computeEnvironment() {
        return this.computeEnvironment;
    }

    public final CEState state() {
        return CEState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer unmanagedvCpus() {
        return this.unmanagedvCpus;
    }

    public final ComputeResourceUpdate computeResources() {
        return this.computeResources;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unmanagedvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest)((Object)obj);
        return Objects.equals(this.computeEnvironment(), other.computeEnvironment()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.unmanagedvCpus(), other.unmanagedvCpus()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateComputeEnvironmentRequest").add("ComputeEnvironment", (Object)this.computeEnvironment()).add("State", (Object)this.stateAsString()).add("UnmanagedvCpus", (Object)this.unmanagedvCpus()).add("ComputeResources", (Object)this.computeResources()).add("ServiceRole", (Object)this.serviceRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.computeEnvironment()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "unmanagedvCpus": {
                return Optional.ofNullable(clazz.cast(this.unmanagedvCpus()));
            }
            case "computeResources": {
                return Optional.ofNullable(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateComputeEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String computeEnvironment;
        private String state;
        private Integer unmanagedvCpus;
        private ComputeResourceUpdate computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            super(model);
            this.computeEnvironment(model.computeEnvironment);
            this.state(model.state);
            this.unmanagedvCpus(model.unmanagedvCpus);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        @Transient
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(CEState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        public final void setUnmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
        }

        @Override
        @Transient
        public final Builder unmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        @Override
        @Transient
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        @Transient
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        public Builder computeEnvironment(String var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder unmanagedvCpus(Integer var1);

        public Builder computeResources(ComputeResourceUpdate var1);

        default public Builder computeResources(Consumer<ComputeResourceUpdate.Builder> computeResources) {
            return this.computeResources((ComputeResourceUpdate)((ComputeResourceUpdate.Builder)ComputeResourceUpdate.builder().applyMutation(computeResources)).build());
        }

        public Builder serviceRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

