/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object representing any node overrides to a job definition that's used in a <a>SubmitJob</a> API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodePropertyOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<NodePropertyOverride.Builder, NodePropertyOverride> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetNodes").getter(getter(NodePropertyOverride::targetNodes)).setter(setter(Builder::targetNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()).build();

    private static final SdkField<ContainerOverrides> CONTAINER_OVERRIDES_FIELD = SdkField
            .<ContainerOverrides> builder(MarshallingType.SDK_POJO).memberName("containerOverrides")
            .getter(getter(NodePropertyOverride::containerOverrides)).setter(setter(Builder::containerOverrides))
            .constructor(ContainerOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD,
            CONTAINER_OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetNodes;

    private final ContainerOverrides containerOverrides;

    private NodePropertyOverride(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.containerOverrides = builder.containerOverrides;
    }

    /**
     * <p>
     * The range of nodes, using node index values, that's used to override. A range of <code>0:3</code> indicates nodes
     * with index values of <code>0</code> through <code>3</code>. If the starting range value is omitted (
     * <code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted (
     * <code>n:</code>), then the highest possible node index is used to end the range.
     * </p>
     * 
     * @return The range of nodes, using node index values, that's used to override. A range of <code>0:3</code>
     *         indicates nodes with index values of <code>0</code> through <code>3</code>. If the starting range value
     *         is omitted (<code>:n</code>), then <code>0</code> is used to start the range. If the ending range value
     *         is omitted (<code>n:</code>), then the highest possible node index is used to end the range.
     */
    public final String targetNodes() {
        return targetNodes;
    }

    /**
     * <p>
     * The overrides that should be sent to a node range.
     * </p>
     * 
     * @return The overrides that should be sent to a node range.
     */
    public final ContainerOverrides containerOverrides() {
        return containerOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(containerOverrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodePropertyOverride)) {
            return false;
        }
        NodePropertyOverride other = (NodePropertyOverride) obj;
        return Objects.equals(targetNodes(), other.targetNodes())
                && Objects.equals(containerOverrides(), other.containerOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodePropertyOverride").add("TargetNodes", targetNodes())
                .add("ContainerOverrides", containerOverrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetNodes":
            return Optional.ofNullable(clazz.cast(targetNodes()));
        case "containerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodePropertyOverride, T> g) {
        return obj -> g.apply((NodePropertyOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodePropertyOverride> {
        /**
         * <p>
         * The range of nodes, using node index values, that's used to override. A range of <code>0:3</code> indicates
         * nodes with index values of <code>0</code> through <code>3</code>. If the starting range value is omitted (
         * <code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted (
         * <code>n:</code>), then the highest possible node index is used to end the range.
         * </p>
         * 
         * @param targetNodes
         *        The range of nodes, using node index values, that's used to override. A range of <code>0:3</code>
         *        indicates nodes with index values of <code>0</code> through <code>3</code>. If the starting range
         *        value is omitted (<code>:n</code>), then <code>0</code> is used to start the range. If the ending
         *        range value is omitted (<code>n:</code>), then the highest possible node index is used to end the
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNodes(String targetNodes);

        /**
         * <p>
         * The overrides that should be sent to a node range.
         * </p>
         * 
         * @param containerOverrides
         *        The overrides that should be sent to a node range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverrides containerOverrides);

        /**
         * <p>
         * The overrides that should be sent to a node range.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerOverrides.Builder} avoiding the
         * need to create one manually via {@link ContainerOverrides#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerOverrides.Builder#build()} is called immediately and its
         * result is passed to {@link #containerOverrides(ContainerOverrides)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link ContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(ContainerOverrides)
         */
        default Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return containerOverrides(ContainerOverrides.builder().applyMutation(containerOverrides).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetNodes;

        private ContainerOverrides containerOverrides;

        private BuilderImpl() {
        }

        private BuilderImpl(NodePropertyOverride model) {
            targetNodes(model.targetNodes);
            containerOverrides(model.containerOverrides);
        }

        public final String getTargetNodes() {
            return targetNodes;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        @Override
        @Transient
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return containerOverrides != null ? containerOverrides.toBuilder() : null;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        @Override
        @Transient
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        @Override
        public NodePropertyOverride build() {
            return new NodePropertyOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
