/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data volume used in a job's container properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<Host> HOST_FIELD = SdkField.<Host> builder(MarshallingType.SDK_POJO).memberName("host")
            .getter(getter(Volume::host)).setter(setter(Builder::host)).constructor(Host::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Volume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<EFSVolumeConfiguration> EFS_VOLUME_CONFIGURATION_FIELD = SdkField
            .<EFSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("efsVolumeConfiguration")
            .getter(getter(Volume::efsVolumeConfiguration)).setter(setter(Builder::efsVolumeConfiguration))
            .constructor(EFSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efsVolumeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, NAME_FIELD,
            EFS_VOLUME_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Host host;

    private final String name;

    private final EFSVolumeConfiguration efsVolumeConfiguration;

    private Volume(BuilderImpl builder) {
        this.host = builder.host;
        this.name = builder.name;
        this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
    }

    /**
     * <p>
     * The contents of the <code>host</code> parameter determine whether your data volume persists on the host container
     * instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for
     * your data volume. However, the data isn't guaranteed to persist after the containers associated with it stop
     * running.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     * </p>
     * </note>
     * 
     * @return The contents of the <code>host</code> parameter determine whether your data volume persists on the host
     *         container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns
     *         a host path for your data volume. However, the data isn't guaranteed to persist after the containers
     *         associated with it stop running.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     *         </p>
     */
    public final Host host() {
        return host;
    }

    /**
     * <p>
     * The name of the volume. It can be up to 255 letters long. It can contain uppercase and lowercase letters,
     * numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code> parameter of
     * container definition <code>mountPoints</code>.
     * </p>
     * 
     * @return The name of the volume. It can be up to 255 letters long. It can contain uppercase and lowercase letters,
     *         numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code>
     *         parameter of container definition <code>mountPoints</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * This parameter is specified when you are using an Amazon Elastic File System file system for job storage. Jobs
     * that are running on Fargate resources must specify a <code>platformVersion</code> of at least <code>1.4.0</code>.
     * </p>
     * 
     * @return This parameter is specified when you are using an Amazon Elastic File System file system for job storage.
     *         Jobs that are running on Fargate resources must specify a <code>platformVersion</code> of at least
     *         <code>1.4.0</code>.
     */
    public final EFSVolumeConfiguration efsVolumeConfiguration() {
        return efsVolumeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(efsVolumeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(name(), other.name())
                && Objects.equals(efsVolumeConfiguration(), other.efsVolumeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Volume").add("Host", host()).add("Name", name())
                .add("EfsVolumeConfiguration", efsVolumeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "host":
            return Optional.ofNullable(clazz.cast(host()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "efsVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(efsVolumeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The contents of the <code>host</code> parameter determine whether your data volume persists on the host
         * container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a
         * host path for your data volume. However, the data isn't guaranteed to persist after the containers associated
         * with it stop running.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         * </p>
         * </note>
         * 
         * @param host
         *        The contents of the <code>host</code> parameter determine whether your data volume persists on the
         *        host container instance and where it is stored. If the host parameter is empty, then the Docker daemon
         *        assigns a host path for your data volume. However, the data isn't guaranteed to persist after the
         *        containers associated with it stop running.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be
         *        provided.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(Host host);

        /**
         * <p>
         * The contents of the <code>host</code> parameter determine whether your data volume persists on the host
         * container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a
         * host path for your data volume. However, the data isn't guaranteed to persist after the containers associated
         * with it stop running.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Host.Builder} avoiding the need
         * to create one manually via {@link Host#builder()}.
         *
         * When the {@link Consumer} completes, {@link Host.Builder#build()} is called immediately and its result is
         * passed to {@link #host(Host)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link Host.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(Host)
         */
        default Builder host(Consumer<Host.Builder> host) {
            return host(Host.builder().applyMutation(host).build());
        }

        /**
         * <p>
         * The name of the volume. It can be up to 255 letters long. It can contain uppercase and lowercase letters,
         * numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code> parameter
         * of container definition <code>mountPoints</code>.
         * </p>
         * 
         * @param name
         *        The name of the volume. It can be up to 255 letters long. It can contain uppercase and lowercase
         *        letters, numbers, hyphens (-), and underscores (_). This name is referenced in the
         *        <code>sourceVolume</code> parameter of container definition <code>mountPoints</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * This parameter is specified when you are using an Amazon Elastic File System file system for job storage.
         * Jobs that are running on Fargate resources must specify a <code>platformVersion</code> of at least
         * <code>1.4.0</code>.
         * </p>
         * 
         * @param efsVolumeConfiguration
         *        This parameter is specified when you are using an Amazon Elastic File System file system for job
         *        storage. Jobs that are running on Fargate resources must specify a <code>platformVersion</code> of at
         *        least <code>1.4.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsVolumeConfiguration(EFSVolumeConfiguration efsVolumeConfiguration);

        /**
         * <p>
         * This parameter is specified when you are using an Amazon Elastic File System file system for job storage.
         * Jobs that are running on Fargate resources must specify a <code>platformVersion</code> of at least
         * <code>1.4.0</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EFSVolumeConfiguration.Builder} avoiding
         * the need to create one manually via {@link EFSVolumeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EFSVolumeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #efsVolumeConfiguration(EFSVolumeConfiguration)}.
         * 
         * @param efsVolumeConfiguration
         *        a consumer that will call methods on {@link EFSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsVolumeConfiguration(EFSVolumeConfiguration)
         */
        default Builder efsVolumeConfiguration(Consumer<EFSVolumeConfiguration.Builder> efsVolumeConfiguration) {
            return efsVolumeConfiguration(EFSVolumeConfiguration.builder().applyMutation(efsVolumeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Host host;

        private String name;

        private EFSVolumeConfiguration efsVolumeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            host(model.host);
            name(model.name);
            efsVolumeConfiguration(model.efsVolumeConfiguration);
        }

        public final Host.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        @Transient
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EFSVolumeConfiguration.Builder getEfsVolumeConfiguration() {
            return efsVolumeConfiguration != null ? efsVolumeConfiguration.toBuilder() : null;
        }

        public final void setEfsVolumeConfiguration(EFSVolumeConfiguration.BuilderImpl efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration != null ? efsVolumeConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder efsVolumeConfiguration(EFSVolumeConfiguration efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration;
            return this;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
