/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>DescribeJobQueues</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobQueuesRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeJobQueuesRequest.Builder, DescribeJobQueuesRequest> {
    private static final SdkField<List<String>> JOB_QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("jobQueues")
            .getter(getter(DescribeJobQueuesRequest::jobQueues))
            .setter(setter(Builder::jobQueues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeJobQueuesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeJobQueuesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUES_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> jobQueues;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeJobQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueues = builder.jobQueues;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobQueues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobQueues() {
        return jobQueues != null && !(jobQueues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobQueues} method.
     * </p>
     * 
     * @return A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
     */
    public final List<String> jobQueues() {
        return jobQueues;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this parameter
     * is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single page and a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code> value. This value can be
     * between 1 and 100. If this parameter isn't used, then <code>DescribeJobQueues</code> returns up to 100 results
     * and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this
     *         parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a
     *         single page and a <code>nextToken</code> response element. The remaining results of the initial request
     *         can be seen by sending another <code>DescribeJobQueues</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that's only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobQueues() ? jobQueues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesRequest)) {
            return false;
        }
        DescribeJobQueuesRequest other = (DescribeJobQueuesRequest) obj;
        return hasJobQueues() == other.hasJobQueues() && Objects.equals(jobQueues(), other.jobQueues())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobQueuesRequest").add("JobQueues", hasJobQueues() ? jobQueues() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueues":
            return Optional.ofNullable(clazz.cast(jobQueues()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobQueuesRequest, T> g) {
        return obj -> g.apply((DescribeJobQueuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobQueuesRequest> {
        /**
         * <p>
         * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobQueues
         *        A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(Collection<String> jobQueues);

        /**
         * <p>
         * A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param jobQueues
         *        A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueues(String... jobQueues);

        /**
         * <p>
         * The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this
         * parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single
         * page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen
         * by sending another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code> value.
         * This value can be between 1 and 100. If this parameter isn't used, then <code>DescribeJobQueues</code>
         * returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When
         *        this parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in
         *        a single page and a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>DescribeJobQueues</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         *        <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that's only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<String> jobQueues = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesRequest model) {
            super(model);
            jobQueues(model.jobQueues);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getJobQueues() {
            if (jobQueues instanceof SdkAutoConstructList) {
                return null;
            }
            return jobQueues;
        }

        public final void setJobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
        }

        @Override
        public final Builder jobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(String... jobQueues) {
            jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobQueuesRequest build() {
            return new DescribeJobQueuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
