/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the properties of the node range for a multi-node parallel job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeRangeProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeRangeProperty.Builder, NodeRangeProperty> {
    private static final SdkField<String> TARGET_NODES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetNodes").getter(getter(NodeRangeProperty::targetNodes)).setter(setter(Builder::targetNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetNodes").build()).build();

    private static final SdkField<ContainerProperties> CONTAINER_FIELD = SdkField
            .<ContainerProperties> builder(MarshallingType.SDK_POJO).memberName("container")
            .getter(getter(NodeRangeProperty::container)).setter(setter(Builder::container))
            .constructor(ContainerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODES_FIELD,
            CONTAINER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetNodes;

    private final ContainerProperties container;

    private NodeRangeProperty(BuilderImpl builder) {
        this.targetNodes = builder.targetNodes;
        this.container = builder.container;
    }

    /**
     * <p>
     * The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index values of
     * <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then
     * <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the
     * highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes (
     * <code>0:n</code>). You can nest node ranges, for example <code>0:10</code> and <code>4:5</code>, in which case
     * the <code>4:5</code> range properties override the <code>0:10</code> properties.
     * </p>
     * 
     * @return The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index
     *         values of <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>
     *         ), then <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>
     *         ), then the highest possible node index is used to end the range. Your accumulative node ranges must
     *         account for all nodes (<code>0:n</code>). You can nest node ranges, for example <code>0:10</code> and
     *         <code>4:5</code>, in which case the <code>4:5</code> range properties override the <code>0:10</code>
     *         properties.
     */
    public final String targetNodes() {
        return targetNodes;
    }

    /**
     * <p>
     * The container details for the node range.
     * </p>
     * 
     * @return The container details for the node range.
     */
    public final ContainerProperties container() {
        return container;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetNodes());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRangeProperty)) {
            return false;
        }
        NodeRangeProperty other = (NodeRangeProperty) obj;
        return Objects.equals(targetNodes(), other.targetNodes()) && Objects.equals(container(), other.container());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeRangeProperty").add("TargetNodes", targetNodes()).add("Container", container()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetNodes":
            return Optional.ofNullable(clazz.cast(targetNodes()));
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeRangeProperty, T> g) {
        return obj -> g.apply((NodeRangeProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeRangeProperty> {
        /**
         * <p>
         * The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index values of
         * <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then
         * <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the
         * highest possible node index is used to end the range. Your accumulative node ranges must account for all
         * nodes (<code>0:n</code>). You can nest node ranges, for example <code>0:10</code> and <code>4:5</code>, in
         * which case the <code>4:5</code> range properties override the <code>0:10</code> properties.
         * </p>
         * 
         * @param targetNodes
         *        The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index
         *        values of <code>0</code> through <code>3</code>. If the starting range value is omitted (
         *        <code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted
         *        (<code>n:</code>), then the highest possible node index is used to end the range. Your accumulative
         *        node ranges must account for all nodes (<code>0:n</code>). You can nest node ranges, for example
         *        <code>0:10</code> and <code>4:5</code>, in which case the <code>4:5</code> range properties override
         *        the <code>0:10</code> properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNodes(String targetNodes);

        /**
         * <p>
         * The container details for the node range.
         * </p>
         * 
         * @param container
         *        The container details for the node range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(ContainerProperties container);

        /**
         * <p>
         * The container details for the node range.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerProperties.Builder} avoiding the
         * need to create one manually via {@link ContainerProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #container(ContainerProperties)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link ContainerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(ContainerProperties)
         */
        default Builder container(Consumer<ContainerProperties.Builder> container) {
            return container(ContainerProperties.builder().applyMutation(container).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetNodes;

        private ContainerProperties container;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRangeProperty model) {
            targetNodes(model.targetNodes);
            container(model.container);
        }

        public final String getTargetNodes() {
            return targetNodes;
        }

        public final void setTargetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
        }

        @Override
        public final Builder targetNodes(String targetNodes) {
            this.targetNodes = targetNodes;
            return this;
        }

        public final ContainerProperties.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(ContainerProperties.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerProperties container) {
            this.container = container;
            return this;
        }

        @Override
        public NodeRangeProperty build() {
            return new NodeRangeProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
