/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must
 * not specify this parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<String> ASSIGN_PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assignPublicIp").getter(getter(NetworkConfiguration::assignPublicIpAsString))
            .setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGN_PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assignPublicIp;

    private NetworkConfiguration(BuilderImpl builder) {
        this.assignPublicIp = builder.assignPublicIp;
    }

    /**
     * <p>
     * Indicates whether the job should have a public IP address. For a job that is running on Fargate resources in a
     * private subnet to send outbound traffic to the internet (for example, to pull container images), the private
     * subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task
     * networking</a>. The default value is "DISABLED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Indicates whether the job should have a public IP address. For a job that is running on Fargate resources
     *         in a private subnet to send outbound traffic to the internet (for example, to pull container images), the
     *         private subnet requires a NAT gateway be attached to route requests to the internet. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task
     *         networking</a>. The default value is "DISABLED".
     * @see AssignPublicIp
     */
    public final AssignPublicIp assignPublicIp() {
        return AssignPublicIp.fromValue(assignPublicIp);
    }

    /**
     * <p>
     * Indicates whether the job should have a public IP address. For a job that is running on Fargate resources in a
     * private subnet to send outbound traffic to the internet (for example, to pull container images), the private
     * subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task
     * networking</a>. The default value is "DISABLED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignPublicIp}
     * will return {@link AssignPublicIp#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignPublicIpAsString}.
     * </p>
     * 
     * @return Indicates whether the job should have a public IP address. For a job that is running on Fargate resources
     *         in a private subnet to send outbound traffic to the internet (for example, to pull container images), the
     *         private subnet requires a NAT gateway be attached to route requests to the internet. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task
     *         networking</a>. The default value is "DISABLED".
     * @see AssignPublicIp
     */
    public final String assignPublicIpAsString() {
        return assignPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIpAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(assignPublicIpAsString(), other.assignPublicIpAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfiguration").add("AssignPublicIp", assignPublicIpAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIpAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * Indicates whether the job should have a public IP address. For a job that is running on Fargate resources in
         * a private subnet to send outbound traffic to the internet (for example, to pull container images), the
         * private subnet requires a NAT gateway be attached to route requests to the internet. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS
         * task networking</a>. The default value is "DISABLED".
         * </p>
         * 
         * @param assignPublicIp
         *        Indicates whether the job should have a public IP address. For a job that is running on Fargate
         *        resources in a private subnet to send outbound traffic to the internet (for example, to pull container
         *        images), the private subnet requires a NAT gateway be attached to route requests to the internet. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS
         *        task networking</a>. The default value is "DISABLED".
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(String assignPublicIp);

        /**
         * <p>
         * Indicates whether the job should have a public IP address. For a job that is running on Fargate resources in
         * a private subnet to send outbound traffic to the internet (for example, to pull container images), the
         * private subnet requires a NAT gateway be attached to route requests to the internet. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS
         * task networking</a>. The default value is "DISABLED".
         * </p>
         * 
         * @param assignPublicIp
         *        Indicates whether the job should have a public IP address. For a job that is running on Fargate
         *        resources in a private subnet to send outbound traffic to the internet (for example, to pull container
         *        images), the private subnet requires a NAT gateway be attached to route requests to the internet. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS
         *        task networking</a>. The default value is "DISABLED".
         * @see AssignPublicIp
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignPublicIp
         */
        Builder assignPublicIp(AssignPublicIp assignPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private String assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            assignPublicIp(model.assignPublicIp);
        }

        public final String getAssignPublicIp() {
            return assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public final Builder assignPublicIp(AssignPublicIp assignPublicIp) {
            this.assignPublicIp(assignPublicIp == null ? null : assignPublicIp.toString());
            return this;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
