/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>DescribeJobDefinitions</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobDefinitionsRequest extends BatchRequest implements
        ToCopyableBuilder<DescribeJobDefinitionsRequest.Builder, DescribeJobDefinitionsRequest> {
    private static final SdkField<List<String>> JOB_DEFINITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("jobDefinitions")
            .getter(getter(DescribeJobDefinitionsRequest::jobDefinitions))
            .setter(setter(Builder::jobDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeJobDefinitionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionName").getter(getter(DescribeJobDefinitionsRequest::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeJobDefinitionsRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeJobDefinitionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITIONS_FIELD,
            MAX_RESULTS_FIELD, JOB_DEFINITION_NAME_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> jobDefinitions;

    private final Integer maxResults;

    private final String jobDefinitionName;

    private final String status;

    private final String nextToken;

    private DescribeJobDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitions = builder.jobDefinitions;
        this.maxResults = builder.maxResults;
        this.jobDefinitionName = builder.jobDefinitionName;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobDefinitions() {
        return jobDefinitions != null && !(jobDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
     * <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a short
     * version using the form <code>${JobDefinitionName}:${Revision}</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobDefinitions} method.
     * </p>
     * 
     * @return A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
     *         <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a
     *         short version using the form <code>${JobDefinitionName}:${Revision}</code>.
     */
    public final List<String> jobDefinitions() {
        return jobDefinitions;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
     * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a single
     * page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>DescribeJobDefinitions</code> request with the returned <code>nextToken</code> value. This
     * value can be between 1 and 100. If this parameter isn't used, then <code>DescribeJobDefinitions</code> returns up
     * to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When
     *         this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results
     *         in a single page and a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribeJobDefinitions</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the job definition to describe.
     * </p>
     * 
     * @return The name of the job definition to describe.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The status used to filter job definitions.
     * </p>
     * 
     * @return The status used to filter job definitions.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code> request
     * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
     * from the end of the previous results that returned the <code>nextToken</code> value. This value is
     * <code>null</code> when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that's only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobDefinitions() ? jobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobDefinitionsRequest)) {
            return false;
        }
        DescribeJobDefinitionsRequest other = (DescribeJobDefinitionsRequest) obj;
        return hasJobDefinitions() == other.hasJobDefinitions() && Objects.equals(jobDefinitions(), other.jobDefinitions())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(status(), other.status())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobDefinitionsRequest")
                .add("JobDefinitions", hasJobDefinitions() ? jobDefinitions() : null).add("MaxResults", maxResults())
                .add("JobDefinitionName", jobDefinitionName()).add("Status", status()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDefinitions":
            return Optional.ofNullable(clazz.cast(jobDefinitions()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "jobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobDefinitionsRequest, T> g) {
        return obj -> g.apply((DescribeJobDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobDefinitionsRequest> {
        /**
         * <p>
         * A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
         * <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a short
         * version using the form <code>${JobDefinitionName}:${Revision}</code>.
         * </p>
         * 
         * @param jobDefinitions
         *        A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
         *        <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a
         *        short version using the form <code>${JobDefinitionName}:${Revision}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(Collection<String> jobDefinitions);

        /**
         * <p>
         * A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
         * <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a short
         * version using the form <code>${JobDefinitionName}:${Revision}</code>.
         * </p>
         * 
         * @param jobDefinitions
         *        A list of up to 100 job definitions. Each entry in the list can either be an ARN of the form
         *        <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a
         *        short version using the form <code>${JobDefinitionName}:${Revision}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitions(String... jobDefinitions);

        /**
         * <p>
         * The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this
         * parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a
         * single page and a <code>nextToken</code> response element. The remaining results of the initial request can
         * be seen by sending another <code>DescribeJobDefinitions</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         * <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output.
         *        When this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code>
         *        results in a single page and a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with the
         *        returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't
         *        used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code>
         *        value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the job definition to describe.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the job definition to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The status used to filter job definitions.
         * </p>
         * 
         * @param status
         *        The status used to filter job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * This value is <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that's only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeJobDefinitions</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more
         *        results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that's only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private List<String> jobDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String jobDefinitionName;

        private String status;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobDefinitionsRequest model) {
            super(model);
            jobDefinitions(model.jobDefinitions);
            maxResults(model.maxResults);
            jobDefinitionName(model.jobDefinitionName);
            status(model.status);
            nextToken(model.nextToken);
        }

        public final Collection<String> getJobDefinitions() {
            if (jobDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return jobDefinitions;
        }

        public final void setJobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
        }

        @Override
        @Transient
        public final Builder jobDefinitions(Collection<String> jobDefinitions) {
            this.jobDefinitions = StringListCopier.copy(jobDefinitions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobDefinitions(String... jobDefinitions) {
            jobDefinitions(Arrays.asList(jobDefinitions));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        @Transient
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobDefinitionsRequest build() {
            return new DescribeJobDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
