/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The fair share policy for a scheduling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FairsharePolicy implements SdkPojo, Serializable, ToCopyableBuilder<FairsharePolicy.Builder, FairsharePolicy> {
    private static final SdkField<Integer> SHARE_DECAY_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("shareDecaySeconds").getter(getter(FairsharePolicy::shareDecaySeconds))
            .setter(setter(Builder::shareDecaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareDecaySeconds").build()).build();

    private static final SdkField<Integer> COMPUTE_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("computeReservation").getter(getter(FairsharePolicy::computeReservation))
            .setter(setter(Builder::computeReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeReservation").build())
            .build();

    private static final SdkField<List<ShareAttributes>> SHARE_DISTRIBUTION_FIELD = SdkField
            .<List<ShareAttributes>> builder(MarshallingType.LIST)
            .memberName("shareDistribution")
            .getter(getter(FairsharePolicy::shareDistribution))
            .setter(setter(Builder::shareDistribution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareDistribution").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ShareAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(ShareAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_DECAY_SECONDS_FIELD,
            COMPUTE_RESERVATION_FIELD, SHARE_DISTRIBUTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer shareDecaySeconds;

    private final Integer computeReservation;

    private final List<ShareAttributes> shareDistribution;

    private FairsharePolicy(BuilderImpl builder) {
        this.shareDecaySeconds = builder.shareDecaySeconds;
        this.computeReservation = builder.computeReservation;
        this.shareDistribution = builder.shareDistribution;
    }

    /**
     * <p>
     * The time period to use to calculate a fair share percentage for each fair share identifier in use, in seconds. A
     * value of zero (0) indicates that only current usage should be measured; if there are four evenly weighted fair
     * share identifiers then each can only use up to 25% of the available CPU resources, even if some of the fair share
     * identifiers have no currently running jobs. The decay allows for more recently run jobs to have more weight than
     * jobs that ran earlier. The maximum supported value is 604800 (1 week).
     * </p>
     * 
     * @return The time period to use to calculate a fair share percentage for each fair share identifier in use, in
     *         seconds. A value of zero (0) indicates that only current usage should be measured; if there are four
     *         evenly weighted fair share identifiers then each can only use up to 25% of the available CPU resources,
     *         even if some of the fair share identifiers have no currently running jobs. The decay allows for more
     *         recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800
     *         (1 week).
     */
    public final Integer shareDecaySeconds() {
        return shareDecaySeconds;
    }

    /**
     * <p>
     * A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been
     * used.
     * </p>
     * <p>
     * The reserved ratio is <code>(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> </code> where
     * <code> <i>ActiveFairShares</i> </code> is the number of active fair share identifiers.
     * </p>
     * <p>
     * For example, a <code>computeReservation</code> value of 50 indicates that Batch should reserve 50% of the maximum
     * available vCPU if there is only one fair share identifier, 25% if there are two fair share identifiers, and 12.5%
     * if there are three fair share identifiers. A <code>computeReservation</code> value of 25 indicates that Batch
     * should reserve 25% of the maximum available vCPU if there is only one fair share identifier, 6.25% if there are
     * two fair share identifiers, and 1.56% if there are three fair share identifiers.
     * </p>
     * <p>
     * The minimum value is 0 and the maximum value is 99.
     * </p>
     * 
     * @return A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet
     *         been used.</p>
     *         <p>
     *         The reserved ratio is <code>(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> </code> where
     *         <code> <i>ActiveFairShares</i> </code> is the number of active fair share identifiers.
     *         </p>
     *         <p>
     *         For example, a <code>computeReservation</code> value of 50 indicates that Batch should reserve 50% of the
     *         maximum available vCPU if there is only one fair share identifier, 25% if there are two fair share
     *         identifiers, and 12.5% if there are three fair share identifiers. A <code>computeReservation</code> value
     *         of 25 indicates that Batch should reserve 25% of the maximum available vCPU if there is only one fair
     *         share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share
     *         identifiers.
     *         </p>
     *         <p>
     *         The minimum value is 0 and the maximum value is 99.
     */
    public final Integer computeReservation() {
        return computeReservation;
    }

    /**
     * For responses, this returns true if the service returned a value for the ShareDistribution property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShareDistribution() {
        return shareDistribution != null && !(shareDistribution instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for the
     * fair share policy. Fair share identifiers that are not included have a default weight of <code>1.0</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShareDistribution} method.
     * </p>
     * 
     * @return Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers
     *         for the fair share policy. Fair share identifiers that are not included have a default weight of
     *         <code>1.0</code>.
     */
    public final List<ShareAttributes> shareDistribution() {
        return shareDistribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareDecaySeconds());
        hashCode = 31 * hashCode + Objects.hashCode(computeReservation());
        hashCode = 31 * hashCode + Objects.hashCode(hasShareDistribution() ? shareDistribution() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FairsharePolicy)) {
            return false;
        }
        FairsharePolicy other = (FairsharePolicy) obj;
        return Objects.equals(shareDecaySeconds(), other.shareDecaySeconds())
                && Objects.equals(computeReservation(), other.computeReservation())
                && hasShareDistribution() == other.hasShareDistribution()
                && Objects.equals(shareDistribution(), other.shareDistribution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FairsharePolicy").add("ShareDecaySeconds", shareDecaySeconds())
                .add("ComputeReservation", computeReservation())
                .add("ShareDistribution", hasShareDistribution() ? shareDistribution() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shareDecaySeconds":
            return Optional.ofNullable(clazz.cast(shareDecaySeconds()));
        case "computeReservation":
            return Optional.ofNullable(clazz.cast(computeReservation()));
        case "shareDistribution":
            return Optional.ofNullable(clazz.cast(shareDistribution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FairsharePolicy, T> g) {
        return obj -> g.apply((FairsharePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FairsharePolicy> {
        /**
         * <p>
         * The time period to use to calculate a fair share percentage for each fair share identifier in use, in
         * seconds. A value of zero (0) indicates that only current usage should be measured; if there are four evenly
         * weighted fair share identifiers then each can only use up to 25% of the available CPU resources, even if some
         * of the fair share identifiers have no currently running jobs. The decay allows for more recently run jobs to
         * have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).
         * </p>
         * 
         * @param shareDecaySeconds
         *        The time period to use to calculate a fair share percentage for each fair share identifier in use, in
         *        seconds. A value of zero (0) indicates that only current usage should be measured; if there are four
         *        evenly weighted fair share identifiers then each can only use up to 25% of the available CPU
         *        resources, even if some of the fair share identifiers have no currently running jobs. The decay allows
         *        for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value
         *        is 604800 (1 week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareDecaySeconds(Integer shareDecaySeconds);

        /**
         * <p>
         * A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been
         * used.
         * </p>
         * <p>
         * The reserved ratio is <code>(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> </code> where
         * <code> <i>ActiveFairShares</i> </code> is the number of active fair share identifiers.
         * </p>
         * <p>
         * For example, a <code>computeReservation</code> value of 50 indicates that Batch should reserve 50% of the
         * maximum available vCPU if there is only one fair share identifier, 25% if there are two fair share
         * identifiers, and 12.5% if there are three fair share identifiers. A <code>computeReservation</code> value of
         * 25 indicates that Batch should reserve 25% of the maximum available vCPU if there is only one fair share
         * identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share
         * identifiers.
         * </p>
         * <p>
         * The minimum value is 0 and the maximum value is 99.
         * </p>
         * 
         * @param computeReservation
         *        A value used to reserve some of the available maximum vCPU for fair share identifiers that have not
         *        yet been used.</p>
         *        <p>
         *        The reserved ratio is <code>(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> </code> where
         *        <code> <i>ActiveFairShares</i> </code> is the number of active fair share identifiers.
         *        </p>
         *        <p>
         *        For example, a <code>computeReservation</code> value of 50 indicates that Batch should reserve 50% of
         *        the maximum available vCPU if there is only one fair share identifier, 25% if there are two fair share
         *        identifiers, and 12.5% if there are three fair share identifiers. A <code>computeReservation</code>
         *        value of 25 indicates that Batch should reserve 25% of the maximum available vCPU if there is only one
         *        fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three
         *        fair share identifiers.
         *        </p>
         *        <p>
         *        The minimum value is 0 and the maximum value is 99.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeReservation(Integer computeReservation);

        /**
         * <p>
         * Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for
         * the fair share policy. Fair share identifiers that are not included have a default weight of <code>1.0</code>
         * .
         * </p>
         * 
         * @param shareDistribution
         *        Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers
         *        for the fair share policy. Fair share identifiers that are not included have a default weight of
         *        <code>1.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareDistribution(Collection<ShareAttributes> shareDistribution);

        /**
         * <p>
         * Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for
         * the fair share policy. Fair share identifiers that are not included have a default weight of <code>1.0</code>
         * .
         * </p>
         * 
         * @param shareDistribution
         *        Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers
         *        for the fair share policy. Fair share identifiers that are not included have a default weight of
         *        <code>1.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareDistribution(ShareAttributes... shareDistribution);

        /**
         * <p>
         * Array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for
         * the fair share policy. Fair share identifiers that are not included have a default weight of <code>1.0</code>
         * .
         * </p>
         * This is a convenience that creates an instance of the {@link List<ShareAttributes>.Builder} avoiding the need
         * to create one manually via {@link List<ShareAttributes>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ShareAttributes>.Builder#build()} is called immediately and
         * its result is passed to {@link #shareDistribution(List<ShareAttributes>)}.
         * 
         * @param shareDistribution
         *        a consumer that will call methods on {@link List<ShareAttributes>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareDistribution(List<ShareAttributes>)
         */
        Builder shareDistribution(Consumer<ShareAttributes.Builder>... shareDistribution);
    }

    static final class BuilderImpl implements Builder {
        private Integer shareDecaySeconds;

        private Integer computeReservation;

        private List<ShareAttributes> shareDistribution = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FairsharePolicy model) {
            shareDecaySeconds(model.shareDecaySeconds);
            computeReservation(model.computeReservation);
            shareDistribution(model.shareDistribution);
        }

        public final Integer getShareDecaySeconds() {
            return shareDecaySeconds;
        }

        public final void setShareDecaySeconds(Integer shareDecaySeconds) {
            this.shareDecaySeconds = shareDecaySeconds;
        }

        @Override
        @Transient
        public final Builder shareDecaySeconds(Integer shareDecaySeconds) {
            this.shareDecaySeconds = shareDecaySeconds;
            return this;
        }

        public final Integer getComputeReservation() {
            return computeReservation;
        }

        public final void setComputeReservation(Integer computeReservation) {
            this.computeReservation = computeReservation;
        }

        @Override
        @Transient
        public final Builder computeReservation(Integer computeReservation) {
            this.computeReservation = computeReservation;
            return this;
        }

        public final List<ShareAttributes.Builder> getShareDistribution() {
            List<ShareAttributes.Builder> result = ShareAttributesListCopier.copyToBuilder(this.shareDistribution);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareDistribution(Collection<ShareAttributes.BuilderImpl> shareDistribution) {
            this.shareDistribution = ShareAttributesListCopier.copyFromBuilder(shareDistribution);
        }

        @Override
        @Transient
        public final Builder shareDistribution(Collection<ShareAttributes> shareDistribution) {
            this.shareDistribution = ShareAttributesListCopier.copy(shareDistribution);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder shareDistribution(ShareAttributes... shareDistribution) {
            shareDistribution(Arrays.asList(shareDistribution));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder shareDistribution(Consumer<ShareAttributes.Builder>... shareDistribution) {
            shareDistribution(Stream.of(shareDistribution).map(c -> ShareAttributes.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FairsharePolicy build() {
            return new FairsharePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
