/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The retry strategy associated with a job. For more information, see <a
 * href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <i>Batch
 * User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryStrategy implements SdkPojo, Serializable, ToCopyableBuilder<RetryStrategy.Builder, RetryStrategy> {
    private static final SdkField<Integer> ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attempts").getter(getter(RetryStrategy::attempts)).setter(setter(Builder::attempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempts").build()).build();

    private static final SdkField<List<EvaluateOnExit>> EVALUATE_ON_EXIT_FIELD = SdkField
            .<List<EvaluateOnExit>> builder(MarshallingType.LIST)
            .memberName("evaluateOnExit")
            .getter(getter(RetryStrategy::evaluateOnExit))
            .setter(setter(Builder::evaluateOnExit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluateOnExit").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluateOnExit> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluateOnExit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTEMPTS_FIELD,
            EVALUATE_ON_EXIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer attempts;

    private final List<EvaluateOnExit> evaluateOnExit;

    private RetryStrategy(BuilderImpl builder) {
        this.attempts = builder.attempts;
        this.evaluateOnExit = builder.evaluateOnExit;
    }

    /**
     * <p>
     * The number of times to move a job to the <code>RUNNABLE</code> status. You can specify between 1 and 10 attempts.
     * If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of
     * attempts as the value.
     * </p>
     * 
     * @return The number of times to move a job to the <code>RUNNABLE</code> status. You can specify between 1 and 10
     *         attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the
     *         same number of attempts as the value.
     */
    public final Integer attempts() {
        return attempts;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluateOnExit property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEvaluateOnExit() {
        return evaluateOnExit != null && !(evaluateOnExit instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
     * parameter is specified, then the <code>attempts</code> parameter must also be specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluateOnExit} method.
     * </p>
     * 
     * @return Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
     *         parameter is specified, then the <code>attempts</code> parameter must also be specified.
     */
    public final List<EvaluateOnExit> evaluateOnExit() {
        return evaluateOnExit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attempts());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluateOnExit() ? evaluateOnExit() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy) obj;
        return Objects.equals(attempts(), other.attempts()) && hasEvaluateOnExit() == other.hasEvaluateOnExit()
                && Objects.equals(evaluateOnExit(), other.evaluateOnExit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryStrategy").add("Attempts", attempts())
                .add("EvaluateOnExit", hasEvaluateOnExit() ? evaluateOnExit() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attempts":
            return Optional.ofNullable(clazz.cast(attempts()));
        case "evaluateOnExit":
            return Optional.ofNullable(clazz.cast(evaluateOnExit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryStrategy, T> g) {
        return obj -> g.apply((RetryStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetryStrategy> {
        /**
         * <p>
         * The number of times to move a job to the <code>RUNNABLE</code> status. You can specify between 1 and 10
         * attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same
         * number of attempts as the value.
         * </p>
         * 
         * @param attempts
         *        The number of times to move a job to the <code>RUNNABLE</code> status. You can specify between 1 and
         *        10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure
         *        the same number of attempts as the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempts(Integer attempts);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of up to 5 objects that specify conditions under which the job should be retried or failed. If
         *        this parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * 
         * @param evaluateOnExit
         *        Array of up to 5 objects that specify conditions under which the job should be retried or failed. If
         *        this parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluateOnExit(EvaluateOnExit... evaluateOnExit);

        /**
         * <p>
         * Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this
         * parameter is specified, then the <code>attempts</code> parameter must also be specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EvaluateOnExit>.Builder} avoiding the need
         * to create one manually via {@link List<EvaluateOnExit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EvaluateOnExit>.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluateOnExit(List<EvaluateOnExit>)}.
         * 
         * @param evaluateOnExit
         *        a consumer that will call methods on {@link List<EvaluateOnExit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluateOnExit(List<EvaluateOnExit>)
         */
        Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder>... evaluateOnExit);
    }

    static final class BuilderImpl implements Builder {
        private Integer attempts;

        private List<EvaluateOnExit> evaluateOnExit = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStrategy model) {
            attempts(model.attempts);
            evaluateOnExit(model.evaluateOnExit);
        }

        public final Integer getAttempts() {
            return attempts;
        }

        public final void setAttempts(Integer attempts) {
            this.attempts = attempts;
        }

        @Override
        @Transient
        public final Builder attempts(Integer attempts) {
            this.attempts = attempts;
            return this;
        }

        public final List<EvaluateOnExit.Builder> getEvaluateOnExit() {
            List<EvaluateOnExit.Builder> result = EvaluateOnExitListCopier.copyToBuilder(this.evaluateOnExit);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluateOnExit(Collection<EvaluateOnExit.BuilderImpl> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copyFromBuilder(evaluateOnExit);
        }

        @Override
        @Transient
        public final Builder evaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit) {
            this.evaluateOnExit = EvaluateOnExitListCopier.copy(evaluateOnExit);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluateOnExit(EvaluateOnExit... evaluateOnExit) {
            evaluateOnExit(Arrays.asList(evaluateOnExit));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluateOnExit(Consumer<EvaluateOnExit.Builder>... evaluateOnExit) {
            evaluateOnExit(Stream.of(evaluateOnExit).map(c -> EvaluateOnExit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetryStrategy build() {
            return new RetryStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
