/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSchedulingPolicyRequest extends BatchRequest implements
        ToCopyableBuilder<CreateSchedulingPolicyRequest.Builder, CreateSchedulingPolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSchedulingPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<FairsharePolicy> FAIRSHARE_POLICY_FIELD = SdkField
            .<FairsharePolicy> builder(MarshallingType.SDK_POJO).memberName("fairsharePolicy")
            .getter(getter(CreateSchedulingPolicyRequest::fairsharePolicy)).setter(setter(Builder::fairsharePolicy))
            .constructor(FairsharePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fairsharePolicy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSchedulingPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            FAIRSHARE_POLICY_FIELD, TAGS_FIELD));

    private final String name;

    private final FairsharePolicy fairsharePolicy;

    private final Map<String, String> tags;

    private CreateSchedulingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.fairsharePolicy = builder.fairsharePolicy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the scheduling policy. It can be up to 128 letters long. It can contain uppercase and lowercase
     * letters, numbers, hyphens (-), and underscores (_).
     * </p>
     * 
     * @return The name of the scheduling policy. It can be up to 128 letters long. It can contain uppercase and
     *         lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The fair share policy of the scheduling policy.
     * </p>
     * 
     * @return The fair share policy of the scheduling policy.
     */
    public final FairsharePolicy fairsharePolicy() {
        return fairsharePolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the scheduling policy to help you categorize and organize your resources. Each tag
     * consists of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>
     * in <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * These tags can be updated or removed using the <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
     * operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the scheduling policy to help you categorize and organize your resources. Each
     *         tag consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a> in <i>Amazon Web Services General Reference</i>.</p>
     *         <p>
     *         These tags can be updated or removed using the <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
     *         operations.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fairsharePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchedulingPolicyRequest)) {
            return false;
        }
        CreateSchedulingPolicyRequest other = (CreateSchedulingPolicyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(fairsharePolicy(), other.fairsharePolicy())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSchedulingPolicyRequest").add("Name", name()).add("FairsharePolicy", fairsharePolicy())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fairsharePolicy":
            return Optional.ofNullable(clazz.cast(fairsharePolicy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchedulingPolicyRequest, T> g) {
        return obj -> g.apply((CreateSchedulingPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSchedulingPolicyRequest> {
        /**
         * <p>
         * The name of the scheduling policy. It can be up to 128 letters long. It can contain uppercase and lowercase
         * letters, numbers, hyphens (-), and underscores (_).
         * </p>
         * 
         * @param name
         *        The name of the scheduling policy. It can be up to 128 letters long. It can contain uppercase and
         *        lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The fair share policy of the scheduling policy.
         * </p>
         * 
         * @param fairsharePolicy
         *        The fair share policy of the scheduling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fairsharePolicy(FairsharePolicy fairsharePolicy);

        /**
         * <p>
         * The fair share policy of the scheduling policy.
         * </p>
         * This is a convenience that creates an instance of the {@link FairsharePolicy.Builder} avoiding the need to
         * create one manually via {@link FairsharePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link FairsharePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #fairsharePolicy(FairsharePolicy)}.
         * 
         * @param fairsharePolicy
         *        a consumer that will call methods on {@link FairsharePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fairsharePolicy(FairsharePolicy)
         */
        default Builder fairsharePolicy(Consumer<FairsharePolicy.Builder> fairsharePolicy) {
            return fairsharePolicy(FairsharePolicy.builder().applyMutation(fairsharePolicy).build());
        }

        /**
         * <p>
         * The tags that you apply to the scheduling policy to help you categorize and organize your resources. Each tag
         * consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a> in <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * These tags can be updated or removed using the <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API
         * operations.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the scheduling policy to help you categorize and organize your resources.
         *        Each tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a> in <i>Amazon Web Services General Reference</i>.</p>
         *        <p>
         *        These tags can be updated or removed using the <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and
         *        <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a>
         *        API operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String name;

        private FairsharePolicy fairsharePolicy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchedulingPolicyRequest model) {
            super(model);
            name(model.name);
            fairsharePolicy(model.fairsharePolicy);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FairsharePolicy.Builder getFairsharePolicy() {
            return fairsharePolicy != null ? fairsharePolicy.toBuilder() : null;
        }

        public final void setFairsharePolicy(FairsharePolicy.BuilderImpl fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy != null ? fairsharePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder fairsharePolicy(FairsharePolicy fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSchedulingPolicyRequest build() {
            return new CreateSchedulingPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
