/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.FairsharePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSchedulingPolicyRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, UpdateSchedulingPolicyRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateSchedulingPolicyRequest.getter(UpdateSchedulingPolicyRequest::arn)).setter(UpdateSchedulingPolicyRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<FairsharePolicy> FAIRSHARE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fairsharePolicy").getter(UpdateSchedulingPolicyRequest.getter(UpdateSchedulingPolicyRequest::fairsharePolicy)).setter(UpdateSchedulingPolicyRequest.setter(Builder::fairsharePolicy)).constructor(FairsharePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fairsharePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FAIRSHARE_POLICY_FIELD));
    private final String arn;
    private final FairsharePolicy fairsharePolicy;

    private UpdateSchedulingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.fairsharePolicy = builder.fairsharePolicy;
    }

    public final String arn() {
        return this.arn;
    }

    public final FairsharePolicy fairsharePolicy() {
        return this.fairsharePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fairsharePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchedulingPolicyRequest)) {
            return false;
        }
        UpdateSchedulingPolicyRequest other = (UpdateSchedulingPolicyRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.fairsharePolicy(), other.fairsharePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSchedulingPolicyRequest").add("Arn", (Object)this.arn()).add("FairsharePolicy", (Object)this.fairsharePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "fairsharePolicy": {
                return Optional.ofNullable(clazz.cast(this.fairsharePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchedulingPolicyRequest, T> g) {
        return obj -> g.apply((UpdateSchedulingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String arn;
        private FairsharePolicy fairsharePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchedulingPolicyRequest model) {
            super(model);
            this.arn(model.arn);
            this.fairsharePolicy(model.fairsharePolicy);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final FairsharePolicy.Builder getFairsharePolicy() {
            return this.fairsharePolicy != null ? this.fairsharePolicy.toBuilder() : null;
        }

        public final void setFairsharePolicy(FairsharePolicy.BuilderImpl fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy != null ? fairsharePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder fairsharePolicy(FairsharePolicy fairsharePolicy) {
            this.fairsharePolicy = fairsharePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSchedulingPolicyRequest build() {
            return new UpdateSchedulingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSchedulingPolicyRequest> {
        public Builder arn(String var1);

        public Builder fairsharePolicy(FairsharePolicy var1);

        default public Builder fairsharePolicy(Consumer<FairsharePolicy.Builder> fairsharePolicy) {
            return this.fairsharePolicy((FairsharePolicy)((FairsharePolicy.Builder)FairsharePolicy.builder().applyMutation(fairsharePolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

