/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary;
import software.amazon.awssdk.services.batch.model.ContainerSummary;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.model.NodePropertiesSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(JobSummary.getter(JobSummary::jobArn)).setter(JobSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobSummary.getter(JobSummary::jobId)).setter(JobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(JobSummary.getter(JobSummary::jobName)).setter(JobSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdAt").getter(JobSummary.getter(JobSummary::createdAt)).setter(JobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobSummary.getter(JobSummary::statusAsString)).setter(JobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(JobSummary.getter(JobSummary::statusReason)).setter(JobSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startedAt").getter(JobSummary.getter(JobSummary::startedAt)).setter(JobSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("stoppedAt").getter(JobSummary.getter(JobSummary::stoppedAt)).setter(JobSummary.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<ContainerSummary> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("container").getter(JobSummary.getter(JobSummary::container)).setter(JobSummary.setter(Builder::container)).constructor(ContainerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<ArrayPropertiesSummary> ARRAY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arrayProperties").getter(JobSummary.getter(JobSummary::arrayProperties)).setter(JobSummary.setter(Builder::arrayProperties)).constructor(ArrayPropertiesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayProperties").build()}).build();
    private static final SdkField<NodePropertiesSummary> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeProperties").getter(JobSummary.getter(JobSummary::nodeProperties)).setter(JobSummary.setter(Builder::nodeProperties)).constructor(NodePropertiesSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()}).build();
    private static final SdkField<String> JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinition").getter(JobSummary.getter(JobSummary::jobDefinition)).setter(JobSummary.setter(Builder::jobDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, CREATED_AT_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, CONTAINER_FIELD, ARRAY_PROPERTIES_FIELD, NODE_PROPERTIES_FIELD, JOB_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobId;
    private final String jobName;
    private final Long createdAt;
    private final String status;
    private final String statusReason;
    private final Long startedAt;
    private final Long stoppedAt;
    private final ContainerSummary container;
    private final ArrayPropertiesSummary arrayProperties;
    private final NodePropertiesSummary nodeProperties;
    private final String jobDefinition;

    private JobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.container = builder.container;
        this.arrayProperties = builder.arrayProperties;
        this.nodeProperties = builder.nodeProperties;
        this.jobDefinition = builder.jobDefinition;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final Long createdAt() {
        return this.createdAt;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Long startedAt() {
        return this.startedAt;
    }

    public final Long stoppedAt() {
        return this.stoppedAt;
    }

    public final ContainerSummary container() {
        return this.container;
    }

    public final ArrayPropertiesSummary arrayProperties() {
        return this.arrayProperties;
    }

    public final NodePropertiesSummary nodeProperties() {
        return this.nodeProperties;
    }

    public final String jobDefinition() {
        return this.jobDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.arrayProperties(), other.arrayProperties()) && Objects.equals(this.nodeProperties(), other.nodeProperties()) && Objects.equals(this.jobDefinition(), other.jobDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"JobSummary").add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("JobName", (Object)this.jobName()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("Container", (Object)this.container()).add("ArrayProperties", (Object)this.arrayProperties()).add("NodeProperties", (Object)this.nodeProperties()).add("JobDefinition", (Object)this.jobDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "arrayProperties": {
                return Optional.ofNullable(clazz.cast(this.arrayProperties()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "jobDefinition": {
                return Optional.ofNullable(clazz.cast(this.jobDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobId;
        private String jobName;
        private Long createdAt;
        private String status;
        private String statusReason;
        private Long startedAt;
        private Long stoppedAt;
        private ContainerSummary container;
        private ArrayPropertiesSummary arrayProperties;
        private NodePropertiesSummary nodeProperties;
        private String jobDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.container(model.container);
            this.arrayProperties(model.arrayProperties);
            this.nodeProperties(model.nodeProperties);
            this.jobDefinition(model.jobDefinition);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final ContainerSummary.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(ContainerSummary.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerSummary container) {
            this.container = container;
            return this;
        }

        public final ArrayPropertiesSummary.Builder getArrayProperties() {
            return this.arrayProperties != null ? this.arrayProperties.toBuilder() : null;
        }

        public final void setArrayProperties(ArrayPropertiesSummary.BuilderImpl arrayProperties) {
            this.arrayProperties = arrayProperties != null ? arrayProperties.build() : null;
        }

        @Override
        public final Builder arrayProperties(ArrayPropertiesSummary arrayProperties) {
            this.arrayProperties = arrayProperties;
            return this;
        }

        public final NodePropertiesSummary.Builder getNodeProperties() {
            return this.nodeProperties != null ? this.nodeProperties.toBuilder() : null;
        }

        public final void setNodeProperties(NodePropertiesSummary.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        @Override
        public final Builder nodeProperties(NodePropertiesSummary nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public JobSummary build() {
            return new JobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobSummary> {
        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder createdAt(Long var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder statusReason(String var1);

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder container(ContainerSummary var1);

        default public Builder container(Consumer<ContainerSummary.Builder> container) {
            return this.container((ContainerSummary)((ContainerSummary.Builder)ContainerSummary.builder().applyMutation(container)).build());
        }

        public Builder arrayProperties(ArrayPropertiesSummary var1);

        default public Builder arrayProperties(Consumer<ArrayPropertiesSummary.Builder> arrayProperties) {
            return this.arrayProperties((ArrayPropertiesSummary)((ArrayPropertiesSummary.Builder)ArrayPropertiesSummary.builder().applyMutation(arrayProperties)).build());
        }

        public Builder nodeProperties(NodePropertiesSummary var1);

        default public Builder nodeProperties(Consumer<NodePropertiesSummary.Builder> nodeProperties) {
            return this.nodeProperties((NodePropertiesSummary)((NodePropertiesSummary.Builder)NodePropertiesSummary.builder().applyMutation(nodeProperties)).build());
        }

        public Builder jobDefinition(String var1);
    }
}

