/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains overrides for the Kubernetes pod properties of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksPodPropertiesOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<EksPodPropertiesOverride.Builder, EksPodPropertiesOverride> {
    private static final SdkField<List<EksContainerOverride>> CONTAINERS_FIELD = SdkField
            .<List<EksContainerOverride>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(EksPodPropertiesOverride::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksContainerOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksContainerOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EksMetadata> METADATA_FIELD = SdkField.<EksMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("metadata").getter(getter(EksPodPropertiesOverride::metadata)).setter(setter(Builder::metadata))
            .constructor(EksMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD,
            METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EksContainerOverride> containers;

    private final EksMetadata metadata;

    private EksPodPropertiesOverride(BuilderImpl builder) {
        this.containers = builder.containers;
        this.metadata = builder.metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The overrides for the container that's used on the Amazon EKS pod.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The overrides for the container that's used on the Amazon EKS pod.
     */
    public final List<EksContainerOverride> containers() {
        return containers;
    }

    /**
     * Returns the value of the Metadata property for this object.
     * 
     * @return The value of the Metadata property for this object.
     */
    public final EksMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodPropertiesOverride)) {
            return false;
        }
        EksPodPropertiesOverride other = (EksPodPropertiesOverride) obj;
        return hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksPodPropertiesOverride").add("Containers", hasContainers() ? containers() : null)
                .add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksPodPropertiesOverride, T> g) {
        return obj -> g.apply((EksPodPropertiesOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksPodPropertiesOverride> {
        /**
         * <p>
         * The overrides for the container that's used on the Amazon EKS pod.
         * </p>
         * 
         * @param containers
         *        The overrides for the container that's used on the Amazon EKS pod.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<EksContainerOverride> containers);

        /**
         * <p>
         * The overrides for the container that's used on the Amazon EKS pod.
         * </p>
         * 
         * @param containers
         *        The overrides for the container that's used on the Amazon EKS pod.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(EksContainerOverride... containers);

        /**
         * <p>
         * The overrides for the container that's used on the Amazon EKS pod.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EksContainerOverride.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.batch.model.EksContainerOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EksContainerOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<EksContainerOverride>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EksContainerOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<EksContainerOverride>)
         */
        Builder containers(Consumer<EksContainerOverride.Builder>... containers);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * @param metadata
         *        The new value for the Metadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(EksMetadata metadata);

        /**
         * Sets the value of the Metadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EksMetadata.Builder} avoiding the need to
         * create one manually via {@link EksMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksMetadata.Builder#build()} is called immediately and its result
         * is passed to {@link #metadata(EksMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link EksMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(EksMetadata)
         */
        default Builder metadata(Consumer<EksMetadata.Builder> metadata) {
            return metadata(EksMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EksContainerOverride> containers = DefaultSdkAutoConstructList.getInstance();

        private EksMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPodPropertiesOverride model) {
            containers(model.containers);
            metadata(model.metadata);
        }

        public final List<EksContainerOverride.Builder> getContainers() {
            List<EksContainerOverride.Builder> result = EksContainerOverrideListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksContainerOverride.BuilderImpl> containers) {
            this.containers = EksContainerOverrideListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksContainerOverride> containers) {
            this.containers = EksContainerOverrideListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksContainerOverride... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksContainerOverride.Builder>... containers) {
            containers(Stream.of(containers).map(c -> EksContainerOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EksMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(EksMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EksMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public EksPodPropertiesOverride build() {
            return new EksPodPropertiesOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
