/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains overrides for the task definition of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskPropertiesOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskPropertiesOverride.Builder, TaskPropertiesOverride> {
    private static final SdkField<List<TaskContainerOverrides>> CONTAINERS_FIELD = SdkField
            .<List<TaskContainerOverrides>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(TaskPropertiesOverride::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskContainerOverrides> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskContainerOverrides::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TaskContainerOverrides> containers;

    private TaskPropertiesOverride(BuilderImpl builder) {
        this.containers = builder.containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The overrides for the container definition of a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The overrides for the container definition of a job.
     */
    public final List<TaskContainerOverrides> containers() {
        return containers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskPropertiesOverride)) {
            return false;
        }
        TaskPropertiesOverride other = (TaskPropertiesOverride) obj;
        return hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskPropertiesOverride").add("Containers", hasContainers() ? containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskPropertiesOverride, T> g) {
        return obj -> g.apply((TaskPropertiesOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskPropertiesOverride> {
        /**
         * <p>
         * The overrides for the container definition of a job.
         * </p>
         * 
         * @param containers
         *        The overrides for the container definition of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<TaskContainerOverrides> containers);

        /**
         * <p>
         * The overrides for the container definition of a job.
         * </p>
         * 
         * @param containers
         *        The overrides for the container definition of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(TaskContainerOverrides... containers);

        /**
         * <p>
         * The overrides for the container definition of a job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.TaskContainerOverrides.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.batch.model.TaskContainerOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.TaskContainerOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<TaskContainerOverrides>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.TaskContainerOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<TaskContainerOverrides>)
         */
        Builder containers(Consumer<TaskContainerOverrides.Builder>... containers);
    }

    static final class BuilderImpl implements Builder {
        private List<TaskContainerOverrides> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskPropertiesOverride model) {
            containers(model.containers);
        }

        public final List<TaskContainerOverrides.Builder> getContainers() {
            List<TaskContainerOverrides.Builder> result = ListTaskContainerOverridesCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<TaskContainerOverrides.BuilderImpl> containers) {
            this.containers = ListTaskContainerOverridesCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<TaskContainerOverrides> containers) {
            this.containers = ListTaskContainerOverridesCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(TaskContainerOverrides... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<TaskContainerOverrides.Builder>... containers) {
            containers(Stream.of(containers).map(c -> TaskContainerOverrides.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaskPropertiesOverride build() {
            return new TaskPropertiesOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
