/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for <code>UpdateComputeEnvironment</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComputeEnvironmentRequest extends BatchRequest implements
        ToCopyableBuilder<UpdateComputeEnvironmentRequest.Builder, UpdateComputeEnvironmentRequest> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeEnvironment").getter(getter(UpdateComputeEnvironmentRequest::computeEnvironment))
            .setter(setter(Builder::computeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironment").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(UpdateComputeEnvironmentRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Integer> UNMANAGEDV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("unmanagedvCpus").getter(getter(UpdateComputeEnvironmentRequest::unmanagedvCpus))
            .setter(setter(Builder::unmanagedvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmanagedvCpus").build()).build();

    private static final SdkField<ComputeResourceUpdate> COMPUTE_RESOURCES_FIELD = SdkField
            .<ComputeResourceUpdate> builder(MarshallingType.SDK_POJO).memberName("computeResources")
            .getter(getter(UpdateComputeEnvironmentRequest::computeResources)).setter(setter(Builder::computeResources))
            .constructor(ComputeResourceUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeResources").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(UpdateComputeEnvironmentRequest::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<UpdatePolicy> UPDATE_POLICY_FIELD = SdkField.<UpdatePolicy> builder(MarshallingType.SDK_POJO)
            .memberName("updatePolicy").getter(getter(UpdateComputeEnvironmentRequest::updatePolicy))
            .setter(setter(Builder::updatePolicy)).constructor(UpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatePolicy").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("context")
            .getter(getter(UpdateComputeEnvironmentRequest::context)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_ENVIRONMENT_FIELD,
            STATE_FIELD, UNMANAGEDV_CPUS_FIELD, COMPUTE_RESOURCES_FIELD, SERVICE_ROLE_FIELD, UPDATE_POLICY_FIELD, CONTEXT_FIELD));

    private final String computeEnvironment;

    private final String state;

    private final Integer unmanagedvCpus;

    private final ComputeResourceUpdate computeResources;

    private final String serviceRole;

    private final UpdatePolicy updatePolicy;

    private final String context;

    private UpdateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironment = builder.computeEnvironment;
        this.state = builder.state;
        this.unmanagedvCpus = builder.unmanagedvCpus;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
        this.updatePolicy = builder.updatePolicy;
        this.context = builder.context;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the compute environment to update.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the compute environment to update.
     */
    public final String computeEnvironment() {
        return computeEnvironment;
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated job
     * queue on the compute resources within the environment. If the compute environment is managed, then it can scale
     * its instances out or in automatically, based on the job queue demand.
     * </p>
     * <p>
     * If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
     * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed
     * compute environments in the <code>DISABLED</code> state don't scale out.
     * </p>
     * <note>
     * <p>
     * Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
     * additional charges, turn off and then delete the compute environment. For more information, see <a href=
     * "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
     * >State</a> in the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * <p>
     * When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance size
     * doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code> value of
     * <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>. This instance doesn't scale down to a
     * <code>c5.large</code> instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.</p>
     *         <p>
     *         If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an
     *         associated job queue on the compute resources within the environment. If the compute environment is
     *         managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *         </p>
     *         <p>
     *         If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
     *         environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
     *         Managed compute environments in the <code>DISABLED</code> state don't scale out.
     *         </p>
     *         <note>
     *         <p>
     *         Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
     *         additional charges, turn off and then delete the compute environment. For more information, see <a href=
     *         "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
     *         >State</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the
     *         instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a
     *         <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>.
     *         This instance doesn't scale down to a <code>c5.large</code> instance.
     * @see CEState
     */
    public final CEState state() {
        return CEState.fromValue(state);
    }

    /**
     * <p>
     * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from
     * a queue and scale in or out automatically based on the workload demand of its associated queues.
     * </p>
     * <p>
     * If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated job
     * queue on the compute resources within the environment. If the compute environment is managed, then it can scale
     * its instances out or in automatically, based on the job queue demand.
     * </p>
     * <p>
     * If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
     * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed
     * compute environments in the <code>DISABLED</code> state don't scale out.
     * </p>
     * <note>
     * <p>
     * Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
     * additional charges, turn off and then delete the compute environment. For more information, see <a href=
     * "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
     * >State</a> in the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * <p>
     * When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance size
     * doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code> value of
     * <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>. This instance doesn't scale down to a
     * <code>c5.large</code> instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CEState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept
     *         jobs from a queue and scale in or out automatically based on the workload demand of its associated
     *         queues.</p>
     *         <p>
     *         If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an
     *         associated job queue on the compute resources within the environment. If the compute environment is
     *         managed, then it can scale its instances out or in automatically, based on the job queue demand.
     *         </p>
     *         <p>
     *         If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
     *         environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
     *         Managed compute environments in the <code>DISABLED</code> state don't scale out.
     *         </p>
     *         <note>
     *         <p>
     *         Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
     *         additional charges, turn off and then delete the compute environment. For more information, see <a href=
     *         "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
     *         >State</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the
     *         instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a
     *         <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>.
     *         This instance doesn't scale down to a <code>c5.large</code> instance.
     * @see CEState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The maximum number of vCPUs expected to be used for an unmanaged compute environment. Don't specify this
     * parameter for a managed compute environment. This parameter is only used for fair share scheduling to reserve
     * vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU
     * capacity is reserved.
     * </p>
     * 
     * @return The maximum number of vCPUs expected to be used for an unmanaged compute environment. Don't specify this
     *         parameter for a managed compute environment. This parameter is only used for fair share scheduling to
     *         reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job
     *         queue, no vCPU capacity is reserved.
     */
    public final Integer unmanagedvCpus() {
        return unmanagedvCpus;
    }

    /**
     * <p>
     * Details of the compute resources managed by the compute environment. Required for a managed compute environment.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * 
     * @return Details of the compute resources managed by the compute environment. Required for a managed compute
     *         environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         Environments</a> in the <i>Batch User Guide</i>.
     */
    public final ComputeResourceUpdate computeResources() {
        return computeResources;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services
     * services on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM role</a> in the
     * <i>Batch User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If the compute environment has a service-linked role, it can't be changed to use a regular IAM role. Likewise, if
     * the compute environment has a regular IAM role, it can't be changed to use a service-linked role. To update the
     * parameters for the compute environment that require an infrastructure update to change, the
     * <b>AWSServiceRoleForBatch</b> service-linked role must be used. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * </important>
     * <p>
     * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
     * (recommended) or prefix the role name with the path.
     * </p>
     * <note>
     * <p>
     * Depending on how you created your Batch service role, its ARN might contain the <code>service-role</code> path
     * prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the
     * <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your
     * service role when you create compute environments.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web
     *         Services services on your behalf. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM
     *         role</a> in the <i>Batch User Guide</i>.</p> <important>
     *         <p>
     *         If the compute environment has a service-linked role, it can't be changed to use a regular IAM role.
     *         Likewise, if the compute environment has a regular IAM role, it can't be changed to use a service-linked
     *         role. To update the parameters for the compute environment that require an infrastructure update to
     *         change, the <b>AWSServiceRoleForBatch</b> service-linked role must be used. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         If your specified role has a path other than <code>/</code>, then you must either specify the full role
     *         ARN (recommended) or prefix the role name with the path.
     *         </p>
     *         <note>
     *         <p>
     *         Depending on how you created your Batch service role, its ARN might contain the <code>service-role</code>
     *         path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use
     *         the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of
     *         your service role when you create compute environments.
     *         </p>
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Specifies the updated infrastructure update policy for the compute environment. For more information about
     * infrastructure updates, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * 
     * @return Specifies the updated infrastructure update policy for the compute environment. For more information
     *         about infrastructure updates, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     */
    public final UpdatePolicy updatePolicy() {
        return updatePolicy;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String context() {
        return context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironment());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unmanagedvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(updatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(context());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComputeEnvironmentRequest)) {
            return false;
        }
        UpdateComputeEnvironmentRequest other = (UpdateComputeEnvironmentRequest) obj;
        return Objects.equals(computeEnvironment(), other.computeEnvironment())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(unmanagedvCpus(), other.unmanagedvCpus())
                && Objects.equals(computeResources(), other.computeResources())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(updatePolicy(), other.updatePolicy())
                && Objects.equals(context(), other.context());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComputeEnvironmentRequest").add("ComputeEnvironment", computeEnvironment())
                .add("State", stateAsString()).add("UnmanagedvCpus", unmanagedvCpus())
                .add("ComputeResources", computeResources()).add("ServiceRole", serviceRole())
                .add("UpdatePolicy", updatePolicy()).add("Context", context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironment":
            return Optional.ofNullable(clazz.cast(computeEnvironment()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "unmanagedvCpus":
            return Optional.ofNullable(clazz.cast(unmanagedvCpus()));
        case "computeResources":
            return Optional.ofNullable(clazz.cast(computeResources()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "updatePolicy":
            return Optional.ofNullable(clazz.cast(updatePolicy()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateComputeEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateComputeEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateComputeEnvironmentRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * </p>
         * 
         * @param computeEnvironment
         *        The name or full Amazon Resource Name (ARN) of the compute environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * <p>
         * If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated
         * job queue on the compute resources within the environment. If the compute environment is managed, then it can
         * scale its instances out or in automatically, based on the job queue demand.
         * </p>
         * <p>
         * If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
         * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
         * Managed compute environments in the <code>DISABLED</code> state don't scale out.
         * </p>
         * <note>
         * <p>
         * Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
         * additional charges, turn off and then delete the compute environment. For more information, see <a href=
         * "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
         * >State</a> in the <i>Batch User Guide</i>.
         * </p>
         * </note>
         * <p>
         * When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance
         * size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code>
         * value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>. This instance doesn't scale
         * down to a <code>c5.large</code> instance.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.</p>
         *        <p>
         *        If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an
         *        associated job queue on the compute resources within the environment. If the compute environment is
         *        managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *        </p>
         *        <p>
         *        If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within
         *        the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress
         *        normally. Managed compute environments in the <code>DISABLED</code> state don't scale out.
         *        </p>
         *        <note>
         *        <p>
         *        Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To
         *        prevent additional charges, turn off and then delete the compute environment. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
         *        >State</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the
         *        instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a
         *        <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>
         *        . This instance doesn't scale down to a <code>c5.large</code> instance.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs
         * from a queue and scale in or out automatically based on the workload demand of its associated queues.
         * </p>
         * <p>
         * If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated
         * job queue on the compute resources within the environment. If the compute environment is managed, then it can
         * scale its instances out or in automatically, based on the job queue demand.
         * </p>
         * <p>
         * If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within the
         * environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally.
         * Managed compute environments in the <code>DISABLED</code> state don't scale out.
         * </p>
         * <note>
         * <p>
         * Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent
         * additional charges, turn off and then delete the compute environment. For more information, see <a href=
         * "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
         * >State</a> in the <i>Batch User Guide</i>.
         * </p>
         * </note>
         * <p>
         * When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance
         * size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code>
         * value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>. This instance doesn't scale
         * down to a <code>c5.large</code> instance.
         * </p>
         * 
         * @param state
         *        The state of the compute environment. Compute environments in the <code>ENABLED</code> state can
         *        accept jobs from a queue and scale in or out automatically based on the workload demand of its
         *        associated queues.</p>
         *        <p>
         *        If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an
         *        associated job queue on the compute resources within the environment. If the compute environment is
         *        managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *        </p>
         *        <p>
         *        If the state is <code>DISABLED</code>, then the Batch scheduler doesn't attempt to place jobs within
         *        the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress
         *        normally. Managed compute environments in the <code>DISABLED</code> state don't scale out.
         *        </p>
         *        <note>
         *        <p>
         *        Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To
         *        prevent additional charges, turn off and then delete the compute environment. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state"
         *        >State</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the
         *        instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a
         *        <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code>
         *        . This instance doesn't scale down to a <code>c5.large</code> instance.
         * @see CEState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CEState
         */
        Builder state(CEState state);

        /**
         * <p>
         * The maximum number of vCPUs expected to be used for an unmanaged compute environment. Don't specify this
         * parameter for a managed compute environment. This parameter is only used for fair share scheduling to reserve
         * vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU
         * capacity is reserved.
         * </p>
         * 
         * @param unmanagedvCpus
         *        The maximum number of vCPUs expected to be used for an unmanaged compute environment. Don't specify
         *        this parameter for a managed compute environment. This parameter is only used for fair share
         *        scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a
         *        fair share job queue, no vCPU capacity is reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmanagedvCpus(Integer unmanagedvCpus);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. Required for a managed compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param computeResources
         *        Details of the compute resources managed by the compute environment. Required for a managed compute
         *        environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        Environments</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResources(ComputeResourceUpdate computeResources);

        /**
         * <p>
         * Details of the compute resources managed by the compute environment. Required for a managed compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a>
         * in the <i>Batch User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeResourceUpdate.Builder} avoiding
         * the need to create one manually via {@link ComputeResourceUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeResourceUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #computeResources(ComputeResourceUpdate)}.
         * 
         * @param computeResources
         *        a consumer that will call methods on {@link ComputeResourceUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResources(ComputeResourceUpdate)
         */
        default Builder computeResources(Consumer<ComputeResourceUpdate.Builder> computeResources) {
            return computeResources(ComputeResourceUpdate.builder().applyMutation(computeResources).build());
        }

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web
         * Services services on your behalf. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM role</a> in
         * the <i>Batch User Guide</i>.
         * </p>
         * <important>
         * <p>
         * If the compute environment has a service-linked role, it can't be changed to use a regular IAM role.
         * Likewise, if the compute environment has a regular IAM role, it can't be changed to use a service-linked
         * role. To update the parameters for the compute environment that require an infrastructure update to change,
         * the <b>AWSServiceRoleForBatch</b> service-linked role must be used. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * </important>
         * <p>
         * If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN
         * (recommended) or prefix the role name with the path.
         * </p>
         * <note>
         * <p>
         * Depending on how you created your Batch service role, its ARN might contain the <code>service-role</code>
         * path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn't use the
         * <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your
         * service role when you create compute environments.
         * </p>
         * </note>
         * 
         * @param serviceRole
         *        The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon
         *        Web Services services on your behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM
         *        role</a> in the <i>Batch User Guide</i>.</p> <important>
         *        <p>
         *        If the compute environment has a service-linked role, it can't be changed to use a regular IAM role.
         *        Likewise, if the compute environment has a regular IAM role, it can't be changed to use a
         *        service-linked role. To update the parameters for the compute environment that require an
         *        infrastructure update to change, the <b>AWSServiceRoleForBatch</b> service-linked role must be used.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        </important>
         *        <p>
         *        If your specified role has a path other than <code>/</code>, then you must either specify the full
         *        role ARN (recommended) or prefix the role name with the path.
         *        </p>
         *        <note>
         *        <p>
         *        Depending on how you created your Batch service role, its ARN might contain the
         *        <code>service-role</code> path prefix. When you only specify the name of the service role, Batch
         *        assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we
         *        recommend that you specify the full ARN of your service role when you create compute environments.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Specifies the updated infrastructure update policy for the compute environment. For more information about
         * infrastructure updates, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param updatePolicy
         *        Specifies the updated infrastructure update policy for the compute environment. For more information
         *        about infrastructure updates, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatePolicy(UpdatePolicy updatePolicy);

        /**
         * <p>
         * Specifies the updated infrastructure update policy for the compute environment. For more information about
         * infrastructure updates, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdatePolicy.Builder} avoiding the need
         * to create one manually via {@link UpdatePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdatePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #updatePolicy(UpdatePolicy)}.
         * 
         * @param updatePolicy
         *        a consumer that will call methods on {@link UpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updatePolicy(UpdatePolicy)
         */
        default Builder updatePolicy(Consumer<UpdatePolicy.Builder> updatePolicy) {
            return updatePolicy(UpdatePolicy.builder().applyMutation(updatePolicy).build());
        }

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param context
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(String context);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String computeEnvironment;

        private String state;

        private Integer unmanagedvCpus;

        private ComputeResourceUpdate computeResources;

        private String serviceRole;

        private UpdatePolicy updatePolicy;

        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComputeEnvironmentRequest model) {
            super(model);
            computeEnvironment(model.computeEnvironment);
            state(model.state);
            unmanagedvCpus(model.unmanagedvCpus);
            computeResources(model.computeResources);
            serviceRole(model.serviceRole);
            updatePolicy(model.updatePolicy);
            context(model.context);
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Integer getUnmanagedvCpus() {
            return unmanagedvCpus;
        }

        public final void setUnmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
        }

        @Override
        public final Builder unmanagedvCpus(Integer unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        public final ComputeResourceUpdate.Builder getComputeResources() {
            return computeResources != null ? computeResources.toBuilder() : null;
        }

        public final void setComputeResources(ComputeResourceUpdate.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        @Override
        public final Builder computeResources(ComputeResourceUpdate computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final UpdatePolicy.Builder getUpdatePolicy() {
            return updatePolicy != null ? updatePolicy.toBuilder() : null;
        }

        public final void setUpdatePolicy(UpdatePolicy.BuilderImpl updatePolicy) {
            this.updatePolicy = updatePolicy != null ? updatePolicy.build() : null;
        }

        @Override
        public final Builder updatePolicy(UpdatePolicy updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        public final String getContext() {
            return context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComputeEnvironmentRequest build() {
            return new UpdateComputeEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
