/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the attributes of a compute environment that can be updated. For more information, see <a
 * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
 * environments</a> in the <i>Batch User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeResourceUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeResourceUpdate.Builder, ComputeResourceUpdate> {
    private static final SdkField<Integer> MINV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minvCpus").getter(getter(ComputeResourceUpdate::minvCpus)).setter(setter(Builder::minvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minvCpus").build()).build();

    private static final SdkField<Integer> MAXV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxvCpus").getter(getter(ComputeResourceUpdate::maxvCpus)).setter(setter(Builder::maxvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxvCpus").build()).build();

    private static final SdkField<Integer> DESIREDV_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredvCpus").getter(getter(ComputeResourceUpdate::desiredvCpus)).setter(setter(Builder::desiredvCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredvCpus").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(ComputeResourceUpdate::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(ComputeResourceUpdate::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("allocationStrategy").getter(getter(ComputeResourceUpdate::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build())
            .build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceTypes")
            .getter(getter(ComputeResourceUpdate::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EC2_KEY_PAIR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2KeyPair").getter(getter(ComputeResourceUpdate::ec2KeyPair)).setter(setter(Builder::ec2KeyPair))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2KeyPair").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceRole").getter(getter(ComputeResourceUpdate::instanceRole)).setter(setter(Builder::instanceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ComputeResourceUpdate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("placementGroup").getter(getter(ComputeResourceUpdate::placementGroup))
            .setter(setter(Builder::placementGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroup").build()).build();

    private static final SdkField<Integer> BID_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("bidPercentage").getter(getter(ComputeResourceUpdate::bidPercentage))
            .setter(setter(Builder::bidPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bidPercentage").build()).build();

    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<LaunchTemplateSpecification> builder(MarshallingType.SDK_POJO).memberName("launchTemplate")
            .getter(getter(ComputeResourceUpdate::launchTemplate)).setter(setter(Builder::launchTemplate))
            .constructor(LaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchTemplate").build()).build();

    private static final SdkField<List<Ec2Configuration>> EC2_CONFIGURATION_FIELD = SdkField
            .<List<Ec2Configuration>> builder(MarshallingType.LIST)
            .memberName("ec2Configuration")
            .getter(getter(ComputeResourceUpdate::ec2Configuration))
            .setter(setter(Builder::ec2Configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Configuration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Ec2Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Ec2Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> UPDATE_TO_LATEST_IMAGE_VERSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("updateToLatestImageVersion")
            .getter(getter(ComputeResourceUpdate::updateToLatestImageVersion))
            .setter(setter(Builder::updateToLatestImageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateToLatestImageVersion").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ComputeResourceUpdate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageId").getter(getter(ComputeResourceUpdate::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINV_CPUS_FIELD,
            MAXV_CPUS_FIELD, DESIREDV_CPUS_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD, ALLOCATION_STRATEGY_FIELD,
            INSTANCE_TYPES_FIELD, EC2_KEY_PAIR_FIELD, INSTANCE_ROLE_FIELD, TAGS_FIELD, PLACEMENT_GROUP_FIELD,
            BID_PERCENTAGE_FIELD, LAUNCH_TEMPLATE_FIELD, EC2_CONFIGURATION_FIELD, UPDATE_TO_LATEST_IMAGE_VERSION_FIELD,
            TYPE_FIELD, IMAGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("minvCpus", MINV_CPUS_FIELD);
                    put("maxvCpus", MAXV_CPUS_FIELD);
                    put("desiredvCpus", DESIREDV_CPUS_FIELD);
                    put("subnets", SUBNETS_FIELD);
                    put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
                    put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
                    put("instanceTypes", INSTANCE_TYPES_FIELD);
                    put("ec2KeyPair", EC2_KEY_PAIR_FIELD);
                    put("instanceRole", INSTANCE_ROLE_FIELD);
                    put("tags", TAGS_FIELD);
                    put("placementGroup", PLACEMENT_GROUP_FIELD);
                    put("bidPercentage", BID_PERCENTAGE_FIELD);
                    put("launchTemplate", LAUNCH_TEMPLATE_FIELD);
                    put("ec2Configuration", EC2_CONFIGURATION_FIELD);
                    put("updateToLatestImageVersion", UPDATE_TO_LATEST_IMAGE_VERSION_FIELD);
                    put("type", TYPE_FIELD);
                    put("imageId", IMAGE_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer minvCpus;

    private final Integer maxvCpus;

    private final Integer desiredvCpus;

    private final List<String> subnets;

    private final List<String> securityGroupIds;

    private final String allocationStrategy;

    private final List<String> instanceTypes;

    private final String ec2KeyPair;

    private final String instanceRole;

    private final Map<String, String> tags;

    private final String placementGroup;

    private final Integer bidPercentage;

    private final LaunchTemplateSpecification launchTemplate;

    private final List<Ec2Configuration> ec2Configuration;

    private final Boolean updateToLatestImageVersion;

    private final String type;

    private final String imageId;

    private ComputeResourceUpdate(BuilderImpl builder) {
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceTypes = builder.instanceTypes;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.placementGroup = builder.placementGroup;
        this.bidPercentage = builder.bidPercentage;
        this.launchTemplate = builder.launchTemplate;
        this.ec2Configuration = builder.ec2Configuration;
        this.updateToLatestImageVersion = builder.updateToLatestImageVersion;
        this.type = builder.type;
        this.imageId = builder.imageId;
    }

    /**
     * <p>
     * The minimum number of vCPUs that an environment should maintain (even if the compute environment is
     * <code>DISABLED</code>).
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The minimum number of vCPUs that an environment should maintain (even if the compute environment is
     *         <code>DISABLED</code>).</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final Integer minvCpus() {
        return minvCpus;
    }

    /**
     * <p>
     * The maximum number of Amazon EC2 vCPUs that an environment can reach.
     * </p>
     * <note>
     * <p>
     * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and the
     * <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to meet
     * your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single
     * instance.
     * </p>
     * </note>
     * 
     * @return The maximum number of Amazon EC2 vCPUs that an environment can reach.</p> <note>
     *         <p>
     *         With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     *         <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
     *         and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
     *         <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
     *         <code>maxvCpus</code> by more than a single instance.
     *         </p>
     */
    public final Integer maxvCpus() {
        return maxvCpus;
    }

    /**
     * <p>
     * The desired number of vCPUS in the compute environment. Batch modifies this value between the minimum and maximum
     * values based on job queue demand.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note> <note>
     * <p>
     * Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify this
     * parameter for compute environments using Amazon EKS clusters.
     * </p>
     * </note> <note>
     * <p>
     * When you update the <code>desiredvCpus</code> setting, the value must be between the <code>minvCpus</code> and
     * <code>maxvCpus</code> values.
     * </p>
     * <p>
     * Additionally, the updated <code>desiredvCpus</code> value must be greater than or equal to the current
     * <code>desiredvCpus</code> value. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update"
     * >Troubleshooting Batch</a> in the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The desired number of vCPUS in the compute environment. Batch modifies this value between the minimum and
     *         maximum values based on job queue demand.</p> <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     *         </note> <note>
     *         <p>
     *         Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't
     *         specify this parameter for compute environments using Amazon EKS clusters.
     *         </p>
     *         </note> <note>
     *         <p>
     *         When you update the <code>desiredvCpus</code> setting, the value must be between the
     *         <code>minvCpus</code> and <code>maxvCpus</code> values.
     *         </p>
     *         <p>
     *         Additionally, the updated <code>desiredvCpus</code> value must be greater than or equal to the current
     *         <code>desiredvCpus</code> value. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update"
     *         >Troubleshooting Batch</a> in the <i>Batch User Guide</i>.
     *         </p>
     */
    public final Integer desiredvCpus() {
        return desiredvCpus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets.
     * For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't specified and
     * no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC subnets from the
     * compute resource. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <i>Amazon
     * VPC User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
     * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones">
     * Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
     * href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web Services Local
     * Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones">
     * Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the <i>Amazon ECS
     * Developer Guide</i>.
     * </p>
     * <p>
     * Batch on Fargate doesn't currently support Local Zones.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16
     *         subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter
     *         wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes
     *         the VPC subnets from the compute resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the
     *         <i>Amazon VPC User Guide</i>.</p>
     *         <p>
     *         When updating a compute environment, changing the VPC subnets requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones"
     *         > Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
     *         href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web
     *         Services Local Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones"
     *         > Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the
     *         <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         <p>
     *         Batch on Fargate doesn't currently support Local Zones.
     *         </p>
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 security groups that are associated with instances launched in the compute environment. This
     * parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate
     * compute resources, providing an empty list is handled as if this parameter wasn't specified and no change is
     * made. For Amazon EC2 compute resources, providing an empty list removes the security groups from the compute
     * resource.
     * </p>
     * <p>
     * When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure update of
     * the compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The Amazon EC2 security groups that are associated with instances launched in the compute environment.
     *         This parameter is required for Fargate compute resources, where it can contain up to 5 security groups.
     *         For Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified
     *         and no change is made. For Amazon EC2 compute resources, providing an empty list removes the security
     *         groups from the compute resource.</p>
     *         <p>
     *         When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure
     *         update of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The allocation strategy to use for the compute resource if there's not enough instances of the best fitting
     * instance type that can be allocated. This might be because of availability of the instance type in the Region or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
     * limits</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the allocation strategy requires an infrastructure update of the
     * compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when updating a compute
     * environment.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * <dl>
     * <dt>BEST_FIT_PROGRESSIVE</dt>
     * <dd>
     * <p>
     * Batch selects additional instance types that are large enough to meet the requirements of the jobs in the queue.
     * Its preference is for instance types with lower cost vCPUs. If additional instances of the previously selected
     * instance types aren't available, Batch selects new instance types.
     * </p>
     * </dd>
     * <dt>SPOT_CAPACITY_OPTIMIZED</dt>
     * <dd>
     * <p>
     * Batch selects one or more instance types that are large enough to meet the requirements of the jobs in the queue.
     * Its preference is for instance types that are less likely to be interrupted. This allocation strategy is only
     * available for Spot Instance compute resources.
     * </p>
     * </dd>
     * <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
     * <dd>
     * <p>
     * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance
     * pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is
     * only available for Spot Instance compute resources.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and the
     * <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to meet
     * your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link CRUpdateAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The allocation strategy to use for the compute resource if there's not enough instances of the best
     *         fitting instance type that can be allocated. This might be because of availability of the instance type
     *         in the Region or <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
     *         limits</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
     *         strategies</a> in the <i>Batch User Guide</i>.</p>
     *         <p>
     *         When updating a compute environment, changing the allocation strategy requires an infrastructure update
     *         of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when
     *         updating a compute environment.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     *         </note>
     *         <dl>
     *         <dt>BEST_FIT_PROGRESSIVE</dt>
     *         <dd>
     *         <p>
     *         Batch selects additional instance types that are large enough to meet the requirements of the jobs in the
     *         queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the
     *         previously selected instance types aren't available, Batch selects new instance types.
     *         </p>
     *         </dd>
     *         <dt>SPOT_CAPACITY_OPTIMIZED</dt>
     *         <dd>
     *         <p>
     *         Batch selects one or more instance types that are large enough to meet the requirements of the jobs in
     *         the queue. Its preference is for instance types that are less likely to be interrupted. This allocation
     *         strategy is only available for Spot Instance compute resources.
     *         </p>
     *         </dd>
     *         <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
     *         <dd>
     *         <p>
     *         The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot
     *         Instance pools that are the least likely to be interrupted and have the lowest possible price. This
     *         allocation strategy is only available for Spot Instance compute resources.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     *         <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
     *         and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
     *         <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
     *         <code>maxvCpus</code> by more than a single instance.
     * @see CRUpdateAllocationStrategy
     */
    public final CRUpdateAllocationStrategy allocationStrategy() {
        return CRUpdateAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The allocation strategy to use for the compute resource if there's not enough instances of the best fitting
     * instance type that can be allocated. This might be because of availability of the instance type in the Region or
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
     * limits</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the allocation strategy requires an infrastructure update of the
     * compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when updating a compute
     * environment.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * <dl>
     * <dt>BEST_FIT_PROGRESSIVE</dt>
     * <dd>
     * <p>
     * Batch selects additional instance types that are large enough to meet the requirements of the jobs in the queue.
     * Its preference is for instance types with lower cost vCPUs. If additional instances of the previously selected
     * instance types aren't available, Batch selects new instance types.
     * </p>
     * </dd>
     * <dt>SPOT_CAPACITY_OPTIMIZED</dt>
     * <dd>
     * <p>
     * Batch selects one or more instance types that are large enough to meet the requirements of the jobs in the queue.
     * Its preference is for instance types that are less likely to be interrupted. This allocation strategy is only
     * available for Spot Instance compute resources.
     * </p>
     * </dd>
     * <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
     * <dd>
     * <p>
     * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot Instance
     * pools that are the least likely to be interrupted and have the lowest possible price. This allocation strategy is
     * only available for Spot Instance compute resources.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and the
     * <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to meet
     * your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single
     * instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link CRUpdateAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The allocation strategy to use for the compute resource if there's not enough instances of the best
     *         fitting instance type that can be allocated. This might be because of availability of the instance type
     *         in the Region or <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
     *         limits</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
     *         strategies</a> in the <i>Batch User Guide</i>.</p>
     *         <p>
     *         When updating a compute environment, changing the allocation strategy requires an infrastructure update
     *         of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when
     *         updating a compute environment.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     *         </note>
     *         <dl>
     *         <dt>BEST_FIT_PROGRESSIVE</dt>
     *         <dd>
     *         <p>
     *         Batch selects additional instance types that are large enough to meet the requirements of the jobs in the
     *         queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the
     *         previously selected instance types aren't available, Batch selects new instance types.
     *         </p>
     *         </dd>
     *         <dt>SPOT_CAPACITY_OPTIMIZED</dt>
     *         <dd>
     *         <p>
     *         Batch selects one or more instance types that are large enough to meet the requirements of the jobs in
     *         the queue. Its preference is for instance types that are less likely to be interrupted. This allocation
     *         strategy is only available for Spot Instance compute resources.
     *         </p>
     *         </dd>
     *         <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
     *         <dd>
     *         <p>
     *         The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot
     *         Instance pools that are the least likely to be interrupted and have the lowest possible price. This
     *         allocation strategy is only available for Spot Instance compute resources.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
     *         <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
     *         and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
     *         <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
     *         <code>maxvCpus</code> by more than a single instance.
     * @see CRUpdateAllocationStrategy
     */
    public final String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instances types that can be launched. You can specify instance families to launch any instance type within
     * those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific sizes within a
     * family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to select instance types (from
     * the C4, M4, and R4 instance families) that match the demand of your job queues.
     * </p>
     * <p>
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note> <note>
     * <p>
     * When you create a compute environment, the instance types that you select for the compute environment must share
     * the same architecture. For example, you can't mix x86 and ARM instances in the same compute environment.
     * </p>
     * </note> <note>
     * <p>
     * Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions that
     * don't have instance types from those instance families, instance types from the C5, M5, and R5 instance families
     * are used.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypes} method.
     * </p>
     * 
     * @return The instances types that can be launched. You can specify instance families to launch any instance type
     *         within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific
     *         sizes within a family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to
     *         select instance types (from the C4, M4, and R4 instance families) that match the demand of your job
     *         queues.</p>
     *         <p>
     *         When updating a compute environment, changing this setting requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     *         </note> <note>
     *         <p>
     *         When you create a compute environment, the instance types that you select for the compute environment
     *         must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute
     *         environment.
     *         </p>
     *         </note> <note>
     *         <p>
     *         Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions
     *         that don't have instance types from those instance families, instance types from the C5, M5, and R5
     *         instance families are used.
     *         </p>
     */
    public final List<String> instanceTypes() {
        return instanceTypes;
    }

    /**
     * <p>
     * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key pair
     * to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.
     * </p>
     * <p>
     * When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of the
     * compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this
     *         key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an
     *         empty string.</p>
     *         <p>
     *         When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update
     *         of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final String ec2KeyPair() {
        return ec2KeyPair;
    }

    /**
     * <p>
     * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon EC2
     * instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example,
     * <code> <i>ecsInstanceRole</i> </code> or
     * <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For more
     * information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS
     * instance role</a> in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for
     *         Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance
     *         profile. For example, <code> <i>ecsInstanceRole</i> </code> or
     *         <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance
     *         role</a> in the <i>Batch User Guide</i>.</p>
     *         <p>
     *         When updating a compute environment, changing this setting requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final String instanceRole() {
        return instanceRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pair tags to be applied to Amazon EC2 resources that are launched in the compute environment. For
     * Batch, these take the form of <code>"String1": "String2"</code>, where <code>String1</code> is the tag key and
     * <code>String2</code> is the tag value-for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code>. This
     * is helpful for recognizing your Batch instances in the Amazon EC2 console. These tags aren't seen when using the
     * Batch <code>ListTagsForResource</code> API operation.
     * </p>
     * <p>
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pair tags to be applied to Amazon EC2 resources that are launched in the compute environment.
     *         For Batch, these take the form of <code>"String1": "String2"</code>, where <code>String1</code> is the
     *         tag key and <code>String2</code> is the tag value-for example,
     *         <code>{ "Name": "Batch Instance - C4OnDemand" }</code>. This is helpful for recognizing your Batch
     *         instances in the Amazon EC2 console. These tags aren't seen when using the Batch
     *         <code>ListTagsForResource</code> API operation.</p>
     *         <p>
     *         When updating a compute environment, changing this setting requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node
     * parallel jobs to your compute environment, you should consider creating a cluster placement group and associate
     * it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within
     * a single Availability Zone with high network flow potential. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
     * <i>Amazon EC2 User Guide for Linux Instances</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the placement group requires an infrastructure update of the
     * compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The Amazon EC2 placement group to associate with your compute resources. If you intend to submit
     *         multi-node parallel jobs to your compute environment, you should consider creating a cluster placement
     *         group and associate it with your compute resources. This keeps your multi-node parallel job on a logical
     *         grouping of instances within a single Availability Zone with high network flow potential. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in
     *         the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
     *         <p>
     *         When updating a compute environment, changing the placement group requires an infrastructure update of
     *         the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance
     * type before instances are launched. For example, if your maximum percentage is 20%, the Spot price must be less
     * than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price
     * and never more than your maximum percentage. For most use cases, we recommend leaving this field empty.
     * </p>
     * <p>
     * When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that
     *         instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot
     *         price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay
     *         the lowest (market) price and never more than your maximum percentage. For most use cases, we recommend
     *         leaving this field empty.</p>
     *         <p>
     *         When updating a compute environment, changing the bid percentage requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final Integer bidPercentage() {
        return bidPercentage;
    }

    /**
     * <p>
     * The updated launch template to use for your compute resources. You must specify either the launch template ID or
     * launch template name in the request, but not both. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template support</a> in
     * the <i>Batch User Guide</i>. To remove the custom launch template and use the default launch template, set
     * <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the launch template specification to
     * an empty string. Removing the launch template from a compute environment will not remove the AMI specified in the
     * launch template. In order to update the AMI specified in a launch template, the
     * <code>updateToLatestImageVersion</code> parameter must be set to <code>true</code>.
     * </p>
     * <p>
     * When updating a compute environment, changing the launch template requires an infrastructure update of the
     * compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * 
     * @return The updated launch template to use for your compute resources. You must specify either the launch
     *         template ID or launch template name in the request, but not both. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template
     *         support</a> in the <i>Batch User Guide</i>. To remove the custom launch template and use the default
     *         launch template, set <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the
     *         launch template specification to an empty string. Removing the launch template from a compute environment
     *         will not remove the AMI specified in the launch template. In order to update the AMI specified in a
     *         launch template, the <code>updateToLatestImageVersion</code> parameter must be set to <code>true</code>
     *         .</p>
     *         <p>
     *         When updating a compute environment, changing the launch template requires an infrastructure update of
     *         the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final LaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2Configuration() {
        return ec2Configuration != null && !(ec2Configuration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute
     * environment. If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code>.
     * </p>
     * <p>
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and any custom AMI ID
     * specified in <code>imageIdOverride</code>, set this value to an empty string.
     * </p>
     * <p>
     * One or two values can be provided.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2Configuration} method.
     * </p>
     * 
     * @return Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute
     *         environment. If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code>.</p>
     *         <p>
     *         When updating a compute environment, changing this setting requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and any
     *         custom AMI ID specified in <code>imageIdOverride</code>, set this value to an empty string.
     *         </p>
     *         <p>
     *         One or two values can be provided.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     */
    public final List<Ec2Configuration> ec2Configuration() {
        return ec2Configuration;
    }

    /**
     * <p>
     * Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute environment
     * has an infrastructure update. The default value is <code>false</code>.
     * </p>
     * <note>
     * <p>
     * An AMI ID can either be specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or be
     * determined by the launch template that's specified in the <code>launchTemplate</code> parameter. If an AMI ID is
     * specified any of these ways, this parameter is ignored. For more information about to update AMI IDs during an
     * infrastructure update, see <a href=
     * "https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami"
     * >Updating the AMI ID</a> in the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * <p>
     * When updating a compute environment, changing this setting requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute
     *         environment has an infrastructure update. The default value is <code>false</code>.</p> <note>
     *         <p>
     *         An AMI ID can either be specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters
     *         or be determined by the launch template that's specified in the <code>launchTemplate</code> parameter. If
     *         an AMI ID is specified any of these ways, this parameter is ignored. For more information about to update
     *         AMI IDs during an infrastructure update, see <a href=
     *         "https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami"
     *         >Updating the AMI ID</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         When updating a compute environment, changing this setting requires an infrastructure update of the
     *         compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     */
    public final Boolean updateToLatestImageVersion() {
        return updateToLatestImageVersion;
    }

    /**
     * <p>
     * The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
     * <code>FARGATE_SPOT</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
     * <code>spotIamFleetRole</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a>
     * in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the type of a compute environment requires an infrastructure update
     * of the compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
     *         <code>FARGATE_SPOT</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         environments</a> in the <i>Batch User Guide</i>.</p>
     *         <p>
     *         If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
     *         <code>spotIamFleetRole</code> parameter. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet
     *         role</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <p>
     *         When updating a compute environment, changing the type of a compute environment requires an
     *         infrastructure update of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     * @see CRType
     */
    public final CRType type() {
        return CRType.fromValue(type);
    }

    /**
     * <p>
     * The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
     * <code>FARGATE_SPOT</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
     * <code>spotIamFleetRole</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a>
     * in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * When updating a compute environment, changing the type of a compute environment requires an infrastructure update
     * of the compute environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
     *         <code>FARGATE_SPOT</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
     *         environments</a> in the <i>Batch User Guide</i>.</p>
     *         <p>
     *         If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
     *         <code>spotIamFleetRole</code> parameter. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet
     *         role</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <p>
     *         When updating a compute environment, changing the type of a compute environment requires an
     *         infrastructure update of the compute environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     * @see CRType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is
     * overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure. To remove
     * the custom AMI ID and use the default AMI ID, set this value to an empty string.
     * </p>
     * <p>
     * When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute
     * environment. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
     * environments</a> in the <i>Batch User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     * </p>
     * </note> <note>
     * <p>
     * The AMI that you choose for a compute environment must match the architecture of the instance types that you
     * intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the
     * compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of
     * the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html"
     * >Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </note>
     * 
     * @return The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter
     *         is overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure.
     *         To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.</p>
     *         <p>
     *         When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute
     *         environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
     *         compute environments</a> in the <i>Batch User Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
     *         </p>
     *         </note> <note>
     *         <p>
     *         The AMI that you choose for a compute environment must match the architecture of the instance types that
     *         you intend to use for that compute environment. For example, if your compute environment uses A1 instance
     *         types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and
     *         ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html"
     *         >Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     *         </p>
     */
    public final String imageId() {
        return imageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(desiredvCpus());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ec2KeyPair());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(bidPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2Configuration() ? ec2Configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateToLatestImageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResourceUpdate)) {
            return false;
        }
        ComputeResourceUpdate other = (ComputeResourceUpdate) obj;
        return Objects.equals(minvCpus(), other.minvCpus()) && Objects.equals(maxvCpus(), other.maxvCpus())
                && Objects.equals(desiredvCpus(), other.desiredvCpus()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(ec2KeyPair(), other.ec2KeyPair()) && Objects.equals(instanceRole(), other.instanceRole())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(placementGroup(), other.placementGroup())
                && Objects.equals(bidPercentage(), other.bidPercentage())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && hasEc2Configuration() == other.hasEc2Configuration()
                && Objects.equals(ec2Configuration(), other.ec2Configuration())
                && Objects.equals(updateToLatestImageVersion(), other.updateToLatestImageVersion())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(imageId(), other.imageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeResourceUpdate").add("MinvCpus", minvCpus()).add("MaxvCpus", maxvCpus())
                .add("DesiredvCpus", desiredvCpus()).add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("AllocationStrategy", allocationStrategyAsString())
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null).add("Ec2KeyPair", ec2KeyPair())
                .add("InstanceRole", instanceRole()).add("Tags", hasTags() ? tags() : null)
                .add("PlacementGroup", placementGroup()).add("BidPercentage", bidPercentage())
                .add("LaunchTemplate", launchTemplate())
                .add("Ec2Configuration", hasEc2Configuration() ? ec2Configuration() : null)
                .add("UpdateToLatestImageVersion", updateToLatestImageVersion()).add("Type", typeAsString())
                .add("ImageId", imageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minvCpus":
            return Optional.ofNullable(clazz.cast(minvCpus()));
        case "maxvCpus":
            return Optional.ofNullable(clazz.cast(maxvCpus()));
        case "desiredvCpus":
            return Optional.ofNullable(clazz.cast(desiredvCpus()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "allocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "instanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "ec2KeyPair":
            return Optional.ofNullable(clazz.cast(ec2KeyPair()));
        case "instanceRole":
            return Optional.ofNullable(clazz.cast(instanceRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "placementGroup":
            return Optional.ofNullable(clazz.cast(placementGroup()));
        case "bidPercentage":
            return Optional.ofNullable(clazz.cast(bidPercentage()));
        case "launchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "ec2Configuration":
            return Optional.ofNullable(clazz.cast(ec2Configuration()));
        case "updateToLatestImageVersion":
            return Optional.ofNullable(clazz.cast(updateToLatestImageVersion()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComputeResourceUpdate, T> g) {
        return obj -> g.apply((ComputeResourceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeResourceUpdate> {
        /**
         * <p>
         * The minimum number of vCPUs that an environment should maintain (even if the compute environment is
         * <code>DISABLED</code>).
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param minvCpus
         *        The minimum number of vCPUs that an environment should maintain (even if the compute environment is
         *        <code>DISABLED</code>).</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minvCpus(Integer minvCpus);

        /**
         * <p>
         * The maximum number of Amazon EC2 vCPUs that an environment can reach.
         * </p>
         * <note>
         * <p>
         * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and
         * the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to
         * meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a
         * single instance.
         * </p>
         * </note>
         * 
         * @param maxvCpus
         *        The maximum number of Amazon EC2 vCPUs that an environment can reach.</p> <note>
         *        <p>
         *        With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         *        <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
         *        and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
         *        <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
         *        <code>maxvCpus</code> by more than a single instance.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxvCpus(Integer maxvCpus);

        /**
         * <p>
         * The desired number of vCPUS in the compute environment. Batch modifies this value between the minimum and
         * maximum values based on job queue demand.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> <note>
         * <p>
         * Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't specify
         * this parameter for compute environments using Amazon EKS clusters.
         * </p>
         * </note> <note>
         * <p>
         * When you update the <code>desiredvCpus</code> setting, the value must be between the <code>minvCpus</code>
         * and <code>maxvCpus</code> values.
         * </p>
         * <p>
         * Additionally, the updated <code>desiredvCpus</code> value must be greater than or equal to the current
         * <code>desiredvCpus</code> value. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update"
         * >Troubleshooting Batch</a> in the <i>Batch User Guide</i>.
         * </p>
         * </note>
         * 
         * @param desiredvCpus
         *        The desired number of vCPUS in the compute environment. Batch modifies this value between the minimum
         *        and maximum values based on job queue demand.</p> <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note> <note>
         *        <p>
         *        Batch doesn't support changing the desired number of vCPUs of an existing compute environment. Don't
         *        specify this parameter for compute environments using Amazon EKS clusters.
         *        </p>
         *        </note> <note>
         *        <p>
         *        When you update the <code>desiredvCpus</code> setting, the value must be between the
         *        <code>minvCpus</code> and <code>maxvCpus</code> values.
         *        </p>
         *        <p>
         *        Additionally, the updated <code>desiredvCpus</code> value must be greater than or equal to the current
         *        <code>desiredvCpus</code> value. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#error-desired-vcpus-update"
         *        >Troubleshooting Batch</a> in the <i>Batch User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredvCpus(Integer desiredvCpus);

        /**
         * <p>
         * The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16
         * subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't
         * specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC
         * subnets from the compute resource. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the
         * <i>Amazon VPC User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones"
         * > Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web Services
         * Local Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones"
         * > Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the <i>Amazon
         * ECS Developer Guide</i>.
         * </p>
         * <p>
         * Batch on Fargate doesn't currently support Local Zones.
         * </p>
         * </note>
         * 
         * @param subnets
         *        The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to
         *        16 subnets. For Fargate compute resources, providing an empty list will be handled as if this
         *        parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty
         *        list removes the VPC subnets from the compute resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the
         *        <i>Amazon VPC User Guide</i>.</p>
         *        <p>
         *        When updating a compute environment, changing the VPC subnets requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones"
         *        > Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web
         *        Services Local Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones"
         *        > Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the
         *        <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        <p>
         *        Batch on Fargate doesn't currently support Local Zones.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16
         * subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn't
         * specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the VPC
         * subnets from the compute resource. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the
         * <i>Amazon VPC User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the VPC subnets requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones"
         * > Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
         * href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web Services
         * Local Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones"
         * > Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the <i>Amazon
         * ECS Developer Guide</i>.
         * </p>
         * <p>
         * Batch on Fargate doesn't currently support Local Zones.
         * </p>
         * </note>
         * 
         * @param subnets
         *        The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to
         *        16 subnets. For Fargate compute resources, providing an empty list will be handled as if this
         *        parameter wasn't specified and no change is made. For Amazon EC2 compute resources, providing an empty
         *        list removes the VPC subnets from the compute resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the
         *        <i>Amazon VPC User Guide</i>.</p>
         *        <p>
         *        When updating a compute environment, changing the VPC subnets requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        Batch on Amazon EC2 and Batch on Amazon EKS support Local Zones. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-local-zones"
         *        > Local Zones</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>, <a
         *        href="https://docs.aws.amazon.com/eks/latest/userguide/local-zones.html">Amazon EKS and Amazon Web
         *        Services Local Zones</a> in the <i>Amazon EKS User Guide</i> and <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-regions-zones.html#clusters-local-zones"
         *        > Amazon ECS clusters in Local Zones, Wavelength Zones, and Amazon Web Services Outposts</a> in the
         *        <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        <p>
         *        Batch on Fargate doesn't currently support Local Zones.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The Amazon EC2 security groups that are associated with instances launched in the compute environment. This
         * parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For
         * Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no
         * change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from
         * the compute resource.
         * </p>
         * <p>
         * When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure
         * update of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param securityGroupIds
         *        The Amazon EC2 security groups that are associated with instances launched in the compute environment.
         *        This parameter is required for Fargate compute resources, where it can contain up to 5 security
         *        groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't
         *        specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the
         *        security groups from the compute resource.</p>
         *        <p>
         *        When updating a compute environment, changing the Amazon EC2 security groups requires an
         *        infrastructure update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The Amazon EC2 security groups that are associated with instances launched in the compute environment. This
         * parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For
         * Fargate compute resources, providing an empty list is handled as if this parameter wasn't specified and no
         * change is made. For Amazon EC2 compute resources, providing an empty list removes the security groups from
         * the compute resource.
         * </p>
         * <p>
         * When updating a compute environment, changing the Amazon EC2 security groups requires an infrastructure
         * update of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param securityGroupIds
         *        The Amazon EC2 security groups that are associated with instances launched in the compute environment.
         *        This parameter is required for Fargate compute resources, where it can contain up to 5 security
         *        groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn't
         *        specified and no change is made. For Amazon EC2 compute resources, providing an empty list removes the
         *        security groups from the compute resource.</p>
         *        <p>
         *        When updating a compute environment, changing the Amazon EC2 security groups requires an
         *        infrastructure update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The allocation strategy to use for the compute resource if there's not enough instances of the best fitting
         * instance type that can be allocated. This might be because of availability of the instance type in the Region
         * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
         * limits</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
         * strategies</a> in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the allocation strategy requires an infrastructure update of
         * the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when updating a
         * compute environment.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * <dl>
         * <dt>BEST_FIT_PROGRESSIVE</dt>
         * <dd>
         * <p>
         * Batch selects additional instance types that are large enough to meet the requirements of the jobs in the
         * queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the previously
         * selected instance types aren't available, Batch selects new instance types.
         * </p>
         * </dd>
         * <dt>SPOT_CAPACITY_OPTIMIZED</dt>
         * <dd>
         * <p>
         * Batch selects one or more instance types that are large enough to meet the requirements of the jobs in the
         * queue. Its preference is for instance types that are less likely to be interrupted. This allocation strategy
         * is only available for Spot Instance compute resources.
         * </p>
         * </dd>
         * <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
         * <dd>
         * <p>
         * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot
         * Instance pools that are the least likely to be interrupted and have the lowest possible price. This
         * allocation strategy is only available for Spot Instance compute resources.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and
         * the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to
         * meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a
         * single instance.
         * </p>
         * 
         * @param allocationStrategy
         *        The allocation strategy to use for the compute resource if there's not enough instances of the best
         *        fitting instance type that can be allocated. This might be because of availability of the instance
         *        type in the Region or <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
         *        limits</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
         *        strategies</a> in the <i>Batch User Guide</i>.</p>
         *        <p>
         *        When updating a compute environment, changing the allocation strategy requires an infrastructure
         *        update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when
         *        updating a compute environment.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>BEST_FIT_PROGRESSIVE</dt>
         *        <dd>
         *        <p>
         *        Batch selects additional instance types that are large enough to meet the requirements of the jobs in
         *        the queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the
         *        previously selected instance types aren't available, Batch selects new instance types.
         *        </p>
         *        </dd>
         *        <dt>SPOT_CAPACITY_OPTIMIZED</dt>
         *        <dd>
         *        <p>
         *        Batch selects one or more instance types that are large enough to meet the requirements of the jobs in
         *        the queue. Its preference is for instance types that are less likely to be interrupted. This
         *        allocation strategy is only available for Spot Instance compute resources.
         *        </p>
         *        </dd>
         *        <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
         *        <dd>
         *        <p>
         *        The price and capacity optimized allocation strategy looks at both price and capacity to select the
         *        Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
         *        This allocation strategy is only available for Spot Instance compute resources.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         *        <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
         *        and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
         *        <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
         *        <code>maxvCpus</code> by more than a single instance.
         * @see CRUpdateAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRUpdateAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The allocation strategy to use for the compute resource if there's not enough instances of the best fitting
         * instance type that can be allocated. This might be because of availability of the instance type in the Region
         * or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
         * limits</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
         * strategies</a> in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the allocation strategy requires an infrastructure update of
         * the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when updating a
         * compute environment.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * <dl>
         * <dt>BEST_FIT_PROGRESSIVE</dt>
         * <dd>
         * <p>
         * Batch selects additional instance types that are large enough to meet the requirements of the jobs in the
         * queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the previously
         * selected instance types aren't available, Batch selects new instance types.
         * </p>
         * </dd>
         * <dt>SPOT_CAPACITY_OPTIMIZED</dt>
         * <dd>
         * <p>
         * Batch selects one or more instance types that are large enough to meet the requirements of the jobs in the
         * queue. Its preference is for instance types that are less likely to be interrupted. This allocation strategy
         * is only available for Spot Instance compute resources.
         * </p>
         * </dd>
         * <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
         * <dd>
         * <p>
         * The price and capacity optimized allocation strategy looks at both price and capacity to select the Spot
         * Instance pools that are the least likely to be interrupted and have the lowest possible price. This
         * allocation strategy is only available for Spot Instance compute resources.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         * <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances, and
         * the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed <code>maxvCpus</code> to
         * meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a
         * single instance.
         * </p>
         * 
         * @param allocationStrategy
         *        The allocation strategy to use for the compute resource if there's not enough instances of the best
         *        fitting instance type that can be allocated. This might be because of availability of the instance
         *        type in the Region or <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service
         *        limits</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation
         *        strategies</a> in the <i>Batch User Guide</i>.</p>
         *        <p>
         *        When updating a compute environment, changing the allocation strategy requires an infrastructure
         *        update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn't supported when
         *        updating a compute environment.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>BEST_FIT_PROGRESSIVE</dt>
         *        <dd>
         *        <p>
         *        Batch selects additional instance types that are large enough to meet the requirements of the jobs in
         *        the queue. Its preference is for instance types with lower cost vCPUs. If additional instances of the
         *        previously selected instance types aren't available, Batch selects new instance types.
         *        </p>
         *        </dd>
         *        <dt>SPOT_CAPACITY_OPTIMIZED</dt>
         *        <dd>
         *        <p>
         *        Batch selects one or more instance types that are large enough to meet the requirements of the jobs in
         *        the queue. Its preference is for instance types that are less likely to be interrupted. This
         *        allocation strategy is only available for Spot Instance compute resources.
         *        </p>
         *        </dd>
         *        <dt>SPOT_PRICE_CAPACITY_OPTIMIZED</dt>
         *        <dd>
         *        <p>
         *        The price and capacity optimized allocation strategy looks at both price and capacity to select the
         *        Spot Instance pools that are the least likely to be interrupted and have the lowest possible price.
         *        This allocation strategy is only available for Spot Instance compute resources.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        With <code>BEST_FIT_PROGRESSIVE</code>,<code>SPOT_CAPACITY_OPTIMIZED</code> and
         *        <code>SPOT_PRICE_CAPACITY_OPTIMIZED</code> (recommended) strategies using On-Demand or Spot Instances,
         *        and the <code>BEST_FIT</code> strategy using Spot Instances, Batch might need to exceed
         *        <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds
         *        <code>maxvCpus</code> by more than a single instance.
         * @see CRUpdateAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRUpdateAllocationStrategy
         */
        Builder allocationStrategy(CRUpdateAllocationStrategy allocationStrategy);

        /**
         * <p>
         * The instances types that can be launched. You can specify instance families to launch any instance type
         * within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific sizes
         * within a family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to select
         * instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> <note>
         * <p>
         * When you create a compute environment, the instance types that you select for the compute environment must
         * share the same architecture. For example, you can't mix x86 and ARM instances in the same compute
         * environment.
         * </p>
         * </note> <note>
         * <p>
         * Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions
         * that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance
         * families are used.
         * </p>
         * </note>
         * 
         * @param instanceTypes
         *        The instances types that can be launched. You can specify instance families to launch any instance
         *        type within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify
         *        specific sizes within a family (such as <code>c5.8xlarge</code>). You can also choose
         *        <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match
         *        the demand of your job queues.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note> <note>
         *        <p>
         *        When you create a compute environment, the instance types that you select for the compute environment
         *        must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute
         *        environment.
         *        </p>
         *        </note> <note>
         *        <p>
         *        Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In
         *        Regions that don't have instance types from those instance families, instance types from the C5, M5,
         *        and R5 instance families are used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<String> instanceTypes);

        /**
         * <p>
         * The instances types that can be launched. You can specify instance families to launch any instance type
         * within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific sizes
         * within a family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to select
         * instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> <note>
         * <p>
         * When you create a compute environment, the instance types that you select for the compute environment must
         * share the same architecture. For example, you can't mix x86 and ARM instances in the same compute
         * environment.
         * </p>
         * </note> <note>
         * <p>
         * Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions
         * that don't have instance types from those instance families, instance types from the C5, M5, and R5 instance
         * families are used.
         * </p>
         * </note>
         * 
         * @param instanceTypes
         *        The instances types that can be launched. You can specify instance families to launch any instance
         *        type within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify
         *        specific sizes within a family (such as <code>c5.8xlarge</code>). You can also choose
         *        <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match
         *        the demand of your job queues.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note> <note>
         *        <p>
         *        When you create a compute environment, the instance types that you select for the compute environment
         *        must share the same architecture. For example, you can't mix x86 and ARM instances in the same compute
         *        environment.
         *        </p>
         *        </note> <note>
         *        <p>
         *        Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In
         *        Regions that don't have instance types from those instance families, instance types from the C5, M5,
         *        and R5 instance families are used.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(String... instanceTypes);

        /**
         * <p>
         * The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use this key
         * pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty
         * string.
         * </p>
         * <p>
         * When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure update of
         * the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param ec2KeyPair
         *        The Amazon EC2 key pair that's used for instances launched in the compute environment. You can use
         *        this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value
         *        to an empty string.</p>
         *        <p>
         *        When updating a compute environment, changing the Amazon EC2 key pair requires an infrastructure
         *        update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2KeyPair(String ec2KeyPair);

        /**
         * <p>
         * The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for Amazon
         * EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For
         * example, <code> <i>ecsInstanceRole</i> </code> or
         * <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For more
         * information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon
         * ECS instance role</a> in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param instanceRole
         *        The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. Required for
         *        Amazon EC2 instances. You can specify the short name or full Amazon Resource Name (ARN) of an instance
         *        profile. For example, <code> <i>ecsInstanceRole</i> </code> or
         *        <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance
         *        role</a> in the <i>Batch User Guide</i>.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRole(String instanceRole);

        /**
         * <p>
         * Key-value pair tags to be applied to Amazon EC2 resources that are launched in the compute environment. For
         * Batch, these take the form of <code>"String1": "String2"</code>, where <code>String1</code> is the tag key
         * and <code>String2</code> is the tag value-for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code>
         * . This is helpful for recognizing your Batch instances in the Amazon EC2 console. These tags aren't seen when
         * using the Batch <code>ListTagsForResource</code> API operation.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param tags
         *        Key-value pair tags to be applied to Amazon EC2 resources that are launched in the compute
         *        environment. For Batch, these take the form of <code>"String1": "String2"</code>, where
         *        <code>String1</code> is the tag key and <code>String2</code> is the tag value-for example,
         *        <code>{ "Name": "Batch Instance - C4OnDemand" }</code>. This is helpful for recognizing your Batch
         *        instances in the Amazon EC2 console. These tags aren't seen when using the Batch
         *        <code>ListTagsForResource</code> API operation.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node
         * parallel jobs to your compute environment, you should consider creating a cluster placement group and
         * associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of
         * instances within a single Availability Zone with high network flow potential. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the
         * <i>Amazon EC2 User Guide for Linux Instances</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the placement group requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param placementGroup
         *        The Amazon EC2 placement group to associate with your compute resources. If you intend to submit
         *        multi-node parallel jobs to your compute environment, you should consider creating a cluster placement
         *        group and associate it with your compute resources. This keeps your multi-node parallel job on a
         *        logical grouping of instances within a single Availability Zone with high network flow potential. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a>
         *        in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
         *        <p>
         *        When updating a compute environment, changing the placement group requires an infrastructure update of
         *        the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that
         * instance type before instances are launched. For example, if your maximum percentage is 20%, the Spot price
         * must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest
         * (market) price and never more than your maximum percentage. For most use cases, we recommend leaving this
         * field empty.
         * </p>
         * <p>
         * When updating a compute environment, changing the bid percentage requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param bidPercentage
         *        The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for
         *        that instance type before instances are launched. For example, if your maximum percentage is 20%, the
         *        Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You
         *        always pay the lowest (market) price and never more than your maximum percentage. For most use cases,
         *        we recommend leaving this field empty.</p>
         *        <p>
         *        When updating a compute environment, changing the bid percentage requires an infrastructure update of
         *        the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bidPercentage(Integer bidPercentage);

        /**
         * <p>
         * The updated launch template to use for your compute resources. You must specify either the launch template ID
         * or launch template name in the request, but not both. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template support</a>
         * in the <i>Batch User Guide</i>. To remove the custom launch template and use the default launch template, set
         * <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the launch template specification
         * to an empty string. Removing the launch template from a compute environment will not remove the AMI specified
         * in the launch template. In order to update the AMI specified in a launch template, the
         * <code>updateToLatestImageVersion</code> parameter must be set to <code>true</code>.
         * </p>
         * <p>
         * When updating a compute environment, changing the launch template requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param launchTemplate
         *        The updated launch template to use for your compute resources. You must specify either the launch
         *        template ID or launch template name in the request, but not both. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template
         *        support</a> in the <i>Batch User Guide</i>. To remove the custom launch template and use the default
         *        launch template, set <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the
         *        launch template specification to an empty string. Removing the launch template from a compute
         *        environment will not remove the AMI specified in the launch template. In order to update the AMI
         *        specified in a launch template, the <code>updateToLatestImageVersion</code> parameter must be set to
         *        <code>true</code>.</p>
         *        <p>
         *        When updating a compute environment, changing the launch template requires an infrastructure update of
         *        the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(LaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The updated launch template to use for your compute resources. You must specify either the launch template ID
         * or launch template name in the request, but not both. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template support</a>
         * in the <i>Batch User Guide</i>. To remove the custom launch template and use the default launch template, set
         * <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the launch template specification
         * to an empty string. Removing the launch template from a compute environment will not remove the AMI specified
         * in the launch template. In order to update the AMI specified in a launch template, the
         * <code>updateToLatestImageVersion</code> parameter must be set to <code>true</code>.
         * </p>
         * <p>
         * When updating a compute environment, changing the launch template requires an infrastructure update of the
         * compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link LaunchTemplateSpecification.Builder} avoiding the need to create one manually via
         * {@link LaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplate(LaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on {@link LaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(LaunchTemplateSpecification)
         */
        default Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(LaunchTemplateSpecification.builder().applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute
         * environment. If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code>.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and any custom AMI ID
         * specified in <code>imageIdOverride</code>, set this value to an empty string.
         * </p>
         * <p>
         * One or two values can be provided.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param ec2Configuration
         *        Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the
         *        compute environment. If <code>Ec2Configuration</code> isn't specified, the default is
         *        <code>ECS_AL2</code>.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and
         *        any custom AMI ID specified in <code>imageIdOverride</code>, set this value to an empty string.
         *        </p>
         *        <p>
         *        One or two values can be provided.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Configuration(Collection<Ec2Configuration> ec2Configuration);

        /**
         * <p>
         * Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute
         * environment. If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code>.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and any custom AMI ID
         * specified in <code>imageIdOverride</code>, set this value to an empty string.
         * </p>
         * <p>
         * One or two values can be provided.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note>
         * 
         * @param ec2Configuration
         *        Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the
         *        compute environment. If <code>Ec2Configuration</code> isn't specified, the default is
         *        <code>ECS_AL2</code>.</p>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and
         *        any custom AMI ID specified in <code>imageIdOverride</code>, set this value to an empty string.
         *        </p>
         *        <p>
         *        One or two values can be provided.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Configuration(Ec2Configuration... ec2Configuration);

        /**
         * <p>
         * Provides information used to select Amazon Machine Images (AMIs) for Amazon EC2 instances in the compute
         * environment. If <code>Ec2Configuration</code> isn't specified, the default is <code>ECS_AL2</code>.
         * </p>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>. To remove the Amazon EC2 configuration and any custom AMI ID
         * specified in <code>imageIdOverride</code>, set this value to an empty string.
         * </p>
         * <p>
         * One or two values can be provided.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.Ec2Configuration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.Ec2Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.Ec2Configuration.Builder#build()} is called immediately
         * and its result is passed to {@link #ec2Configuration(List<Ec2Configuration>)}.
         * 
         * @param ec2Configuration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.Ec2Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Configuration(java.util.Collection<Ec2Configuration>)
         */
        Builder ec2Configuration(Consumer<Ec2Configuration.Builder>... ec2Configuration);

        /**
         * <p>
         * Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute
         * environment has an infrastructure update. The default value is <code>false</code>.
         * </p>
         * <note>
         * <p>
         * An AMI ID can either be specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or
         * be determined by the launch template that's specified in the <code>launchTemplate</code> parameter. If an AMI
         * ID is specified any of these ways, this parameter is ignored. For more information about to update AMI IDs
         * during an infrastructure update, see <a href=
         * "https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami"
         * >Updating the AMI ID</a> in the <i>Batch User Guide</i>.
         * </p>
         * </note>
         * <p>
         * When updating a compute environment, changing this setting requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param updateToLatestImageVersion
         *        Specifies whether the AMI ID is updated to the latest one that's supported by Batch when the compute
         *        environment has an infrastructure update. The default value is <code>false</code>.</p> <note>
         *        <p>
         *        An AMI ID can either be specified in the <code>imageId</code> or <code>imageIdOverride</code>
         *        parameters or be determined by the launch template that's specified in the <code>launchTemplate</code>
         *        parameter. If an AMI ID is specified any of these ways, this parameter is ignored. For more
         *        information about to update AMI IDs during an infrastructure update, see <a href=
         *        "https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami"
         *        >Updating the AMI ID</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        When updating a compute environment, changing this setting requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateToLatestImageVersion(Boolean updateToLatestImageVersion);

        /**
         * <p>
         * The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
         * <code>FARGATE_SPOT</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a>
         * in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
         * <code>spotIamFleetRole</code> parameter. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet
         * role</a> in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the type of a compute environment requires an infrastructure
         * update of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
         *        <code>FARGATE_SPOT</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        environments</a> in the <i>Batch User Guide</i>.</p>
         *        <p>
         *        If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
         *        <code>spotIamFleetRole</code> parameter. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot
         *        fleet role</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <p>
         *        When updating a compute environment, changing the type of a compute environment requires an
         *        infrastructure update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @see CRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
         * <code>FARGATE_SPOT</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a>
         * in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
         * <code>spotIamFleetRole</code> parameter. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet
         * role</a> in the <i>Batch User Guide</i>.
         * </p>
         * <p>
         * When updating a compute environment, changing the type of a compute environment requires an infrastructure
         * update of the compute environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or
         *        <code>FARGATE_SPOT</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute
         *        environments</a> in the <i>Batch User Guide</i>.</p>
         *        <p>
         *        If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the
         *        <code>spotIamFleetRole</code> parameter. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot
         *        fleet role</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <p>
         *        When updating a compute environment, changing the type of a compute environment requires an
         *        infrastructure update of the compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         * @see CRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRType
         */
        Builder type(CRType type);

        /**
         * <p>
         * The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is
         * overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure. To
         * remove the custom AMI ID and use the default AMI ID, set this value to an empty string.
         * </p>
         * <p>
         * When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute
         * environment. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute
         * environments</a> in the <i>Batch User Guide</i>.
         * </p>
         * <note>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         * </p>
         * </note> <note>
         * <p>
         * The AMI that you choose for a compute environment must match the architecture of the instance types that you
         * intend to use for that compute environment. For example, if your compute environment uses A1 instance types,
         * the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM
         * versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html"
         * >Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param imageId
         *        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This
         *        parameter is overridden by the <code>imageIdOverride</code> member of the
         *        <code>Ec2Configuration</code> structure. To remove the custom AMI ID and use the default AMI ID, set
         *        this value to an empty string.</p>
         *        <p>
         *        When updating a compute environment, changing the AMI ID requires an infrastructure update of the
         *        compute environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating
         *        compute environments</a> in the <i>Batch User Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        This parameter isn't applicable to jobs that are running on Fargate resources. Don't specify it.
         *        </p>
         *        </note> <note>
         *        <p>
         *        The AMI that you choose for a compute environment must match the architecture of the instance types
         *        that you intend to use for that compute environment. For example, if your compute environment uses A1
         *        instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends
         *        both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html"
         *        >Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer
         *        Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);
    }

    static final class BuilderImpl implements Builder {
        private Integer minvCpus;

        private Integer maxvCpus;

        private Integer desiredvCpus;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String allocationStrategy;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String ec2KeyPair;

        private String instanceRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String placementGroup;

        private Integer bidPercentage;

        private LaunchTemplateSpecification launchTemplate;

        private List<Ec2Configuration> ec2Configuration = DefaultSdkAutoConstructList.getInstance();

        private Boolean updateToLatestImageVersion;

        private String type;

        private String imageId;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResourceUpdate model) {
            minvCpus(model.minvCpus);
            maxvCpus(model.maxvCpus);
            desiredvCpus(model.desiredvCpus);
            subnets(model.subnets);
            securityGroupIds(model.securityGroupIds);
            allocationStrategy(model.allocationStrategy);
            instanceTypes(model.instanceTypes);
            ec2KeyPair(model.ec2KeyPair);
            instanceRole(model.instanceRole);
            tags(model.tags);
            placementGroup(model.placementGroup);
            bidPercentage(model.bidPercentage);
            launchTemplate(model.launchTemplate);
            ec2Configuration(model.ec2Configuration);
            updateToLatestImageVersion(model.updateToLatestImageVersion);
            type(model.type);
            imageId(model.imageId);
        }

        public final Integer getMinvCpus() {
            return minvCpus;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final Integer getMaxvCpus() {
            return maxvCpus;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final Integer getDesiredvCpus() {
            return desiredvCpus;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(CRUpdateAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final Collection<String> getInstanceTypes() {
            if (instanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypes;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final String getEc2KeyPair() {
            return ec2KeyPair;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final String getInstanceRole() {
            return instanceRole;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final Integer getBidPercentage() {
            return bidPercentage;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final List<Ec2Configuration.Builder> getEc2Configuration() {
            List<Ec2Configuration.Builder> result = Ec2ConfigurationListCopier.copyToBuilder(this.ec2Configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2Configuration(Collection<Ec2Configuration.BuilderImpl> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copyFromBuilder(ec2Configuration);
        }

        @Override
        public final Builder ec2Configuration(Collection<Ec2Configuration> ec2Configuration) {
            this.ec2Configuration = Ec2ConfigurationListCopier.copy(ec2Configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Ec2Configuration... ec2Configuration) {
            ec2Configuration(Arrays.asList(ec2Configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Configuration(Consumer<Ec2Configuration.Builder>... ec2Configuration) {
            ec2Configuration(Stream.of(ec2Configuration).map(c -> Ec2Configuration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUpdateToLatestImageVersion() {
            return updateToLatestImageVersion;
        }

        public final void setUpdateToLatestImageVersion(Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
        }

        @Override
        public final Builder updateToLatestImageVersion(Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        @Override
        public ComputeResourceUpdate build() {
            return new ComputeResourceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
