/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputeEnvironmentResponse extends BatchResponse implements
        ToCopyableBuilder<CreateComputeEnvironmentResponse.Builder, CreateComputeEnvironmentResponse> {
    private static final SdkField<String> COMPUTE_ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeEnvironmentName").getter(getter(CreateComputeEnvironmentResponse::computeEnvironmentName))
            .setter(setter(Builder::computeEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentName").build())
            .build();

    private static final SdkField<String> COMPUTE_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeEnvironmentArn").getter(getter(CreateComputeEnvironmentResponse::computeEnvironmentArn))
            .setter(setter(Builder::computeEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironmentArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPUTE_ENVIRONMENT_NAME_FIELD, COMPUTE_ENVIRONMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("computeEnvironmentName", COMPUTE_ENVIRONMENT_NAME_FIELD);
                    put("computeEnvironmentArn", COMPUTE_ENVIRONMENT_ARN_FIELD);
                }
            });

    private final String computeEnvironmentName;

    private final String computeEnvironmentArn;

    private CreateComputeEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
    }

    /**
     * <p>
     * The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and lowercase
     * letters, numbers, hyphens (-), and underscores (_).
     * </p>
     * 
     * @return The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and
     *         lowercase letters, numbers, hyphens (-), and underscores (_).
     */
    public final String computeEnvironmentName() {
        return computeEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public final String computeEnvironmentArn() {
        return computeEnvironmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentResponse)) {
            return false;
        }
        CreateComputeEnvironmentResponse other = (CreateComputeEnvironmentResponse) obj;
        return Objects.equals(computeEnvironmentName(), other.computeEnvironmentName())
                && Objects.equals(computeEnvironmentArn(), other.computeEnvironmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputeEnvironmentResponse").add("ComputeEnvironmentName", computeEnvironmentName())
                .add("ComputeEnvironmentArn", computeEnvironmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeEnvironmentName":
            return Optional.ofNullable(clazz.cast(computeEnvironmentName()));
        case "computeEnvironmentArn":
            return Optional.ofNullable(clazz.cast(computeEnvironmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateComputeEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputeEnvironmentResponse> {
        /**
         * <p>
         * The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and
         * lowercase letters, numbers, hyphens (-), and underscores (_).
         * </p>
         * 
         * @param computeEnvironmentName
         *        The name of the compute environment. It can be up to 128 characters long. It can contain uppercase and
         *        lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentName(String computeEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironmentArn
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironmentArn(String computeEnvironmentArn);
    }

    static final class BuilderImpl extends BatchResponse.BuilderImpl implements Builder {
        private String computeEnvironmentName;

        private String computeEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentResponse model) {
            super(model);
            computeEnvironmentName(model.computeEnvironmentName);
            computeEnvironmentArn(model.computeEnvironmentArn);
        }

        public final String getComputeEnvironmentName() {
            return computeEnvironmentName;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final String getComputeEnvironmentArn() {
            return computeEnvironmentArn;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        @Override
        public CreateComputeEnvironmentResponse build() {
            return new CreateComputeEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
