/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details for an attempt for a job attempt that an Amazon EKS container runs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksAttemptContainerDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EksAttemptContainerDetail.Builder, EksAttemptContainerDetail> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EksAttemptContainerDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONTAINER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerID").getter(getter(EksAttemptContainerDetail::containerID))
            .setter(setter(Builder::containerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerID").build()).build();

    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("exitCode").getter(getter(EksAttemptContainerDetail::exitCode)).setter(setter(Builder::exitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(EksAttemptContainerDetail::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONTAINER_ID_FIELD, EXIT_CODE_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("containerID", CONTAINER_ID_FIELD);
                    put("exitCode", EXIT_CODE_FIELD);
                    put("reason", REASON_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String containerID;

    private final Integer exitCode;

    private final String reason;

    private EksAttemptContainerDetail(BuilderImpl builder) {
        this.name = builder.name;
        this.containerID = builder.containerID;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The name of a container.
     * </p>
     * 
     * @return The name of a container.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID for the container.
     * </p>
     * 
     * @return The ID for the container.
     */
    public final String containerID() {
        return containerID;
    }

    /**
     * <p>
     * The exit code returned for the job attempt. A non-zero exit code is considered failed.
     * </p>
     * 
     * @return The exit code returned for the job attempt. A non-zero exit code is considered failed.
     */
    public final Integer exitCode() {
        return exitCode;
    }

    /**
     * <p>
     * A short (255 max characters) human-readable string to provide additional details for a running or stopped
     * container.
     * </p>
     * 
     * @return A short (255 max characters) human-readable string to provide additional details for a running or stopped
     *         container.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(containerID());
        hashCode = 31 * hashCode + Objects.hashCode(exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksAttemptContainerDetail)) {
            return false;
        }
        EksAttemptContainerDetail other = (EksAttemptContainerDetail) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(containerID(), other.containerID())
                && Objects.equals(exitCode(), other.exitCode()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksAttemptContainerDetail").add("Name", name()).add("ContainerID", containerID())
                .add("ExitCode", exitCode()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "containerID":
            return Optional.ofNullable(clazz.cast(containerID()));
        case "exitCode":
            return Optional.ofNullable(clazz.cast(exitCode()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EksAttemptContainerDetail, T> g) {
        return obj -> g.apply((EksAttemptContainerDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksAttemptContainerDetail> {
        /**
         * <p>
         * The name of a container.
         * </p>
         * 
         * @param name
         *        The name of a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID for the container.
         * </p>
         * 
         * @param containerID
         *        The ID for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerID(String containerID);

        /**
         * <p>
         * The exit code returned for the job attempt. A non-zero exit code is considered failed.
         * </p>
         * 
         * @param exitCode
         *        The exit code returned for the job attempt. A non-zero exit code is considered failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitCode(Integer exitCode);

        /**
         * <p>
         * A short (255 max characters) human-readable string to provide additional details for a running or stopped
         * container.
         * </p>
         * 
         * @param reason
         *        A short (255 max characters) human-readable string to provide additional details for a running or
         *        stopped container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String containerID;

        private Integer exitCode;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(EksAttemptContainerDetail model) {
            name(model.name);
            containerID(model.containerID);
            exitCode(model.exitCode);
            reason(model.reason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getContainerID() {
            return containerID;
        }

        public final void setContainerID(String containerID) {
            this.containerID = containerID;
        }

        @Override
        public final Builder containerID(String containerID) {
            this.containerID = containerID;
            return this;
        }

        public final Integer getExitCode() {
            return exitCode;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public EksAttemptContainerDetail build() {
            return new EksAttemptContainerDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
