/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the details of a job attempt for a job attempt by an Amazon EKS container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksAttemptDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EksAttemptDetail.Builder, EksAttemptDetail> {
    private static final SdkField<List<EksAttemptContainerDetail>> CONTAINERS_FIELD = SdkField
            .<List<EksAttemptContainerDetail>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(EksAttemptDetail::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksAttemptContainerDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksAttemptContainerDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EksAttemptContainerDetail>> INIT_CONTAINERS_FIELD = SdkField
            .<List<EksAttemptContainerDetail>> builder(MarshallingType.LIST)
            .memberName("initContainers")
            .getter(getter(EksAttemptDetail::initContainers))
            .setter(setter(Builder::initContainers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initContainers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EksAttemptContainerDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EksAttemptContainerDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EKS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eksClusterArn").getter(getter(EksAttemptDetail::eksClusterArn)).setter(setter(Builder::eksClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterArn").build()).build();

    private static final SdkField<String> POD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("podName").getter(getter(EksAttemptDetail::podName)).setter(setter(Builder::podName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podName").build()).build();

    private static final SdkField<String> POD_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("podNamespace").getter(getter(EksAttemptDetail::podNamespace)).setter(setter(Builder::podNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podNamespace").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(EksAttemptDetail::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(EksAttemptDetail::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("stoppedAt")
            .getter(getter(EksAttemptDetail::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(EksAttemptDetail::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD,
            INIT_CONTAINERS_FIELD, EKS_CLUSTER_ARN_FIELD, POD_NAME_FIELD, POD_NAMESPACE_FIELD, NODE_NAME_FIELD, STARTED_AT_FIELD,
            STOPPED_AT_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("containers", CONTAINERS_FIELD);
                    put("initContainers", INIT_CONTAINERS_FIELD);
                    put("eksClusterArn", EKS_CLUSTER_ARN_FIELD);
                    put("podName", POD_NAME_FIELD);
                    put("podNamespace", POD_NAMESPACE_FIELD);
                    put("nodeName", NODE_NAME_FIELD);
                    put("startedAt", STARTED_AT_FIELD);
                    put("stoppedAt", STOPPED_AT_FIELD);
                    put("statusReason", STATUS_REASON_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<EksAttemptContainerDetail> containers;

    private final List<EksAttemptContainerDetail> initContainers;

    private final String eksClusterArn;

    private final String podName;

    private final String podNamespace;

    private final String nodeName;

    private final Long startedAt;

    private final Long stoppedAt;

    private final String statusReason;

    private EksAttemptDetail(BuilderImpl builder) {
        this.containers = builder.containers;
        this.initContainers = builder.initContainers;
        this.eksClusterArn = builder.eksClusterArn;
        this.podName = builder.podName;
        this.podNamespace = builder.podNamespace;
        this.nodeName = builder.nodeName;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the final status of the containers for this job attempt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The details for the final status of the containers for this job attempt.
     */
    public final List<EksAttemptContainerDetail> containers() {
        return containers;
    }

    /**
     * For responses, this returns true if the service returned a value for the InitContainers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInitContainers() {
        return initContainers != null && !(initContainers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the init containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitContainers} method.
     * </p>
     * 
     * @return The details for the init containers.
     */
    public final List<EksAttemptContainerDetail> initContainers() {
        return initContainers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EKS cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon EKS cluster.
     */
    public final String eksClusterArn() {
        return eksClusterArn;
    }

    /**
     * <p>
     * The name of the pod for this job attempt.
     * </p>
     * 
     * @return The name of the pod for this job attempt.
     */
    public final String podName() {
        return podName;
    }

    /**
     * <p>
     * The namespace of the Amazon EKS cluster that the pod exists in.
     * </p>
     * 
     * @return The namespace of the Amazon EKS cluster that the pod exists in.
     */
    public final String podNamespace() {
        return podNamespace;
    }

    /**
     * <p>
     * The name of the node for this job attempt.
     * </p>
     * 
     * @return The name of the node for this job attempt.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the
     * <code>STARTING</code> state to the <code>RUNNING</code> state).
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from
     *         the <code>STARTING</code> state to the <code>RUNNING</code> state).
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt transitioned
     * from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt
     *         transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *         <code>FAILED</code>.
     */
    public final Long stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * A short, human-readable string to provide additional details for the current status of the job attempt.
     * </p>
     * 
     * @return A short, human-readable string to provide additional details for the current status of the job attempt.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInitContainers() ? initContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eksClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(podName());
        hashCode = 31 * hashCode + Objects.hashCode(podNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksAttemptDetail)) {
            return false;
        }
        EksAttemptDetail other = (EksAttemptDetail) obj;
        return hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && hasInitContainers() == other.hasInitContainers() && Objects.equals(initContainers(), other.initContainers())
                && Objects.equals(eksClusterArn(), other.eksClusterArn()) && Objects.equals(podName(), other.podName())
                && Objects.equals(podNamespace(), other.podNamespace()) && Objects.equals(nodeName(), other.nodeName())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(stoppedAt(), other.stoppedAt())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksAttemptDetail").add("Containers", hasContainers() ? containers() : null)
                .add("InitContainers", hasInitContainers() ? initContainers() : null).add("EksClusterArn", eksClusterArn())
                .add("PodName", podName()).add("PodNamespace", podNamespace()).add("NodeName", nodeName())
                .add("StartedAt", startedAt()).add("StoppedAt", stoppedAt()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "initContainers":
            return Optional.ofNullable(clazz.cast(initContainers()));
        case "eksClusterArn":
            return Optional.ofNullable(clazz.cast(eksClusterArn()));
        case "podName":
            return Optional.ofNullable(clazz.cast(podName()));
        case "podNamespace":
            return Optional.ofNullable(clazz.cast(podNamespace()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EksAttemptDetail, T> g) {
        return obj -> g.apply((EksAttemptDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksAttemptDetail> {
        /**
         * <p>
         * The details for the final status of the containers for this job attempt.
         * </p>
         * 
         * @param containers
         *        The details for the final status of the containers for this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<EksAttemptContainerDetail> containers);

        /**
         * <p>
         * The details for the final status of the containers for this job attempt.
         * </p>
         * 
         * @param containers
         *        The details for the final status of the containers for this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(EksAttemptContainerDetail... containers);

        /**
         * <p>
         * The details for the final status of the containers for this job attempt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<EksAttemptContainerDetail>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<EksAttemptContainerDetail>)
         */
        Builder containers(Consumer<EksAttemptContainerDetail.Builder>... containers);

        /**
         * <p>
         * The details for the init containers.
         * </p>
         * 
         * @param initContainers
         *        The details for the init containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initContainers(Collection<EksAttemptContainerDetail> initContainers);

        /**
         * <p>
         * The details for the init containers.
         * </p>
         * 
         * @param initContainers
         *        The details for the init containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initContainers(EksAttemptContainerDetail... initContainers);

        /**
         * <p>
         * The details for the init containers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #initContainers(List<EksAttemptContainerDetail>)}.
         * 
         * @param initContainers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.EksAttemptContainerDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initContainers(java.util.Collection<EksAttemptContainerDetail>)
         */
        Builder initContainers(Consumer<EksAttemptContainerDetail.Builder>... initContainers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EKS cluster.
         * </p>
         * 
         * @param eksClusterArn
         *        The Amazon Resource Name (ARN) of the Amazon EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksClusterArn(String eksClusterArn);

        /**
         * <p>
         * The name of the pod for this job attempt.
         * </p>
         * 
         * @param podName
         *        The name of the pod for this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podName(String podName);

        /**
         * <p>
         * The namespace of the Amazon EKS cluster that the pod exists in.
         * </p>
         * 
         * @param podNamespace
         *        The namespace of the Amazon EKS cluster that the pod exists in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podNamespace(String podNamespace);

        /**
         * <p>
         * The name of the node for this job attempt.
         * </p>
         * 
         * @param nodeName
         *        The name of the node for this job attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the
         * <code>STARTING</code> state to the <code>RUNNING</code> state).
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned
         *        from the <code>STARTING</code> state to the <code>RUNNING</code> state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt
         * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
         * <code>FAILED</code>.
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp (in milliseconds) for when the attempt was stopped. This happens when the attempt
         *        transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code>
         *        or <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Long stoppedAt);

        /**
         * <p>
         * A short, human-readable string to provide additional details for the current status of the job attempt.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide additional details for the current status of the job
         *        attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private List<EksAttemptContainerDetail> containers = DefaultSdkAutoConstructList.getInstance();

        private List<EksAttemptContainerDetail> initContainers = DefaultSdkAutoConstructList.getInstance();

        private String eksClusterArn;

        private String podName;

        private String podNamespace;

        private String nodeName;

        private Long startedAt;

        private Long stoppedAt;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EksAttemptDetail model) {
            containers(model.containers);
            initContainers(model.initContainers);
            eksClusterArn(model.eksClusterArn);
            podName(model.podName);
            podNamespace(model.podNamespace);
            nodeName(model.nodeName);
            startedAt(model.startedAt);
            stoppedAt(model.stoppedAt);
            statusReason(model.statusReason);
        }

        public final List<EksAttemptContainerDetail.Builder> getContainers() {
            List<EksAttemptContainerDetail.Builder> result = EksAttemptContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksAttemptContainerDetail.BuilderImpl> containers) {
            this.containers = EksAttemptContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksAttemptContainerDetail> containers) {
            this.containers = EksAttemptContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksAttemptContainerDetail... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksAttemptContainerDetail.Builder>... containers) {
            containers(Stream.of(containers).map(c -> EksAttemptContainerDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EksAttemptContainerDetail.Builder> getInitContainers() {
            List<EksAttemptContainerDetail.Builder> result = EksAttemptContainerDetailsCopier.copyToBuilder(this.initContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitContainers(Collection<EksAttemptContainerDetail.BuilderImpl> initContainers) {
            this.initContainers = EksAttemptContainerDetailsCopier.copyFromBuilder(initContainers);
        }

        @Override
        public final Builder initContainers(Collection<EksAttemptContainerDetail> initContainers) {
            this.initContainers = EksAttemptContainerDetailsCopier.copy(initContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(EksAttemptContainerDetail... initContainers) {
            initContainers(Arrays.asList(initContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(Consumer<EksAttemptContainerDetail.Builder>... initContainers) {
            initContainers(Stream.of(initContainers).map(c -> EksAttemptContainerDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEksClusterArn() {
            return eksClusterArn;
        }

        public final void setEksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
        }

        @Override
        public final Builder eksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
            return this;
        }

        public final String getPodName() {
            return podName;
        }

        public final void setPodName(String podName) {
            this.podName = podName;
        }

        @Override
        public final Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public final String getPodNamespace() {
            return podNamespace;
        }

        public final void setPodNamespace(String podNamespace) {
            this.podNamespace = podNamespace;
        }

        @Override
        public final Builder podNamespace(String podNamespace) {
            this.podNamespace = podNamespace;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public EksAttemptDetail build() {
            return new EksAttemptDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
