/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration of a Kubernetes <code>emptyDir</code> volume. An <code>emptyDir</code> volume is first
 * created when a pod is assigned to a node. It exists as long as that pod is running on that node. The
 * <code>emptyDir</code> volume is initially empty. All containers in the pod can read and write the files in the
 * <code>emptyDir</code> volume. However, the <code>emptyDir</code> volume can be mounted at the same or different paths
 * in each container. When a pod is removed from a node for any reason, the data in the <code>emptyDir</code> is deleted
 * permanently. For more information, see <a
 * href="https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <i>Kubernetes
 * documentation</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksEmptyDir implements SdkPojo, Serializable, ToCopyableBuilder<EksEmptyDir.Builder, EksEmptyDir> {
    private static final SdkField<String> MEDIUM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("medium")
            .getter(getter(EksEmptyDir::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medium").build()).build();

    private static final SdkField<String> SIZE_LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sizeLimit").getter(getter(EksEmptyDir::sizeLimit)).setter(setter(Builder::sizeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeLimit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDIUM_FIELD, SIZE_LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("medium", MEDIUM_FIELD);
                    put("sizeLimit", SIZE_LIMIT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String medium;

    private final String sizeLimit;

    private EksEmptyDir(BuilderImpl builder) {
        this.medium = builder.medium;
        this.sizeLimit = builder.sizeLimit;
    }

    /**
     * <p>
     * The medium to store the volume. The default value is an empty string, which uses the storage of the node.
     * </p>
     * <dl>
     * <dt>""</dt>
     * <dd>
     * <p>
     * <b>(Default)</b> Use the disk storage of the node.
     * </p>
     * </dd>
     * <dt>"Memory"</dt>
     * <dd>
     * <p>
     * Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are lost when the
     * node reboots, and any storage on the volume counts against the container's memory limit.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return The medium to store the volume. The default value is an empty string, which uses the storage of the
     *         node.</p>
     *         <dl>
     *         <dt>""</dt>
     *         <dd>
     *         <p>
     *         <b>(Default)</b> Use the disk storage of the node.
     *         </p>
     *         </dd>
     *         <dt>"Memory"</dt>
     *         <dd>
     *         <p>
     *         Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are lost
     *         when the node reboots, and any storage on the volume counts against the container's memory limit.
     *         </p>
     *         </dd>
     */
    public final String medium() {
        return medium;
    }

    /**
     * <p>
     * The maximum size of the volume. By default, there's no maximum size defined.
     * </p>
     * 
     * @return The maximum size of the volume. By default, there's no maximum size defined.
     */
    public final String sizeLimit() {
        return sizeLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        hashCode = 31 * hashCode + Objects.hashCode(sizeLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksEmptyDir)) {
            return false;
        }
        EksEmptyDir other = (EksEmptyDir) obj;
        return Objects.equals(medium(), other.medium()) && Objects.equals(sizeLimit(), other.sizeLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksEmptyDir").add("Medium", medium()).add("SizeLimit", sizeLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "medium":
            return Optional.ofNullable(clazz.cast(medium()));
        case "sizeLimit":
            return Optional.ofNullable(clazz.cast(sizeLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EksEmptyDir, T> g) {
        return obj -> g.apply((EksEmptyDir) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksEmptyDir> {
        /**
         * <p>
         * The medium to store the volume. The default value is an empty string, which uses the storage of the node.
         * </p>
         * <dl>
         * <dt>""</dt>
         * <dd>
         * <p>
         * <b>(Default)</b> Use the disk storage of the node.
         * </p>
         * </dd>
         * <dt>"Memory"</dt>
         * <dd>
         * <p>
         * Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are lost when
         * the node reboots, and any storage on the volume counts against the container's memory limit.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param medium
         *        The medium to store the volume. The default value is an empty string, which uses the storage of the
         *        node.</p>
         *        <dl>
         *        <dt>""</dt>
         *        <dd>
         *        <p>
         *        <b>(Default)</b> Use the disk storage of the node.
         *        </p>
         *        </dd>
         *        <dt>"Memory"</dt>
         *        <dd>
         *        <p>
         *        Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are
         *        lost when the node reboots, and any storage on the volume counts against the container's memory limit.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(String medium);

        /**
         * <p>
         * The maximum size of the volume. By default, there's no maximum size defined.
         * </p>
         * 
         * @param sizeLimit
         *        The maximum size of the volume. By default, there's no maximum size defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeLimit(String sizeLimit);
    }

    static final class BuilderImpl implements Builder {
        private String medium;

        private String sizeLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(EksEmptyDir model) {
            medium(model.medium);
            sizeLimit(model.sizeLimit);
        }

        public final String getMedium() {
            return medium;
        }

        public final void setMedium(String medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(String medium) {
            this.medium = medium;
            return this;
        }

        public final String getSizeLimit() {
            return sizeLimit;
        }

        public final void setSizeLimit(String sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        @Override
        public final Builder sizeLimit(String sizeLimit) {
            this.sizeLimit = sizeLimit;
            return this;
        }

        @Override
        public EksEmptyDir build() {
            return new EksEmptyDir(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
