/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the details for the Kubernetes resources of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EksPropertiesDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EksPropertiesDetail.Builder, EksPropertiesDetail> {
    private static final SdkField<EksPodPropertiesDetail> POD_PROPERTIES_FIELD = SdkField
            .<EksPodPropertiesDetail> builder(MarshallingType.SDK_POJO).memberName("podProperties")
            .getter(getter(EksPropertiesDetail::podProperties)).setter(setter(Builder::podProperties))
            .constructor(EksPodPropertiesDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("podProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POD_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("podProperties", POD_PROPERTIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final EksPodPropertiesDetail podProperties;

    private EksPropertiesDetail(BuilderImpl builder) {
        this.podProperties = builder.podProperties;
    }

    /**
     * <p>
     * The properties for the Kubernetes pod resources of a job.
     * </p>
     * 
     * @return The properties for the Kubernetes pod resources of a job.
     */
    public final EksPodPropertiesDetail podProperties() {
        return podProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(podProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPropertiesDetail)) {
            return false;
        }
        EksPropertiesDetail other = (EksPropertiesDetail) obj;
        return Objects.equals(podProperties(), other.podProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EksPropertiesDetail").add("PodProperties", podProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "podProperties":
            return Optional.ofNullable(clazz.cast(podProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EksPropertiesDetail, T> g) {
        return obj -> g.apply((EksPropertiesDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EksPropertiesDetail> {
        /**
         * <p>
         * The properties for the Kubernetes pod resources of a job.
         * </p>
         * 
         * @param podProperties
         *        The properties for the Kubernetes pod resources of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder podProperties(EksPodPropertiesDetail podProperties);

        /**
         * <p>
         * The properties for the Kubernetes pod resources of a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksPodPropertiesDetail.Builder} avoiding
         * the need to create one manually via {@link EksPodPropertiesDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksPodPropertiesDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #podProperties(EksPodPropertiesDetail)}.
         * 
         * @param podProperties
         *        a consumer that will call methods on {@link EksPodPropertiesDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #podProperties(EksPodPropertiesDetail)
         */
        default Builder podProperties(Consumer<EksPodPropertiesDetail.Builder> podProperties) {
            return podProperties(EksPodPropertiesDetail.builder().applyMutation(podProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EksPodPropertiesDetail podProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPropertiesDetail model) {
            podProperties(model.podProperties);
        }

        public final EksPodPropertiesDetail.Builder getPodProperties() {
            return podProperties != null ? podProperties.toBuilder() : null;
        }

        public final void setPodProperties(EksPodPropertiesDetail.BuilderImpl podProperties) {
            this.podProperties = podProperties != null ? podProperties.build() : null;
        }

        @Override
        public final Builder podProperties(EksPodPropertiesDetail podProperties) {
            this.podProperties = podProperties;
            return this;
        }

        @Override
        public EksPropertiesDetail build() {
            return new EksPropertiesDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
